/**
 * RIPE attribute.
 *
 * @author ottrey@ripe.net
 * @version $Version$
 *
 */
public class Query {
  
  private String qrytype;
  private boolean lookup;
  private String keytype;
  private String code;
  private String clars;
  private String sqlQuery;
  private String space;
  private String family;

  // -----------------oOo-----------------
  //              Constructors
  // -----------------oOo-----------------
  /**
   * Creates a Query structure.
   *               
   * @author ottrey@ripe.net
   *               
   */
  public Query(String qrytype, boolean lookup, String keytype, String code, String clars, String sqlQuery, String
  space, String family) {
    this.qrytype = qrytype;
    this.lookup = lookup;
    this.keytype = keytype;
    this.code = code;
    this.clars = clars;
    this.sqlQuery = sqlQuery;
    this.space = space;
    this.family = family;
  } // Query()

  /**
   * @return String C - structure in the form:
   * {
   *   R_SQL,
   *   Q_LOOKUP,
   *   WK_NAME,
   *   A_PN,
   *   "SELECT N01.pe_ro_id FROM %s WHERE %s",
   *   0, 
   *   0  
   * },
   * @param String the level of indenting.
   *
   */
  public String getStruct(String indent) {
    String result = new String();

    result += indent + "{" + "\n  ";
    result += indent + "R_" + qrytype.toUpperCase() + ",\n  ";
    if (lookup) {
      result += indent + "Q_LOOKUP";
    }                                       
    else {                                  
      result += indent + "Q_INVERSE";
    }                                       
    result += ",\n  ";
    result += indent + keytype.toUpperCase() + ",\n  ";
    result += indent + "A_" + code.toUpperCase() + ",\n  ";
    if (clars.equals("ANY")) {
      result += indent + "-1" + ",\n  ";
    }
    else {
      result += indent + "C_" + clars.toUpperCase() + ",\n  ";
    }
    result += indent + "\"" + sqlQuery.replace('\n', ' ') + "\""  + ",\n  ";
    if (space.length() == 0) {              
      result += indent + "0" + ",\n  ";
    }                                       
    else {                                  
      result += indent + space + ",\n  ";
    }                                       
    if (family.length() == 0) {              
      result += indent + "0" + "\n";
    }                                       
    else {                                  
      result += indent + family + "\n";
    }                                       
    result += indent + "},";

    return result;
  } //  getStruct()
 
  public static String startDoc() {
    String result = new String();
    
    result += "typedef struct _Query_t {\n";
    result += "  R_Type_t refer;\n";
    result += "  Q_Type_t querytype;\n";
    result += "  WK_Type keytype;\n";
    result += "  A_Type_t attribute;\n";
    result += "  C_Type_t class;\n";
    result += "  char * const query;\n";
    result += "  ip_space_t space;\n";
    result += "  rx_fam_t family;\n";
    result += "} Query_t;\n";
    result += "\n";
    result += "static struct _Query_t Query[] = {\n";

    return result;
  } // startDoc()

  public static String endDoc() {
    String result = new String();

    result += "  {\n";
    result += "    0,\n";
    result += "    0,\n";
    result += "    0,\n";
    result += "    0,\n";
    result += "    0,\n";
    result += "    NULL,\n";
    result += "    0,\n";
    result += "    0\n";
    result += "  }\n";
    result += "}; /* Query[] */\n";

    return result;
  } // endDoc()

} // Query

