/* rtsapselect.c - RTPM: map descriptors */

#ifndef	lint
static char *rcsid = "$Header: /a/vulcan/xtel/isode/isode-master/rtsap/RCS/rtsapselect.c,v 8.0 91/07/17 12:59:01 isode Rel $";
#endif

/* 
 * $Header: /a/vulcan/xtel/isode/isode-master/rtsap/RCS/rtsapselect.c,v 8.0 91/07/17 12:59:01 isode Rel $
 *
 *
 * $Log:	rtsapselect.c,v $
 * Revision 8.0  91/07/17  12:59:01  isode
 * Release 7.0
 * 
 * 
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/* LINTLIBRARY */

#include <stdio.h>
#include <signal.h>
#include "rtpkt.h"

/*    map association descriptors for select() */

int	RtSelectMask (sd, mask, nfds, rti)
int	sd;
fd_set *mask;
int    *nfds;
struct RtSAPindication *rti;
{
    SBV	    smask;
    int     result;
    register struct assocblk   *acb;

    missingP (mask);
    missingP (nfds);
    missingP (rti);

    smask = sigioblock ();

    rtsapPsig (acb, sd);

    if (acb -> acb_flags & ACB_PLEASE) {
	(void) sigiomask (smask);

	return rtsaplose (rti, RTS_WAITING, NULLCP, NULLCP);
    }

    result = (*acb -> acb_rtselectmask) (acb, mask, nfds, rti);

    (void) sigiomask (smask);

    return result;
}
