/* sys_init.c - System tailoring initialisation */

#ifndef lint
static char *rcsid = "$Header: /a/vulcan/xtel/isode/isode-master/quipu/RCS/sys_init.c,v 8.0 91/07/17 12:53:16 isode Rel $";
#endif

/*
 * $Header: /a/vulcan/xtel/isode/isode-master/quipu/RCS/sys_init.c,v 8.0 91/07/17 12:53:16 isode Rel $
 *
 *
 * $Log:	sys_init.c,v $
 * Revision 8.0  91/07/17  12:53:16  isode
 * Release 7.0
 * 
 * 
 */

/*
 *                                NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


#include <stdio.h>
#include "quipu/oid.h"
#include "tailor.h"
#include "logger.h"

extern char *dsaoidtable;
extern LLog * log_dsap;
extern time_t cache_timeout;
extern time_t retry_timeout;
extern time_t slave_timeout;

dsa_sys_init(acptr,avptr)
int *acptr;
char *** avptr;
{
char *name;
char **ptr;
int cnt;
extern int parse_line;
extern char dsa_mode;

	parse_line = 0;		/* stop 'line 1:' being printed in tailor file errors */
	dsa_mode = 1;

	name = **avptr;

	DLOG (log_dsap,LLOG_TRACE,("Initialisation"));

	cnt = *acptr;
	ptr = *avptr;
	dsa_tai_args (acptr,avptr);

	if (dsa_tai_init(name) != OK)
		fatal (-43,"Tailoring failed");

	dsa_tai_args (&cnt,&ptr);    /* second call IS needed !!! */

	DLOG (log_dsap,LLOG_TRACE,("Loading oid table (%s)",dsaoidtable));

	load_oid_table (dsaoidtable);

	if (retry_timeout == (time_t)0)
		retry_timeout = cache_timeout;

	if (slave_timeout == (time_t)0)
		slave_timeout = cache_timeout;

	DLOG (log_dsap,LLOG_TRACE,("*** Starting ***"));

}
