/* code_word.c - define code words for one dimensional encoding */

#ifndef	lint
static char *rcsid = "$Header: /a/vulcan/xtel/isode/isode-master/others/quipu/photo/RCS/code_word.c,v 8.0 91/07/17 13:16:00 isode Rel $";
#endif

/* 
 * $Header: /a/vulcan/xtel/isode/isode-master/others/quipu/photo/RCS/code_word.c,v 8.0 91/07/17 13:16:00 isode Rel $
 *
 *
 * $Log:	code_word.c,v $
 * Revision 8.0  91/07/17  13:16:00  isode
 * Release 7.0
 * 
 * 
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */



#include <stdio.h>
#include "quipu/photo.h"

extern int PIC_LINESIZE;

/* The following are declarations of the code words that are used with one
/* dimensional encoding.   The first number in each pair give the length
/* of the string, the second gives the string in hex, starting at the 13th bit
/* position.
/* The declarations are made this way so that the arays are made at compile
/* time as opposed to run time.
*/


/* White terminal run lengths */

static code_word wt_term [] = {
		{ 8 , 0x6a0  },         /* 0 : 00110101      */
		{ 6 , 0x380  },         /* 1 : 000111        */
		{ 4 , 0xe00  },         /* 2 : 0111          */
		{ 4 , 0x1000 },         /* 3 : 1000          */
		{ 4 , 0x1600 },         /* 4 : 1011          */
		{ 4 , 0x1800 },         /* 5 : 1100          */
		{ 4 , 0x1c00 },         /* 6 : 1110          */
		{ 4 , 0x1e00 },         /* 7 : 1111          */
		{ 5 , 0x1300 },         /* 8 : 10011         */
		{ 5 , 0x1400 },         /* 9 : 10100         */
		{ 5 , 0x700  },         /* 10: 00111         */
		{ 5 , 0x800  },         /* 11: 01000         */
		{ 6 , 0x400  },         /* 12: 001000        */
		{ 6 , 0x180  },         /* 13: 000011        */
		{ 6 , 0x1a00 },         /* 14: 110100        */
		{ 6 , 0x1a80 },         /* 15: 110101        */
		{ 6 , 0x1500 },         /* 16: 101010        */
		{ 6 , 0x1580 },         /* 17: 101011        */
		{ 7 , 0x9c0  },         /* 18: 0100111       */
		{ 7 , 0x300  },         /* 19: 0001100       */
		{ 7 , 0x200  },         /* 20: 0001000       */
		{ 7 , 0x5c0  },         /* 21: 0010111       */
		{ 7 , 0xc0   },         /* 22: 0000011       */
		{ 7 , 0x100  },         /* 23: 0000100       */
		{ 7 , 0xa00  },         /* 24: 0101000       */
		{ 7 , 0xac0  },         /* 25: 0101011       */
		{ 7 , 0x4c0  },         /* 26: 0010011       */
		{ 7 , 0x900  },         /* 27: 0100100       */
		{ 7 , 0x600  },         /* 28: 0011000       */
		{ 8 , 0x40   },         /* 29: 00000010      */
		{ 8 , 0x60   },         /* 30: 00000011      */
		{ 8 , 0x340  },         /* 31: 00011010      */
		{ 8 , 0x360  },         /* 32: 00011011      */
		{ 8 , 0x240  },         /* 33: 00010010      */
		{ 8 , 0x260  },         /* 34: 00010011      */
		{ 8 , 0x280  },         /* 35: 00010100      */
		{ 8 , 0x2a0  },         /* 36: 00010101      */
		{ 8 , 0x2c0  },         /* 37: 00010110      */
		{ 8 , 0x2e0  },         /* 38: 00010111      */
		{ 8 , 0x500  },         /* 39: 00101000      */
		{ 8 , 0x520  },         /* 40: 00101001      */
		{ 8 , 0x540  },         /* 41: 00101010      */
		{ 8 , 0x560  },         /* 42: 00101011      */
		{ 8 , 0x580  },         /* 43: 00101100      */
		{ 8 , 0x5a0  },         /* 44: 00101101      */
		{ 8 , 0x80   },         /* 45: 00000100      */
		{ 8 , 0xa0   },         /* 46: 00000101      */
		{ 8 , 0x140  },         /* 47: 00001010      */
		{ 8 , 0x160  },         /* 48: 00001011      */
		{ 8 , 0xa40  },         /* 49: 01010010      */
		{ 8 , 0xa60  },         /* 50: 01010011      */
		{ 8 , 0xa80  },         /* 51: 01010100      */
		{ 8 , 0xaa0  },         /* 52: 01010101      */
		{ 8 , 0x480  },         /* 53: 00100100      */
		{ 8 , 0x4a0  },         /* 54: 00100101      */
		{ 8 , 0xb00  },         /* 55: 01011000      */
		{ 8 , 0xb20  },         /* 56: 01011001      */
		{ 8 , 0xb40  },         /* 57: 01011010      */
		{ 8 , 0xb60  },         /* 58: 01011011      */
		{ 8 , 0x940  },         /* 59: 01001010      */
		{ 8 , 0x960  },         /* 60: 01001011      */
		{ 8 , 0x640  },         /* 61: 00110010      */
		{ 8 , 0x660  },         /* 62: 00110011      */
		{ 8 , 0x680  },         /* 63: 00110100      */
	};

/* Black terminal run lengths */

static code_word bl_term [] = {
		{ 10, 0x1b8  },         /* 0 : 0000110111    */
		{ 3 , 0x800  },         /* 1 : 010           */
		{ 2 , 0x1800 },         /* 2 : 11            */
		{ 2 , 0x1000 },         /* 3 : 10            */
		{ 3 , 0xc00  },         /* 4 : 011           */
		{ 4 , 0x600  },         /* 5 : 0011          */
		{ 4 , 0x400  },         /* 6 : 0010          */
		{ 5 , 0x300  },         /* 7 : 00011         */
		{ 6 , 0x280  },         /* 8 : 000101        */
		{ 6 , 0x200  },         /* 9 : 000100        */
		{ 7 , 0x100  },         /* 10: 0000100       */
		{ 7 , 0x140  },         /* 11: 0000101       */
		{ 7 , 0x1c0  },         /* 12: 0000111       */
		{ 8 , 0x80   },         /* 13: 00000100      */
		{ 8 , 0xe0   },         /* 14: 00000111      */
		{ 9 , 0x180  },         /* 15: 000011000     */
		{ 10, 0xb8   },         /* 16: 0000010111    */
		{ 10, 0xc0   },         /* 17: 0000011000    */
		{ 10, 0x40   },         /* 18: 0000001000    */
		{ 11, 0x19c  },         /* 19: 00001100111   */
		{ 11, 0x1a0  },         /* 20: 00001101000   */
		{ 11, 0x1b0  },         /* 21: 00001101100   */
		{ 11, 0xdc   },         /* 22: 00000110111   */
		{ 11, 0xa0   },         /* 23: 00000101000   */
		{ 11, 0x5c   },         /* 24: 00000010111   */
		{ 11, 0x60   },         /* 25: 00000011000   */
		{ 12, 0x194  },         /* 26: 000011001010  */
		{ 12, 0x196  },         /* 27: 000011001011  */
		{ 12, 0x198  },         /* 28: 000011001100  */
		{ 12, 0x19a  },         /* 29: 000011001101  */
		{ 12, 0xd0   },         /* 30: 000001101000  */
		{ 12, 0xd2   },         /* 31: 000001101001  */
		{ 12, 0xd4   },         /* 32: 000001101010  */
		{ 12, 0xd6   },         /* 33: 000001101011  */
		{ 12, 0x1a4  },         /* 34: 000011010010  */
		{ 12, 0x1a6  },         /* 35: 000011010011  */
		{ 12, 0x1a8  },         /* 36: 000011010100  */
		{ 12, 0x1aa  },         /* 37: 000011010101  */
		{ 12, 0x1ac  },         /* 38: 000011010110  */
		{ 12, 0x1ae  },         /* 39: 000011010111  */
		{ 12, 0xd8   },         /* 40: 000001101100  */
		{ 12, 0xda   },         /* 41: 000001101101  */
		{ 12, 0x1b4  },         /* 42: 000011011010  */
		{ 12, 0x1b6  },         /* 43: 000011011011  */
		{ 12, 0xa8   },         /* 44: 000001010100  */
		{ 12, 0xaa   },         /* 45: 000001010101  */
		{ 12, 0xac   },         /* 46: 000001010110  */
		{ 12, 0xae   },         /* 47: 000001010111  */
		{ 12, 0xc8   },         /* 48: 000001100100  */
		{ 12, 0xca   },         /* 49: 000001100101  */
		{ 12, 0xa4   },         /* 50: 000001010010  */
		{ 12, 0xa6   },         /* 51: 000001010011  */
		{ 12, 0x48   },         /* 52: 000000100100  */
		{ 12, 0x6e   },         /* 53: 000000110111  */
		{ 12, 0x70   },         /* 54: 000000111000  */
		{ 12, 0x4e   },         /* 55: 000000100111  */
		{ 12, 0x50   },         /* 56: 000000101000  */
		{ 12, 0xb0   },         /* 57: 000001011000  */
		{ 12, 0xb2   },         /* 58: 000001011001  */
		{ 12, 0x56   },         /* 59: 000000101011  */
		{ 12, 0x58   },         /* 60: 000000101100  */
		{ 12, 0xb4   },         /* 61: 000001011010  */
		{ 12, 0xcc   },         /* 62: 000001100110  */
		{ 12, 0xce   },         /* 63: 000001100111  */
	};

/* White make up codes */

static code_word wt_make [] = {
		{ 5 , 0x1b00 },         /* 64  : 11011         */
		{ 5 , 0x1200 },         /* 128 : 10010         */
		{ 6 , 0xb80  },         /* 192 : 010111        */
		{ 7 , 0xdc0  },         /* 256 : 0110111       */
		{ 8 , 0x6c0  },         /* 320 : 00110110      */
		{ 8 , 0x6e0  },         /* 384 : 00110111      */
		{ 8 , 0xc80  },         /* 448 : 01100100      */
		{ 8 , 0xca0  },         /* 512 : 01100101      */
		{ 8 , 0xd00  },         /* 576 : 01101000      */
		{ 8 , 0xce0  },         /* 640 : 01100111      */
		{ 9 , 0xcc0  },         /* 704 : 011001100     */
		{ 9 , 0xcd0  },         /* 768 : 011001101     */
		{ 9 , 0xd20  },         /* 832 : 011010010     */
		{ 9 , 0xd30  },         /* 896 : 011010011     */
		{ 9 , 0xd40  },         /* 960 : 011010100     */
		{ 9 , 0xd50  },         /* 1024: 011010101     */
		{ 9 , 0xd60  },         /* 1088: 011010110     */
		{ 9 , 0xd70  },         /* 1152: 011010111     */
		{ 9 , 0xd80  },         /* 1216: 011011000     */
		{ 9 , 0xd90  },         /* 1280: 011011001     */
		{ 9 , 0xda0  },         /* 1344: 011011010     */
		{ 9 , 0xdb0  },         /* 1408: 011011011     */
		{ 9 , 0x980  },         /* 1472: 010011000     */
		{ 9 , 0x990  },         /* 1536: 010011001     */
		{ 9 , 0x9a0  },         /* 1600: 010011010     */
		{ 6 , 0xc00  },         /* 1664: 011000        */
		{ 9 , 0x9b0  },         /* 1728: 010011011     */
		{ 11, 0x20   },         /* 1792: 00000001000   */
		{ 11, 0x30   },         /* 1856: 00000001100   */
		{ 11, 0x34   },         /* 1920: 00000001101   */
		{ 12, 0x24   },         /* 1984: 000000010010  */
		{ 12, 0x26   },         /* 2048: 000000010011  */
	};

/* Black make up codes */

static code_word bl_make [] = {
		{ 10, 0x78   },         /* 64  : 0000001111    */
		{ 12, 0x190  },         /* 128 : 000011001000  */
		{ 12, 0x192  },         /* 192 : 000011001001  */
		{ 12, 0xb6   },         /* 256 : 000001011011  */
		{ 12, 0x66   },         /* 320 : 000000110011  */
		{ 12, 0x68   },         /* 384 : 000000110100  */
		{ 12, 0x6a   },         /* 448 : 000000110101  */
		{ 13, 0x6c   },         /* 512 : 0000001101100 */
		{ 13, 0x6d   },         /* 576 : 0000001101101 */
		{ 13, 0x4a   },         /* 640 : 0000001001010 */
		{ 13, 0x4b   },         /* 704 : 0000001001011 */
		{ 13, 0x4c   },         /* 768 : 0000001001100 */
		{ 13, 0x4d   },         /* 832 : 0000001001101 */
		{ 13, 0x72   },         /* 896 : 0000001110010 */
		{ 13, 0x73   },         /* 960 : 0000001110011 */
		{ 13, 0x74   },         /* 1024: 0000001110100 */
		{ 13, 0x75   },         /* 1088: 0000001110101 */
		{ 13, 0x76   },         /* 1152: 0000001110110 */
		{ 13, 0x77   },         /* 1216: 0000001110111 */
		{ 13, 0x52   },         /* 1280: 0000001010010 */
		{ 13, 0x53   },         /* 1344: 0000001010011 */
		{ 13, 0x54   },         /* 1408: 0000001010100 */
		{ 13, 0x55   },         /* 1472: 0000001010101 */
		{ 13, 0x5a   },         /* 1536: 0000001011010 */
		{ 13, 0x5b   },         /* 1600: 0000001011011 */
		{ 13, 0x64   },         /* 1664: 0000001100100 */
		{ 13, 0x65   },         /* 1728: 0000001100101 */
		{ 11, 0x20   },         /* 1792: 00000001000   */
		{ 11, 0x30   },         /* 1856: 00000001100   */
		{ 11, 0x34   },         /* 1920: 00000001101   */
		{ 12, 0x24   },         /* 1984: 000000010010  */
		{ 12, 0x26   },         /* 2048: 000000010011  */
	};




/* ROUTINE:     Get_code ()                                             */
/*                                                                      */
/* SYNOPSIS:    Gets a code word from an array given the run_length     */
/*              and the colour (0 = white, 1 = black)                   */

extern int forcesize;

full_code
get_code (run, colour)

char    colour;
int     run;
{

full_code result;
   result.make.length = 0;
   if (run > (forcesize ? forcesize : PIC_LINESIZE))
	(void) fprintf (stderr,"Run too long\n");

   if (colour  ==  WHITE) {
      if  (run > 63)
	 result.make = wt_make [(run/64)-1];
      result.term = wt_term [run%64];

   } else {
      if  (run > 63)
	 result.make = bl_make [(run/64)-1];
      result.term = bl_term [run%64];
   }

   return (result);

}
