/*
 * Copyright (c) 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static  char rcsid[] =
    "@(#)$Header: hash.c,v 1.3 91/07/16 17:34:02 leres Exp $ (LBL)";
#endif

/*
 * hash - hash utilities
 */

#include <stdio.h>
#include <sys/types.h>
#include <ctype.h>
#ifdef SYSV
#define bzero(s,l) memset((s), 0, (l))
#endif

#include "hash.h"
#include "util.h"

static struct hash htable[NGROUP];

/* Updates ngnp as a side effect */
int hashgroup(ngnp)
	register char **ngnp;
{
	register int h;

	h = 0;
	for (; **ngnp != '\0' && **ngnp != '/'; ++*ngnp)
		h = (h * 31 + (int)**ngnp) % NGROUP;
	return(h);
}

hashadd(ngn, t)
	char *ngn;
	time_t t;
{
	register int h;
	register int len;
	register struct hash *hp;
	char *cp;
	char buf[128];

	strcpy(buf, ngn);
	strcat(buf, "/");
	cp = buf;
	h = hashgroup(&cp);
	hp = &htable[h];

	len = strlen(buf);
	if (hp->ngn == 0) {
		hp->ngn = savestr(buf);
		hp->to = t;
		hp->len = len;
		return(1);
	} else {
		hp = (struct hash *)mymalloc(sizeof(struct hash), "hash");
		bzero((char *)hp, sizeof(*hp));
		hp->ngn = savestr(buf);
		hp->to = t;
		hp->len = len;
		hp->next = htable[h].next;
		htable[h].next = hp;
		return(0);
	}
}

time_t
hashfind(h, ngn)
	register int h;
	char *ngn;
{
	register struct hash *hp;

	if (h < 0 || h > NGROUP)
		return(-1);

	for (hp = &htable[h]; hp; hp = hp->next)
		if (hp->ngn && strncmp(hp->ngn, ngn, hp->len) == 0)
			return(hp->to);
	return(-1);
}

hashdump()
{
	register int h;
	register struct hash *hp;
	int col, maxcol;
	int i;

	col = 0;
	maxcol = 0;
	(void)printf("------\nDiagnostic hash dump:\n");
	for (h = 0; h < NGROUP; ++h) {
		i = 0;
		for (hp = &htable[h]; hp; hp = hp->next) {
			if (hp->ngn)
				(void)printf("%4d: %d\t%s (%d)\n",
				    h, hp->to, hp->ngn, hp->len);
			if (hp->next) {
				++col;
				++i;
			}
		}
		if (i > maxcol)
			maxcol = i;
	}
	(void)printf("\n------\nHash stats:\n");
	printf("%d collisions (%d max)\n", col, maxcol);
}
