      PROGRAM invgamma_host
      implicit none
      include 'fpvm3.h'
      real*8 x, y, eps
      real*8 xmin, xmax, xdelta
      real*8 ymin, ymax, ydelta
      integer nx, ny, i, j, nterms
      integer sendcount, recvcount, nbytes
      complex*16 z, res
      integer NPROC, MAXPROC, bufid, rc, msglabel, lbal
      parameter (MAXPROC = 100)
      integer taskid(0:MAXPROC-1), dest, from, k, kk
      real*8 nterms_per_cpu(0:MAXPROC-1)
      integer work_piece(0:MAXPROC-1)
      character*32 hostname
      
      print *,'Number of server processes (1-100) ?'
      read *,NPROC
      NPROC = MAX(1,MIN(NPROC,MAXPROC))
      print *,'Would you like to load balance (1=yes, 0=no) ?'
      read *,lbal
      
      CALL create_servers(NPROC,taskid)
      do k=0,NPROC-1
         nterms_per_cpu(k) = 0
         work_piece(k) = 0
      enddo
      
      print *,'Error tolerance, xmin, xmax, nx, ymin, ymax, ny ?'
      read *,eps, xmin, xmax, nx, ymin, ymax, ny
      print 1002,eps, xmin, xmax, nx, ymin, ymax, ny

      xdelta = 0
      nx = nx - 1
      if (nx.gt.0) xdelta = (xmax-xmin)/nx
      ydelta = 0  
      ny = ny - 1
      if (ny.gt.0) ydelta = (ymax-ymin)/ny
      
      sendcount = 0
      recvcount = 0
      if ((nx+1) * (ny+1) .lt. NPROC) then
         print *,'Error: Number of points less than NPROC'
         goto 2222
      endif

      print 1001,'CPU#','Nterms','X','Y',
     $     'RE(FUN)','IM(FUN)','ABS(FUN)'
      
      do j=0,ny
         y = ymin + j*ydelta
         do i=0,nx
            x = xmin + i*xdelta          
c           z = cmplx(x,y)
c           res = invgamma(z,eps,nterms)
            if (sendcount .ge. NPROC) then
               msglabel = 2000
               CALL PVMFrecv(-1,msglabel,bufid)
               recvcount = recvcount + 1
               CALL PVMFbufinfo(bufid,nbytes,msglabel,dest,rc)
               CALL PVMFunpack(INTEGER4,nterms,1,1,rc)
               CALL PVMFunpack(COMPLEX16,z,1,1,rc)
               CALL PVMFunpack(COMPLEX16,res,1,1,rc)
               do k=0,NPROC-1
                  if (taskid(k).eq.dest) then
                     from = k
                     nterms_per_cpu(k) = nterms_per_cpu(k) + nterms
                  endif
               enddo
               print 1000,from,nterms,z,res,abs(res)
            else
               from = sendcount
            endif

            if (lbal .le. 0) from = mod(sendcount,NPROC)
            dest = taskid(from)

            msglabel = 1000
            CALL PVMFinitsend(PvmDataDefault,rc)
            CALL PVMFpack(REAL8,eps,1,1,rc)
            CALL PVMFpack(REAL8,x,1,1,rc)
            CALL PVMFpack(REAL8,y,1,1,rc)
            CALL PVMFsend(dest,msglabel,rc)
c=          print 1004,'CPU#',from,' got now a piece of work to do'
            work_piece(from) = work_piece(from) + 1
            sendcount = sendcount + 1
         enddo
      enddo
      
      do kk=1,NPROC
         msglabel = 2000
         CALL PVMFrecv(-1,msglabel,bufid)
         recvcount = recvcount + 1
         CALL PVMFbufinfo(bufid,nbytes,msglabel,dest,rc)
         CALL PVMFunpack(INTEGER4,nterms,1,1,rc)
         CALL PVMFunpack(COMPLEX16,z,1,1,rc)
         CALL PVMFunpack(COMPLEX16,res,1,1,rc)
         do k=0,NPROC-1
            if (taskid(k).eq.dest) then
               from = k
               nterms_per_cpu(k) = nterms_per_cpu(k) + nterms
            endif
         enddo
         print 1000,from,nterms,z,res,abs(res)
      enddo

 2222 continue
      print *,'send/recv counts:',sendcount,recvcount
      
      do k=0,NPROC-1
         if (sendcount .gt. 0) then
            print 1003,k,nterms_per_cpu(k),
     $           work_piece(k), nterms_per_cpu(k)/work_piece(k)
         endif
         CALL PVMFpstat(taskid(k),rc)
         if (rc .eq. 0) then
            CALL get_taskhost(taskid(k),hostname)
            print 1006,'Killing task#',taskid(k),
     $           ' at CPU#',k,hostname
            CALL PVMFkill(taskid(k),rc)
         endif
      enddo
      
 1000 format(1x,i4,i9,1p,5E13.5)            
 1001 format(1x,a4,a9,5a13)
 1002 format(1x,1p,E13.5,2(2g13.5,i4))
 1003 format(1x,'CPU#',i3,': Nterms=',f10.0,
     $     ' Work pieces=',i6,'. Average=',f10.2)
 1004 format(1x,a,z10,a)
 1005 format(1x,46x,'  Total=',f10.2)
 1006 format(1x,a,'t',z8.8,a,i3,' at ',a)
      END
      
      SUBROUTINE create_servers(NPROC,taskid)
      implicit none
      include 'fpvm3.h'
      character*32 a_out
      integer NPROC
      integer taskid(0:NPROC-1)
      integer mytid, pos, rc
      
      CALL PVMFmytid(mytid)
      CALL getarg(0,a_out)
      pos = index(a_out,'host')
      a_out(pos:pos+3) = 'node'
      print *,'Creating ',NPROC,' copies of '//a_out
      CALL PVMFspawn(a_out,     
     $     PvmTaskDefault,'*',
     $     NPROC,taskid(0),
     $     rc)
      END

      SUBROUTINE get_taskhost(taskid,hostname)
      implicit none
      include 'fpvm3.h'
      integer taskid, pvmd_of_hostname, i
      character*32 hostname, host_string, arch_string
      integer nhost, narch, pvmd_taskid, speed, rc

      CALL PVMFtidtohost(taskid, pvmd_of_hostname)
      hostname = '<UNKNOWN>'
      CALL PVMFconfig(nhost, narch, pvmd_taskid,
     $     host_string, arch_string, speed, rc)
      CALL PVMFconfig(-1, narch, pvmd_taskid,
     $     host_string, arch_string, speed, rc)
      do i=1,nhost
         CALL PVMFconfig(nhost, narch, pvmd_taskid,
     $        host_string, arch_string, speed, rc)
         if (pvmd_taskid .eq. pvmd_of_hostname) then
            hostname = host_string
            goto 99
         endif
      enddo
 99   continue
      CALL PVMFconfig(-1, narch, pvmd_taskid,
     $     host_string, arch_string, speed, rc)
      END
