      PROGRAM sequential_laplace_solver
      implicit none        
      integer m, n, i, j, iters, maxiters
      parameter (m=6, n=m)
      real*8 T(0:m+1,0:n+1), dTnorm2, eps
      parameter (eps = 1E-9, maxiters = 1.0/eps)
      real*8 Tbuf_curr_j(0:m+1), Tbuf_prev_j(0:m+1)

      print *,'Laplace: System-size mxn=',m,n
      CALL initialize(T,m,n)
      iters = 0
      print 1001,'Iteration','Error-norm2'
 100  continue
      iters = iters + 1
      dTnorm2 = 0
      CALL copybuf(Tbuf_prev_j, T, m, 0)
      do j=1,n
         CALL copybuf(Tbuf_curr_j, T, m, j)
         do i=1,m                   
            T(i,j) = 0.25*(Tbuf_curr_j(i-1) +
     $                     Tbuf_curr_j(i+1) +
     $                     Tbuf_prev_j(i)   + T(i,j+1) )
         enddo
         do i=1,m
            dTnorm2 = dTnorm2 + (T(i,j) - Tbuf_curr_j(i))**2
         enddo
         if (j .lt. n)
     $        CALL copybuf(Tbuf_prev_j, Tbuf_curr_j, m, 0)
      enddo
      if (dTnorm2 .lt. eps .or. iters .ge. maxiters) goto 99
      if (mod(iters,25) .eq. 0) print 1000,iters,dTnorm2
      goto 100
 99   continue
      print 1000,iters,dTnorm2,eps
      CALL print_solution(iters,T,m,n)
 1000 format(1x,i10,1p,G15.7,:,' < ',G15.7)
 1001 format(1x,a10,a15)
      END
      
      SUBROUTINE initialize(T,m,n)
      implicit none
      integer m, n, i, j
      real*8 T(0:m+1,0:n+1), const
      parameter (const = 100)
      T(0,0) = const/2
      do i=1,m
         T(i,0) = const
      enddo
      T(m+1,0) = const/2
      do j=1,n+1
         do i=0,m+1
            T(i,j) = 0
         enddo
      enddo
      END
      
      SUBROUTINE copybuf(to, from, m, j)
      implicit none
      integer m, j, i
      real*8 to(0:m+1), from(0:m+1,0:j)
      do i=0,m+1
         to(i) = from(i,j)
      enddo
      END
      
      SUBROUTINE print_solution(iters,T,m,n)
      implicit none
      integer iters,m, n, i, j
      real*8 T(0:m+1,0:n+1)
      print *,'Solution T: (# of iters =',iters,')'
      do j=n+1,0,-1
         print 1000,(T(i,j),i=0,m+1)
      enddo
 1000 format(1x,11f7.2)      
      END
