/*
 *  $Source: /localsw/UNICOS/ssh-1.2.22.lanl/RCS/ssh-unicos.h,v $
 *  $Revision: 1.6 $
 *  $Date: 1998-06-18 15:46:59-06 $
 *
 *  Purpose:
 *      Define prototypes for UNICOS unicos routines.
 *
 *  Author:		Randy Bremmer, March 1998
 *			Los Alamos National Laboratory
 *  Modification $Author: rrb $
 *  Maintenance and modification 
 *	$Log: ssh-unicos.h,v $
 *	Revision 1.6  1998-06-18 15:46:59-06  rrb
 *	Change definition of mls_validate to include the havepty
 *	argument.
 *
 *	Revision 1.5  1998-05-27 15:23:03-06  rrb
 *	LANL modifications.
 *	Include ssh-lanl.h.
 *
 *	Revision 1.3  1998-05-18 15:29:35-06  rrb
 *	Remove crayuser_disallowed.
 *	Add unicos_access_denied.
 *
 *	Revision 1.3  1998-05-18 14:45:51-06  rrb
 *	Replace crayuser_disallowed with unicos_access_denied.
 *
 *	Revision 1.2  1998-05-14 09:12:34-06  rrb
 *	Intermediate check-in.
 *	Fixed definition of FLAGREG and TmpDir.
 *	Add "const" in function prototypes where appropriate.
 *
 *	Revision 1.1  1998-05-13 14:49:49-06  rrb
 *	Initial revision
 *
 */
#ifndef	__ssh_unicos_
#define	__ssh_unicos_

# ifdef	CRAY
/* Function prototypes */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/usrv.h>


#define TRUE 1
#define FALSE 0
typedef int logical;
#define FLAGREG register logical

#if defined(__STDC__) || defined(__cplusplus)
# define P_(s) s
#else
# define P_(s) ()
#endif

#ifdef	LANL
# include "ssh-lanl.h"
#endif	LANL

extern	char*	TmpDir;		/* temporary directory name, valid only
				   in the ssh copy that execs the 
				   user's shell or command */

void	cancel_udb_authfail	P_(( void ));
void	catch_jobsignal		P_(( void ));
int	cray_setup		P_(( uid_t user_uid, const char *user_name, \
				     const char *ttyname ));
void	get_udbent		P_(( const char* user ));
void	get_unicos_connect_info	P_(( int sfd ));
void	ignore_jobsignal	P_(( void ));
void	register_udb_authfail	P_(( const char* user ));
void	set_seclabel		P_(( void ));
void	mls_validate		P_(( logical havepty ));
logical	pty_labeled		P_(( const char* devname ));
void	set_unicos_sockopts	P_(( int sfd ));
void	showusrv		P_(( const struct usrv* secval ));
void	showprivs		P_(( void ));
logical	unicos_access_denied	P_(( char** forced_command ));
void	unicos_init		P_(( void ));
void	update_udb		P_(( const char *user, uid_t uid, \
				     const char *ttyname, const char *host ));

# endif	CRAY
#endif	__ssh_unicos_
