/*
 * Copyright (c) 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static  char rcsid[] =
    "@(#)$Header: util.c,v 1.13 91/10/30 19:04:01 leres Exp $ (LBL)";
#endif

/*
 * util - random utility routines
 */

#include <stdio.h>
#include <sys/types.h>
#ifndef SYSV
#include <sys/time.h>
#else
#include <time.h>
#define bcopy(s,d,l) memmove((d),(s),(l))

#ifndef _POSIX_SOURCE
#if 0
typedef uint u_int;
#endif
#endif
#endif
#include <ctype.h>

#include "util.h"

extern char *malloc();

extern char *prog;

/* Return a malloc()ed copy of the passed string */
char *
savestr(s)
	register char *s;
{
	register char *cp;
	register int i;

	i = strlen(s) + 1;
	cp = mymalloc((u_int)i, "savestr");
	bcopy(s, cp, i);
	return(cp);
}

/* Failsafe version malloc() */
char *
mymalloc(size, what)
	u_int size;
	char *what;
{
	register char *cp;

	if ((cp = malloc(size)) == 0) {
		(void)fprintf(stderr,
		    "%s: Geordie: \"Damn! %s malloc() failed!\"\n", prog, what);
		exit(1);
		/* NOTREACHED */
	}
	return(cp);
}

/* Convert a long to a string */
char *
long2str(n)
	register long n;
{
	register int minus = 0;
	register char *cp;
	static char buf[32];

	if (n < 0) {
		n = -n;
		++minus;
	}

	cp = buf + sizeof(buf) - 1;
	*cp = '\0';
	do {
		*--cp = n % 10 + '0';
		n /= 10;
	} while (n > 0);

	if (minus)
		*--cp = '-';
	return(cp);
}

/* Convert from history newsgroup to article pathname */
char *
artpath(spool_dir, art)
	register char *spool_dir, *art;
{
	register char *cp;
	static char path[512];

	cp = path;
	(void) strcpy(cp, spool_dir);
	cp += strlen(cp);
	*cp++ = '/';

	while (*art != '/' && *art != '\0') {
		if (*art == '.')
			*cp++ = '/';
		else
			*cp++ = *art;
		++art;
	}
	if (*art == '/') {
		++art;
		*cp++ = '/';
	}
	while (isdigit(*art))
		*cp++ = *art++;
	*cp = '\0';

	return(path);
}

/* Format a delta time */
char *
fmtdelta(t)
	time_t t;
{
	register char *cp;
	register int d, h, m, s;
	int minus = 0;
	static char buf[132];

	d = h = m = s = 0;
	if (t < 0) {
		t = -t;
		++minus;
	}

	d = t / (24 * 60 * 60);
	t = t % (24 * 60 * 60);

	h = t / (60 * 60);
	t = t % (60 * 60);

	m = t / 60;
	s = t % 60;

	cp = buf + 1;
	(void)sprintf(cp, "%d %d:%02d:%02d", d, h, m, s);
	if (cp[0] == '0' && cp[1] == ' ') {
		cp += 2;
		if (cp[0] == '0' && cp[1] == ':') {
			cp += 2;
			if (cp[0] == '0')
				++cp;
		}
	}
	if (minus)
		*--cp = '-';
	return(cp);
}

static char *dow[7] = {
	"Sun",
	"Mon",
	"Tue",
	"Wed",
	"Thu",
	"Fri",
	"Sat"
};

static char *moy[12] = {
	"Jan",
	"Feb",
	"Mar",
	"Apr",
	"May",
	"Jun",
	"Jul",
	"Aug",
	"Sep",
	"Oct",
	"Nov",
	"Dec"
};

#define DOW(d) ((d) < 0 || (d) >= 7 ? "?" : dow[d])
#define MOY(m) ((m) < 0 || (m) >= 12 ? "?" : moy[(m)])

/* Format the time zone */
static char *
fmtzone(mw, isdst)
	int mw, isdst;
{
	char ch;
	static char buf[32];

	if (isdst)
		mw -= 60;
	if (mw < 0) {
		ch = '+';
		mw = -mw;
	} else {
		ch = '-';
	}
	(void)sprintf(buf, "%c%02d%02d", ch, mw / 60, mw % 60);
	return(buf);
}

/* Format date and time */
char *
fmtdate(t)
	time_t t;
{
	register struct tm *tm;
	static char buf[132];
	static int init = 0;
	static int zone;
#ifndef SYSV
	struct timeval tv;
	struct timezone tz;
#else
	extern long timezone;
#endif

	if (t == 0)
		return("<no date>");

	tm = localtime(&t);

	/* Initialize after call to localtime() */
	if (!init) {
		++init;
#ifndef SYSV
		/* XXX tv isn't needed except to get around kernel bug */
		(void)gettimeofday(&tv, &tz);
		zone = tz.tz_minuteswest;
#else
		zone = (int) (timezone / 60);
#endif
	}

	(void)sprintf(buf, "%s, %2d-%s-%d %2d:%02d:%02d %s (%s)",
	    DOW(tm->tm_wday),
	    tm->tm_mday,
	    MOY(tm->tm_mon),
	    tm->tm_year + 1900,
	    tm->tm_hour,
	    tm->tm_min,
	    tm->tm_sec,
	    fmtzone(zone, tm->tm_isdst),
#ifndef SYSV
	    timezone(zone, tm->tm_isdst)
#else
	    tzname[tm->tm_isdst]
#endif
	    );
	return(buf);
}
