/*
 * Copyright (c) 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static  char rcsid[] =
    "@(#)$Header: file.c,v 1.13 91/03/04 16:32:00 leres Exp $ (LBL)";
#endif

/*
 * file - file parsing routines
 */

#include <stdio.h>
#include <sys/types.h>
#ifndef SYSV
#include <strings.h>
#else
#define index strchr
#include <string.h>
#define rindex strrchr
#endif
#include <ctype.h>

extern char *prog;

/* Read and parse the active file */
readactive(f, fn)
	register FILE *f;
	int (*fn)();
{
	register int n;
	register char *cp;
	char line[1024];
	char *group;
	char mod;
	int nn, on;

	n = 0;
	while (fgets(line, sizeof(line), f)) {
		++n;
		cp = line;
		group = cp;
		if ((cp = index(cp, ' ')) == 0) {
			(void)fprintf(stderr,
			    "%s: active file syntax error #1 line %d\n",
			    prog, n);
			return(0);
		}
		*cp++ = '\0';
		nn = atoi(cp);
		if ((cp = index(cp, ' ')) == 0) {
			(void)fprintf(stderr,
			    "%s: active file syntax error #2 line %d\n",
			    prog, n);
			return(0);
		}
		++cp;
		on = atoi(cp);
		if ((cp = index(cp, ' ')) == 0) {
			(void)fprintf(stderr,
			    "%s: active file syntax error #3 line %d\n",
			    prog, n);
			return(0);
		}
		++cp;
		mod = *cp;

		/* Convert dots in group to slashes */
		for (cp = group; *cp != '\0'; ++cp)
			if (*cp == '.')
				*cp = '/';

		if (!(*fn)(group, nn, on, mod))
			return(0);
	}

	/* Paranoid safety check */
	if (ferror(f)) {
		(void)fprintf(stderr, "%s: ", prog);
		perror("readactive()");
		return(0);
	}

	return(1);
}

/* Read and parse the expire list */
readexplist(f, fn)
	register FILE *f;
	int (*fn)();
{
	register int n;
	register char *cp, *cp2;
	char line[1024];
	char *group, mod;
	int pri, days;

	n = 0;
	while (fgets(line, sizeof(line), f)) {
		++n;
		cp = line;
		cp2 = cp + strlen(cp) - 1;
		if (cp2 >= cp && *cp2 == '\n')
			*cp2++ = '\0';
		if (*cp == '\0' || *cp == '#')
			continue;

		group = cp;
		while (!isspace(*cp))
			++cp;
		if (!isspace(*cp)) {
			(void)fprintf(stderr,
			    "%s: explist file syntax error #1 line %d\n",
			    prog, n);
			return(0);
		}
		*cp++ = '\0';
		while (isspace(*cp))
			++cp;
		if (!isalpha(*cp)) {
			(void)fprintf(stderr,
			    "%s: explist file syntax error #2 line %d\n",
			    prog, n);
			return(0);
		}
		mod = *cp++;
		while (isspace(*cp))
			++cp;
		if (!isdigit(*cp)) {
			(void)fprintf(stderr,
			    "%s: explist file syntax error #3 line %d\n",
			    prog, n);
			return(0);
		}
		pri = atoi(cp);
		if (!isdigit(*cp)) {
			(void)fprintf(stderr,
			    "%s: explist file syntax error #4 line %d\n",
			    prog, n);
			return(0);
		}

		/* Days field is optional */
		while (isdigit(*cp))
			++cp;
		while (isspace(*cp))
			++cp;
		days = atoi(cp);

		/* Convert dots in group to slashes */
		for (cp = group; *cp != '\0'; ++cp)
			if (*cp == '.')
				*cp = '/';

		/* Make multiple calls for combined groups */
		do {
			if (cp = index(group, ','))
				*cp++ = '\0';
			if (!(*fn)(group, mod, pri, days))
				return(0);
			group = cp;
		} while (group);
	}

	/* Paranoid safety check */
	if (ferror(f)) {
		(void)fprintf(stderr, "%s: ", prog);
		perror("readexplist()");
		return(0);
	}

	return(1);
}
