
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <gl.h>
#include <device.h>

#include "fdefs.h"

#include "fvars_ext.com"

int gx_wpts0(idims,hbuff,cbuff,palette,fmat)
int idims[4];
unsigned char hbuff[],cbuff[];
unsigned char palette[PALBUFSIZE][3];
float fmat[][3];
{
	int err_ret;
	int xsiz,ysiz,hzsiz,czsiz;
	long xrate,yrate,lwidth;
	int xincr;
	Coord lrsize,btsize,rnear,rfar,ttz;
	int ix,iy,iscl;
	float sx,sy,sz;
	unsigned char *hbuf_ptr,*cbuf_ptr;
	short dev,val;
	float v1[3],v2[3],v3[3];
	long c1[3],c2[3],c3[3];
	int vc1,vc2,vc3;
	float xtrans,ytrans;
	short br,bg,bb;

	err_ret = 0;

	xsiz = idims[0];
	ysiz = idims[1];
	hzsiz = idims[2];
	czsiz = idims[3];

	xrate = (long)fmat[WFM][0];
	yrate = (long)fmat[WFM][1];
	lwidth = (long)fmat[WFM][2];

	xincr = xsiz * yrate;

	xtrans = (float)(xsiz - 1) / 2.0;
	ytrans = (float)(ysiz - 1) / 2.0;

	zbuffer(TRUE);
	concave(FALSE);

	lrsize = 1.33333333;
	btsize = 1.0;
	rnear = 5.0;
	rfar = 100.0;
	ttz = -6.5;

	loadmatrix(idmatrix);
	mmode(MVIEWING);
	window(-lrsize,lrsize,-btsize,btsize,rnear,rfar);

	loadmatrix(idmatrix);
	translate(0.0,0.0,ttz);

	lsetdepth(0, 0x7fffff);

	iscl = max((xsiz-1),(ysiz-1));
	sx = 1.0 / (float)iscl;
	sy = sx;
	sz = 1.0 / 255.0;

	br = (short)fmat[BKC][0];
	bg = (short)fmat[BKC][1];
	bb = (short)fmat[BKC][2];

	RGBcolor(br,bg,bb);
	clear();
	zclear();

	linewidth( (short)lwidth );

	pushmatrix();
	translate(fmat[TRA][0],fmat[TRA][1],fmat[TRA][2]);
	rot(fmat[ROT][2], 'z');
	rot(fmat[ROT][1], 'y');
	rot(fmat[ROT][0], 'x');
	scale(sx,sy,sz);
	scale(fmat[SCA][0],fmat[SCA][1],fmat[SCA][2]);

	hbuf_ptr = &hbuff[0];
	cbuf_ptr = &cbuff[0];
	for(iy = (ysiz - 1); iy >= yrate; iy-=yrate){
		if (qtest()){
			dev = qread(&val);
			if (dev == REDRAW){
				qenter(REDRAW,WID);
				err_ret = 1;
				break;
			}
			else if (dev == ESCKEY){
				qenter(ESCKEY,WID);
				err_ret = 1;
				break;
			}
		}
		for (ix=0; ix<(xsiz - xrate); ix+=xrate){
			vc1 = (int) *(cbuf_ptr + ix + xincr);
			vc2 = (int) *(cbuf_ptr + ix);
			vc3 = (int) *(cbuf_ptr + ix + xrate);

			v1[0] = (float)ix - xtrans;
			v1[1] = (float)(iy - yrate) - ytrans;
			v1[2] = (float) *(hbuf_ptr + ix + xincr);

			v2[0] = v1[0];
			v2[1] = (float)iy - ytrans;
			v2[2] = (float) *(hbuf_ptr + ix);

			v3[0] = (float)(ix + xrate) - xtrans;
			v3[1] = v2[1];
			v3[2] = (float) *(hbuf_ptr + ix + xrate);

			c1[0] = palette[vc1][0];
			c1[1] = palette[vc1][1];
			c1[2] = palette[vc1][2];

			c2[0] = palette[vc2][0];
			c2[1] = palette[vc2][1];
			c2[2] = palette[vc2][2];

			c3[0] = palette[vc3][0];
			c3[1] = palette[vc3][1];
			c3[2] = palette[vc3][2];

			bgnline();
				c3i(c1);
				v3f(v1);
				c3i(c2);
				v3f(v2);
				c3i(c3);
				v3f(v3);
			endline();
		}
		vc2 = (int) *(cbuf_ptr + ix + xincr);

		v2[0] = (float)ix - xtrans;
		v2[1] = (float)(iy - yrate) - ytrans;
		v2[2] = (float) *(hbuf_ptr + ix + xincr);

		c2[0] = palette[vc2][0];
		c2[1] = palette[vc2][1];
		c2[2] = palette[vc2][2];

		bgnline();
			c3i(c3);
			v3f(v3);
			c3i(c2);
			v3f(v2);
		endline();

		hbuf_ptr = hbuf_ptr + xincr;
		cbuf_ptr = cbuf_ptr + xincr;
	}

	for (ix=0; ix<(xsiz - xrate); ix+=xrate){
		vc1 = (int) *(cbuf_ptr + ix);
		vc2 = (int) *(cbuf_ptr + ix + xrate);

		v1[0] = (float)ix - xtrans;
		v1[1] = (float)iy - ytrans;
		v1[2] = (float) *(hbuf_ptr + ix);

		v2[0] = (float)(ix + xrate) - xtrans;
		v2[1] = v1[1];
		v2[2] = (float) *(hbuf_ptr + ix + xrate);

		c1[0] = palette[vc1][0];
		c1[1] = palette[vc1][1];
		c1[2] = palette[vc1][2];

		c2[0] = palette[vc2][0];
		c2[1] = palette[vc2][1];
		c2[2] = palette[vc2][2];

		bgnline();
			c3i(c1);
			v3f(v1);
			c3i(c2);
			v3f(v2);
		endline();
	}

	popmatrix();

	return(err_ret);
}
