
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

int gx_sdgetdim(dfile,xsiz,ysiz)
char *dfile;
int *xsiz,*ysiz;
{
	int ret,err_ret;
	int rank,maxrank,sizes[2];

	err_ret = 0;
	maxrank = 2;
	ret = DFSDgetdims(dfile,&rank,sizes,maxrank);
	if (ret){
		err_ret = 1;
		goto error;
	}

	if (rank != 2){
		err_ret = 2;
		goto error;
	}

	*xsiz = sizes[0];
	*ysiz = sizes[1];

error:
	return(err_ret);

}

int gx_sdgetdata(dfile,ibuf,xsiz,ysiz)
char *dfile;
unsigned char ibuf[];
int xsiz,ysiz;
{
	int ret,err_ret;
	int rank,sizes[2];
	int num_bytes;
	int size1;
	float *dbuf;
	float minval,maxval;
	register int i;

	err_ret = 0;

	rank = 2;
	sizes[0] = xsiz;
	sizes[1] = ysiz;

	num_bytes = xsiz * ysiz * sizeof(float);
	dbuf = (float *)malloc(num_bytes);
	if (!dbuf){
		err_ret = 3;
		goto error;
	}
	
	ret = DFSDgetdata(dfile,rank,sizes,dbuf);
	if (ret){
		err_ret = 4;
		goto error;
	}

	size1 = xsiz * ysiz;
	findMinMax(dbuf,size1,&minval,&maxval);

	floattoR8(dbuf,ibuf,size1,minval,maxval);

	free(dbuf);
error:
	return(err_ret);

}

int findMinMax(data,size,min,max)
float data[];
int size;
float *min,*max;
{
	register int i;
	register float dval,ms,ml;

	ms = data[0];
	ml = data[0];
	i = size-1;
	do{
		dval = data[i];
		if (ml < dval)
			ml = dval;
		else if (ms > dval)
			ms = dval;
		i--;
	}while(i);

	*min = ms;
	*max = ml;

	return(0);
}

int floattoR8(fdata,rdata,size,min,max)
float fdata[];
unsigned char rdata[];
int size;
float min,max;
{
	register int i;
	register float *fptr,ml,step;
	register unsigned char *rptr;
	int err_ret;
	float maxchar_val;

	err_ret = 0;
	maxchar_val = 255.0;

	step = (max - min) / maxchar_val;
	if (step == 0.0){
		err_ret = 1;
		goto error;
	}

	i = size;
	rptr = rdata;
	fptr = fdata;
	ml = min;
	do{
		i--;
		*rptr++ = (unsigned char) ((*fptr++ - ml) / step);
	}while(i);

error:
	return(err_ret);
}
