#include "gr_com.h"

#include <signal.h>
extern long td_CurrentTime();
extern int	gr_AniTimeOut();
extern void gr_ImageInitCMapHDF();
extern void gr_AniDrawGrid();
extern void gr_AniDrawImage();
extern void gr_AniDrawLoad();

#define	OFFSET			50
#define GR_ANIDELAYMAX  2000000
#define GR_ANIDELAYGRD  10000
#define	MINWINXSIZE	285
#define MINWINYSIZE	100
#define	MAXWINXSIZE	900
#define MAXWINYSIZE	900
#define LEEWAY		2

/* ------------------------------------------------------------------ */
/*
 * Animate along cartesian axes
* patterned after gr_InitAniLevel.
* jng jan-11-91
 */

A_AniWind_t
*myDTMupdateAniWin ( aWin,  tparent)
A_CubeWind_t	*tparent;
A_AniWind_t		*aWin;

{
	A_BossWind_t	*bossWin=tparent->parent;
	int				usePlane,winxsize,winysize,xsize,ysize;
	int				ncols,nrows,numFrames,ret,fileexist;
	short			i,j;
	long			startTime,remTime;
	XGCValues		gcvals;
	Display			*dpy;
	Window			win;

	int				scale,incr,	numplanes;
	char 				* pathname;
	A_Axes_t			orient;

	scale = aWin->scale;
	numplanes =  aWin->numplanes;
 	pathname = aWin->pathname;
	orient =  aWin->axesOrient;
	incr      = gr_CubegetCurIncr(tparent);


	gr_WidgetCursor(tparent->shell,XC_man);

	DBPRINT(" IN myDTMupdateAniWin\n");


	if (aWin->useDisk == TRUE)
		numFrames = 1;
	else
		numFrames = numplanes;

	aWin->imagexsize = (int *)calloc(numFrames,sizeof(int));
	aWin->imageysize = (int *)calloc(numFrames,sizeof(int));
	if (aWin->imagexsize == NULL || aWin->imageysize == NULL)
	{
		fprintf(stderr,"Error\t: in calloc for imagexsize or imageysize.\n");
		exit(-1);
	}

	ncols = td_HdfgetDim(bossWin->data,orient.col);
	nrows = td_HdfgetDim(bossWin->data,orient.row);

	if ((tparent->interp == TRUE) && (tparent->cull == FALSE))
	{
		ncols--; nrows--;
	}

	if (tparent->cull == FALSE)
	{
		xsize = ncols*scale;
		ysize = nrows*scale;
	}
	else
	{
		xsize = ncols/scale;
		if (xsize*scale < ncols) xsize++;
		ysize = nrows/scale;
		if (ysize*scale < nrows) ysize++;
	}

	if (xsize > MINWINXSIZE)
		if (xsize > MAXWINXSIZE) winxsize = MAXWINXSIZE;
		else winxsize = xsize+LEEWAY;
	else
		winxsize = MINWINXSIZE+LEEWAY;

	if (ysize > MINWINYSIZE)
		if (ysize > MAXWINYSIZE) winysize = MAXWINYSIZE;
		else winysize = ysize+LEEWAY;
	else
		winysize = MINWINYSIZE+LEEWAY;

	if (aWin->gridOn == TRUE)
	{
		winxsize += 2*OFFSET; winysize += 2*OFFSET;
	}

	aWin->imageVPort = gr_MakeVPort("XDSvport",aWin->win,
						NOSCROLL,HP,NULL, NULL,5,(caddr_t)aWin,
						2,2,winxsize+2,winysize+2);

	if (aWin->gridOn == FALSE)
		aWin->imageWin = gr_MakeWorkSpace("XDSworkspace",aWin->imageVPort,
					(XtCallbackProc)gr_AniExpose,NULL,NULL,(caddr_t)aWin,
					0,0,xsize,ysize);
	else
		aWin->imageWin = gr_MakeWorkSpace("XDSworkspace",aWin->imageVPort,
					(XtCallbackProc)gr_AniExpose,NULL,NULL,(caddr_t)aWin,
					0,0,xsize+2*OFFSET,ysize+2*OFFSET);

	aWin->data = td_Malloc2D(1,numplanes,(long)sizeof(char *),"td_Malloc2D");
	if (aWin->usePixmap == TRUE)
		aWin->image = (Pixmap *)td_Malloc1D(1,numFrames,(long)sizeof(Pixmap),
					"td_Malloc1D");
	else
		aWin->ximage = (XImage **)td_Malloc1D(1,numFrames,(long)sizeof(XImage *),
					"td_Malloc1D");


	dpy = XtDisplay(aWin->imageWin);
	win = XtWindow(aWin->imageWin);
	gcvals.foreground = BlackPixel(dpy,DefaultScreen(dpy));
	aWin->imageWinGC = XtGetGC(aWin->imageWin, GCForeground, &gcvals);
	XSetTSOrigin(dpy,aWin->imageWinGC,0,0);
	XSetFillStyle(dpy,aWin->imageWinGC,FillTiled);

	startTime = td_CurrentTime();

	i=0;
	for (j=0;j<numplanes;j++)
	{
		usePlane = orient.plane+(j*incr);
		if (aWin->useDisk == FALSE)
			i = j;

		aWin->imagexsize[i] = xsize;
		aWin->imageysize[i] = ysize;
		if ((aWin->useDisk == TRUE) && (j > 0))
		{
			if (aWin->usePixmap == TRUE)
				XFreePixmap(dpy,aWin->image[0]);
			else
				XDestroyImage(aWin->ximage[0]);
			td_Free((char *)aWin->data[0]);
		}
		aWin->data[i] = td_HdfgetPixData(bossWin->data,
				orient.row,orient.col,orient.axis,
				usePlane,tparent->interp,tparent->cull,
				(unsigned char)gr_color.nColors);

		if (aWin->usePixmap == TRUE)
		{
		aWin->image[i] = gr_PixmapCreate(aWin->imageWin,aWin->imageWinGC,
				aWin->xorg,aWin->yorg,
				aWin->imagexsize[i],aWin->imageysize[i],aWin->data[i]);
		}
		else
		{
		aWin->ximage[i] = gr_ImageCreate(aWin->imageWin,
				aWin->imagexsize[i],aWin->imageysize[i],aWin->data[i]);
		}
		gr_AniDrawImage(dpy,win,aWin,i);

		if (aWin->useDisk == TRUE)
		{
			fileexist = td_FileExist(pathname);

			if (fileexist == 0)
				ret = td_HdfPutImage(pathname,aWin->data[i],gr_color.palette,
				aWin->imagexsize[i],aWin->imageysize[i]);
			else
				ret = td_HdfAddImage(pathname,aWin->data[i],gr_color.palette,
				aWin->imagexsize[i],aWin->imageysize[i]);
			if (ret == -1)
				gr_TextMsgOut("Error in saving Animation image!\n");
			else
				gr_TextMsgOut("Saved ");
		}
		remTime = (long)((td_CurrentTime()-startTime)/(j+1.0)*
						 (numplanes-j-1.0));
	}

	if (aWin->useDisk == TRUE)
		gr_AniDrawLoad(dpy,win,aWin,0);
	else
		gr_AniDrawImage(dpy,win,aWin,0);


	if (aWin->gridOn == TRUE)
		gr_AniDrawGrid(aWin);

	gr_WidgetCursor(aWin->shell,XC_draped_box);
	gr_WidgetCursor(tparent->shell,XC_draped_box);

	return;
}


