

       4  Menus


       The HP Widgets menus are versatile and easy to use.  The
       menu system provides resource entries that allow you to
       tailor menus to fit any application.  This chapter will
       explain menus and how you can use them.


       4.1  Menu System Description


       The menu system is composed of several widgets that are
       arranged as children of shell widgets.  This section
       describes the menu hierarchy and menu views. A later section
       will describe the widgets that make up the menu system:
       MenuMgr, MenuPane, MenuSep, and MenuButton.


       4.1.1  Menu Hierarchy

       A menu consists of a hierarchy of widgets, as shown in
       figure 4-1.


                       PIC Illustration goes here.


                       Figure 4-1.  Menu Hierarchy


       A menu consists of menu button and menu separator widgets
       that are placed into menu pane widgets and managed by the
       menu manager. A menu button widget is a single menu item,
       while a menu separator widget is used to separate unrelated
       buttons or groups of buttons within the menu pane.  A menu
       pane widget displays one level of the menu including all of
       the menu buttons in that level.  A menu with several levels
       is built by placing the menu pane widgets into the menu
       manager.  The menu manager, menu pane, menu separator, and
       menu button widgets are discussed in later sections of this
       chapter.


       4.1.2  Menu Manager View

       The menu manager displays the menu in a popup view.  The
       popup menu usually appears due to a post action generated by
       the application user and is displayed as a vertical list of
       menu items. It may have a title on the top of the list.  The
       menu items that contain a cascade indicator (an arrow by
       default) can be used to display a cascading submenu.  The
       menu can cascade down as many levels as desired.

       The popup menu usually appears due to a post action
       generated by the application user. The popup menu is
       displayed as a vertical list of menu items and may
       optionally have a title on the top of the list.  The menu
       items that contain a cascade indicator (an arrow by default)
       can be used to display a cascading submenu.  The menu can
       cascade down as many levels as desired.

       Figure 4-2 and figure 4-3 show how a popup menu is cascaded.
       In figure 4-2, the bottom menu button, labeled ``More,'' has
       an arrow indicating the presence of a submenu.  Moving the
       pointer into this menu button and then over the arrow causes
       the submenu to appear, as shown in figure 4-3.  Note that
       there is a submenu available from the bottom menu button
       here also.


                    Figure 4-2.  Popup Top Level Menu


             Figure 4-3.  Popup Top Level and Cascading Menus


       4.1.3  Data Specification

       The data is specified in a single tree which resembles a
       cascading menu.  The cascading tree is shown in figure 4-4.


                       PIC Illustration goes here.


                     Figure 4-4.  Cascading Menu Tree


                 -----------------------------------------
                                 CAUTION

                 Do not attempt to attach a menu pane to
                 one of its own children.  Doing so will
                 cause an unbreakable loop and may cause
                 your program to crash.
                 -----------------------------------------


       4.2  Menu Components


       The menu system is composed of several widgets that are
       arranged as children of shell widgets (see figure 4-1).
       This section describes the individual components of the menu
       system.


       4.2.1  Menu Manager

       The menu manager widget is a composite manager meta class.
       (Refer to chapter 6, ``Composite Widgets,'' in Programming
       With the Xt Intrinsics.) A meta class widget is never
       instantiated, but serves as a mechanism for providing a set
       of resources that are common to many other types of menu
       manager widgets.  The menu manager is the controller of the
       menu system and handles the presentation of the popup menu
       view.  It manipulates the menu pane, menu separator, and
       menu button widgets to present the view.

       A menu manager can be associated with a single widget or a
       widget and all of its children.  This widget is referred to
       as the associated widget.  A menu associated with a widget
       and all of its children is very useful when that widget is a
       manager (such as a panel), especially if the number of
       children in the widget varies during the course of the
       application. The menu manager sets up the necessary
       translations on the associated widget. If the menu is also
       associated with the widget's children, then button or key
       ``grabs'' are set up to capture all of the events of
       interest.

       The menu manager sets up the input translation and the
       ``grabs'' necessary for the menu system to be transparently
       added to the associated widget.  You simply specify the
       ``post'' and ``select'' button actions in the menu manager.
       Through the use of these resources, you can easily customize
       the menu system to operate according to a ``drag'' model, a
       ``double click'' model, or whatever model is desired.

       The menu manager exports a resource by which the application
       may specify a keyboard event that can be used to unpost the
       menus without selecting an item.  The menu manager also
       exports a resource that may be used to specify a keyboard
       event that will select the currently highlighted menu item.
       Both of these resources are useful when keyboard traversal
       is active in a menu hierarchy.


       4.2.2  Popup Manager

       The popup manager supports a post keyboard accelerator as an
       alternative way to post the menu.  A menu posted with the
       keyboard accelerator functions the same as one posted with
       the post button action, except that the pointer may not be
       initially positioned in the menu.

       The popup manager supports a sticky  menu mode.  In this
       mode the menu system remembers the set of cascading menu
       panes that were posted when you last selected a menu item.
       The next time the you request that the menu be posted, that
       entire set of menu panes is displayed.  The pointer is moved
       to the exact menu button that was last selected if the menu
       was posted with the post button action.  If the sticky menu
       mode is not enabled, then only the top level menu pane is
       displayed each time the menu is posted.

       The popup manager handles the positioning of the menu panes
       when they are posted.  When you post the top level menu pane
       using the post button action, the pane is positioned so that
       the pointer is located in the first item of the menu pane,
       unless the sticky menu mode is enabled.  The cascading
       submenus are positioned next to the menu button that brought
       up the submenu.  When you post the top level menu pane using
       the post keyboard accelerator, the pane is positioned in the
       center of its associated widget.  If the menu pane will not
       fit on the display, it is repositioned so that the entire
       menu pane is visible.

       A menu item is selected in the menu by either executing the
       button select action (as defined in the popup manager), by
       pressing the key defined as the ``keyboard select'' key, or
       by entering a keyboard accelerator (as defined by a
       particular menu button widget in the menu).  Regardless of
       how the menu item is selected, the visible menu panes are
       removed from the display before the selected item is called.

       The popup menu manager allows its menu panes to have a title
       on the top, bottom, or both top and bottom.  The display of
       the titles is determined by the menu panes' resource
       settings and is not modified by the popup manager.

       The popup manager provides a global function (XwPostPopup())
       that may be used by an application to force a top level menu
       pane to be posted.  The application must specify a position
       (relative to a specific widget) to which the menu pane will
       be posted, and the identification of the specific widget.


       4.2.3  Menu Pane Widget

       The menu pane widget is a composite manager meta class.
       (Refer to chapter 6, ``Composite Widgets,'' in the
       Programming With the Xt Intrinsics manual.) Remember that a
       meta class widget is never instantiated, but serves as a
       mechanism for providing a set of resources that are common
       to many other types of widgets.  Thus, the menu pane widget
       provides resources that are common to many other types of
       menu pane widgets.

       The common resources include such pieces of information as
       the title that is displayed in the menu pane, the font and
       color of the title, the type of title to use (string or
       image), the name of the menu button to which the menu pane
       is attached, and a mnemonic which may be used by certain
       menu managers for posting the menu pane.


       Cascade
       The cascade widget is a subclass of the menu pane meta
       class, and is classified as a composite manager widget.  It
       is a specialized manager, because it can only manage widgets
       that are a subclass of the menu button widget.  This type of
       widget is normally used when constructing popup or pulldown
       menus.

       As menu buttons or menu separators are added to a cascade
       widget, they are positioned according to the insertion
       algorithm supplied by the manager meta class.  When the menu
       button is created, its argument list is searched for the
       argument name XtNinsertPosition.  The value associated with
       XtNinsertPosition indicates where this menu button is to be
       placed with respect to the other menu buttons contained
       within the menu pane.


       The cascade widget supplies a single additional resource
       that allows the location of the menu pane title to be
       specified.  A title may be displayed at the top, bottom or
       top and bottom of a cascade widget.

       A cascade widget always assumes its ideal size, as
       determined by its children and its title.  As its children
       grow or shrink, the menu pane adapts as needed.


       4.2.4  Menu Button Widget

       The menu button widget provides a wide range of resources so
       that each item in a menu can be defined with unique
       attributes (such as color, font, string or image, sensitive
       state, etc).  The menu button is a subclass of the
       XwButtonClass widget.

       The menu button widget consists of three areas:

          o The mark area.

          o The label area.

          o The cascade indicator area.

       These areas are shown in figure 4-5.


                       PIC Illustration goes here.


                      Figure 4-5.  Menu Button Areas

       The mark area can be used to checkmark a menu item.  The
       label area contains the desired menu item string or image.
       The cascade indicator area is primarily used by the menu
       manager for indicating that a cascading submenu is present.
       By default, the mark is a checkmark, the label is the name
       of the widget, and the cascade indicator is an arrow.  The
       label can be set to any text string or image, and the label
       area attempts to grow or shrink to accommodate the new size.


       The size is typically set by the menu pane widget to insure
       consistency throughout a single menu pane.  You may modify
       the image used for the mark and cascade indicators, but the
       height and width of these areas will not change.

       A select callback is provided on the menu buttons.  The
       select translation is typically determined in the menu
       manager and the selected menu button callback routines are
       called.  The menu button provides keyboard accelerators and
       mnemonics.  The menu manager determines whether or not the
       keyboard accelerator and mnemonic are made available.  If
       the mnemonic specified is found in the label string it is
       underlined, unless disallowed by the menu manager.


       4.2.5  Menu Separator Widget

       The menu separator widget is a primitive widget that is used
       to separate menu buttons or groups of menu buttons within a
       menu pane.  Several different line styles are available, and
       the selection is made by means of the resource
       XtNseparatorType.  The default is a single line, but double
       lines and dashed lines may be selected.  Common resources
       from core and primitive meta classes can be set for this
       widget also.  Refer to the menu separator man page for more
       information.


       4.3  Creating a Menu

       The steps required to create the menu hierarchy shown in
       figure 4-1 are given below.  Following each step is a code
       segment that shows how a popup cascading menu could be
       created.  These  steps provide the greatest degree of
       control over the menu, although it may be somewhat
       cumbersome to build.

         1.  Create the widget (such as a panel) that the menu is
             to be associated with.
             panel=XtCreateManagedWidget("panel",XwpanelWidgetClass,parent,NULL,0);

         2.  Create a popup shell as a child of the associated
             widget.
             mmgrshell=XtCreatePopupShell("mmgrshell",shellWidgetClass,panel,NULL,0);

         3.  Create the menu manager as a child of the shell.
             mmgr=XtCreateManagedWidget("mmgr",XwpopupmgrWidgetClass,mmgrshell,NULL,0);

         4.  Create a popup shell as a child of the menu manager.
             paneshell=XtCreateManagedWidget("paneshell",shellWidgetClass,mmgr,NULL,0);

         5.  Create a menu pane as a child of the shell.
             pane=XtCreateManagedWidget("pane",XwcascadeWidgetClass,paneshell,NULL,0);

         6.  Create a menu button as a child of the menu pane.
             button1=XtCreateManagedWidget("button1",XwmenubuttonWidgetClass,pane,NULL,0);

         7.  Continue creating menu button widgets as children of
             the menu pane until all desired menu button widgets
             are added.
             button2=XtCreateManagedWidget("button2",XwmenubuttonWidgetClass,pane,NULL,0);
             button3=XtCreateManagedWidget("button3",XwmenubuttonWidgetClass,pane,NULL,0);

         8.  Continue creating the shell-menu pane pairs with the
             desired menu button widgets until the menu is
             complete.
             paneshell2=XtCreateManagedWidget("paneshell2",shellWidgetClass,mmgr,NULL,0);
             pane2=XtCreateManagedWidget("pane2",XwcascadeWidgetClass,paneshell2,NULL,0);
             button4=XtCreateManagedWidget("button4",XwmenubuttonWidgetClass,pane2,NULL,0);


       4.4  Using Menus


       Once the menu system has been built, it is relatively easy
       to use.  Communication with the menu system is achieved
       through the callback functions or by the application
       modifying menu attributes.  These subjects are covered
       below, followed by a description of keyboard traversal.


       4.4.1  Callbacks

       The menu system provides applications with the means for
       attaching callback functions to the menu button or menu pane
       select actions.  These functions are called after the menu
       system has been removed from the screen.  Typically the menu
       pane select is used only to remove the menu system.  The
       menu button select callbacks are most often used by an
       application to perform some action.


       4.4.2  Keyboard Traversal

       The menu system provides a keyboard interface to the menus
       through the use of keyboard accelerators to post a menu
       pane, keyboard accelerators to select a menu button, and
       traversal key definitions.  The general keyboard interface
       scheme is discussed in chapter 6, ``Keyboard Traversal.''
       By enabling traversal, the menu system can be driven from
       the keyboard.  The menu highlighting scheme changes so that
       the menu item that has the focus (that is, the menu item
       that is active) is highlighted.  The focus and highlighting
       are moved to another menu item by means of the traversal key
       definitions.  The pointer movements through the menu do not
       change the focus or the highlight.  Note that enabling
       traversal and then using the pointer to operate the menu can
       be confusing, since the highlighting does not track the
       pointer although the pointer select action is still defined.
       If the menu traversal is enabled, you should plan on
       operating the menu with the keyboard only.


       4.5  A Sample Program


       The program listing on the following pages is that of a very
       basic use of the menu manager, menu pane, and menu button
       widgets.  The source for this program can be found in
       /usr/contrib/Xw/examples/menudemo.c.  To compile and link it
       use the following command:

       cc -O -Wc,-Nd3000 -Wc,-Ns3000 -o menudemo menudemo.c -lXw -lXt -lX11

       #include <X11/Xlib.h>
       #include <X11/IntrinsicP.h>
       #include <X11/Intrinsic.h>
       #include <X11/Xatom.h>
       #include <X11/StringDefs.h>
       #include <X11/Label.h>
       #include <X11/Shell.h>
       #include <Xw/Xw.h>
       #include <Xw/XwP.h>
       #include <Xw/MenuBtn.h>
       #include <Xw/Cascade.h>
       #include <Xw/PopupMgr.h>
       #include <Xw/BBoard.h>
       Widget toplevel, bboard;
       Widget mmgrshell, mmgr;
       Widget paneshellA, paneshellB, paneshellC;
       Widget menupaneA, menupaneB, menupaneC;
       Widget buttona1;
       Widget buttonb1, buttonb2, buttonb3;
       Widget buttonc1, buttonc2, buttonc3;

       /****** Widget & Children ArgLists ******/
       static Arg toplevelArgs [] = {
          {XtNallowShellResize, (XtArgVal) True}
       };
       static Arg bboardArgs [] = {
          {XtNwidth, (XtArgVal) 200},
          {XtNheight, (XtArgVal) 300}
       };

       /****** Menu Manager ArgLists ******/

       static Arg menumgrArgs [] = {
          {XtNassociateChildren, (XtArgVal) True},
          {XtNstickyMenus, (XtArgVal) True},
          {XtNmenuPost, (XtArgVal) "<Btn1Down>"},
          {XtNmenuSelect, (XtArgVal) "<Btn3Down>"},
       };


       /****** Menu Pane ArgLists ******/

       static Arg menu paneAArgs [] = {
          {XtNattachTo, (XtArgVal) "mmgr"}
       };
       static Arg menupaneBArgs [] = {
          {XtNattachTo, (XtArgVal) "more"}
       };
       static Arg menupaneCArgs [] = {
          {XtNattachTo, (XtArgVal) "stillmore"}
       };

       /****** Menu Buttons (pane A) ArgLists ******/
       static Arg buttona1Args [] = {
          {XtNlabel, (XtArgVal) "More"},
       };

       /****** Menu Buttons (pane B) ArgLists ******/
       static Arg buttonb1Args [] = {
          {XtNlabel, (XtArgVal) "Hello"},
       };
       static Arg buttonb2Args [] = {
          {XtNlabel, (XtArgVal) "GoodBye"},
       };
       static Arg buttonb3Args [] = {
          {XtNlabel, (XtArgVal) "Still More"},
       };

       /****** Menu Buttons (pane C) ArgLists ******/
       static Arg buttonc1Args [] = {
          {XtNlabel, (XtArgVal) "Boy"},
       };
       static Arg buttonc2Args [] = {
          {XtNlabel, (XtArgVal) "Girl"},
       };
       static Arg buttonc3Args [] = {
          {XtNlabel, (XtArgVal) "??"},
       };

       /*******************************/
       void Hello()
       {
          printf ("Hello!!\n");
       }
       /*******************************/
       void Goodbye()
       {
          printf ("Goodbye!!\n");
       }
       /*******************************/
       void Boy()
       {
          printf ("Boy!!\n");
       }
       /*******************************/
       void Girl()
       {
          printf ("Girl!!\n");
       }
       /*******************************/


       void Question()
       {
          printf ("??\n");
       }
       /*******************************/

       void
       main(argc, argv)
           int argc;
           char **argv;
       {
          Widget children[20];
          /*******************************/
          /* Create the top level widget */
          /*******************************/
          toplevel = XtInitialize (argv[0], "menusample", NULL, 0, &argc, argv);
          XtSetValues (toplevel, toplevelArgs, XtNumber(toplevelArgs));

          /*******************************************/
          /* A bulletin board will be our primary widget */
          /*******************************************/
          bboard = XtCreateManagedWidget("bboard", XwbulletinWidgetClass, toplevel,
                                       bboardArgs, XtNumber(bboardArgs));

          /*************************/
          /* Create a menu manager */
          /*************************/
          mmgrshell = XtCreatePopupShell("mgrshell", shellWidgetClass,
                                       bboard, NULL, 0);
          mmgr = XtCreateManagedWidget("mmgr", XwpopupmgrWidgetClass,
                                        mmgrshell, menumgrArgs, XtNumber(menumgrArgs));

          /**********************************************************************/
          /* Create 3 menu panes, which will be used to build the menu hierarchy */
          /**********************************************************************/
          paneshellA = XtCreatePopupShell("paneshellA", shellWidgetClass, mmgr,
                                          NULL, 0);
          menupaneA = XtCreateManagedWidget("menupaneA", XwcascadeWidgetClass,
                                          paneshellA, menupaneAArgs,
                                          XtNumber(menupaneAArgs));
          paneshellB = XtCreatePopupShell("paneshellB", shellWidgetClass, mmgr,
                                          NULL, 0);
          menupaneB = XtCreateManagedWidget("menupaneB", XwcascadeWidgetClass,
                                          paneshellB, menupaneBArgs,
                                          XtNumber(menupaneBArgs));
          paneshellC = XtCreatePopupShell("paneshellC", shellWidgetClass, mmgr,
                                          NULL, 0);
          menupaneC = XtCreateManagedWidget("menupaneC", XwcascadeWidgetClass,
                                          paneshellC, menupaneCArgs,
                                          XtNumber(menupaneCArgs));

          /*****************************************/
          /* Create the menu buttons for menu pane A */
          /*****************************************/
          buttona1 = XtCreateManagedWidget ("more", XwmenubuttonWidgetClass,
                         menupaneA, buttona1Args, XtNumber (buttona1Args));

          /*****************************************/
          /* Create the menu buttons for menu pane B */
          /*****************************************/
          children[0] = buttonb1 = XtCreateWidget ("hello",
                         XwmenubuttonWidgetClass, menupaneB, buttonb1Args,
                         XtNumber (buttonb1Args));
          children[1] = buttonb2 = XtCreateWidget ("goodbye",
                         XwmenubuttonWidgetClass, menupaneB, buttonb2Args,
                         XtNumber (buttonb2Args));
          children[2] = buttonb3 = XtCreateWidget ("stillmore",
                         XwmenubuttonWidgetClass, menupaneB, buttonb3Args,
                         XtNumber (buttonb3Args));
          XtManageChildren (children, 3);


          /*****************************************/
          /* Create the menu buttons for menu pane C */
          /*****************************************/
          children[0] = buttonc1 = XtCreateWidget ("boy", XwmenubuttonWidgetClass,
                         menupaneC, buttonc1Args, XtNumber (buttonc1Args));
          children[1] = buttonc2 = XtCreateWidget ("girl", XwmenubuttonWidgetClass,
                         menupaneC, buttonc2Args, XtNumber (buttonc2Args));
          children[2] = buttonc3 = XtCreateWidget ("question",
                         XwmenubuttonWidgetClass, menupaneC, buttonc3Args,
                         XtNumber (buttonc3Args));
          XtManageChildren (children, 3);

          /*******************************/
          /* Attach all action callbacks */
          /*******************************/
          XtAddCallback (buttonb1, XtNselect, Hello, NULL);
          XtAddCallback (buttonb2, XtNselect, Goodbye, NULL);
          XtAddCallback (buttonc1, XtNselect, Boy, NULL);
          XtAddCallback (buttonc2, XtNselect, Girl, NULL);
          XtAddCallback (buttonc3, XtNselect, Question, NULL);
          /********************************************************/
          /* Realize the widget tree, and start processing events */
          /********************************************************/
          XtRealizeWidget (toplevel);
          XtMainLoop();
       }


