
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)defaults.c	1.4	(NCSA)	8/10/87";
#endif lint

#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <sunwindow/defaults.h>
#include "machdep.h"
#include "defs.h"
#include "session.h"

/*
** get defaults from /usr/lib/defaults/Teltool.d or $HOME/.defaults
*/

get_defaults()
{
	extern char capname[];
	extern char hpfname[];
	extern char psfname[];
	extern char tekfname[];
	extern char bfname[];
	extern char teluser[];

	Session.s_scroll = defaults_get_integer("/Teltool/Scrollback",
						DEFSCROLLBACK, 0);
	strcpy(teluser, defaults_get_string("/Teltool/Tel_User", TELUSER, 0));
	strcpy(psfname, defaults_get_string("/Teltool/Default_Postscript_Output",
			DEFPSOUT, 0));
	strcpy(tekfname, defaults_get_string("/Teltool/Default_Tek_Output",
			DEFTEKOUT, 0));
	strcpy(hpfname, defaults_get_string("/Teltool/Default_HPGL_Output",
			DEFHPOUT, 0));
	strcpy(bfname, defaults_get_string("/Teltool/Default_Bitmap_Output",
			DEFBMOUT, 0));
	strcpy(capname, defaults_get_string("/Teltool/Default_Capture_File",
			DEFCAPNAME, 0));
	Session.s_spcflag = (int)
					defaults_get_boolean("/Teltool/Enable_Special_Chars",
						False, 0);
}
