/* annot.c -- routines for manipulating labels */
#include "he.h"

int HEannotate(cmd)
    HE_CMD *cmd;
{
    register int i;
    char *editor = NULL;
    int ann = HE_LABEL;

    for (i = 1; i < cmd->argc; i++)
	if (cmd->argv[i][0] == '-')
	    switch (findOpt(cmd->argv[i] + 1))
	    {
	    case HE_HELP:
		puts("annotate [-label|-descriptor] [-editor <editor>]");
		puts("\tEdit an annotation");
		puts("\t-label\t\tEdit label (default)");
		puts("\t-descriptor\tEdit descriptor");
		puts("\t-editor\t\tUse editor (default EDITOR env value)");
		return HE_OK;
	    case HE_LABEL:
		ann = HE_LABEL;
		break;
	    case HE_DESCRIPTOR:
		ann = HE_DESCRIPTOR;
		break;
	    case HE_EDITOR:
		if (++i < cmd->argc) editor = cmd->argv[i];
		break;
	    case HE_NOTFOUND:
		unkOpt(cmd->argv[i]);
		return HE_FAIL;
	    case HE_AMBIG:
		ambigOpt(cmd->argv[i]);
		return HE_FAIL;
	    default:
		irrOpt(cmd->argv[i]);
		return HE_FAIL;
	    }
	else
	{
	    unkArg(cmd->argv[i]);
	    return HE_FAIL;
	}
    return annotate(editor, ann);
}

/* Edit annontations (labels and descriptions) for the
 * current data element */
int annotate(editor, ann)
    char *editor;		/* editor to use */
    int ann;			/* HE_LABEL  or HE_DESCRIPTOR */
{
    int32 len;			/* length of annotation */
    char *buf;			/* annotation buffer */
    char *file;			/* tmp file name */
    register int i;
    int ret;

    /* check if any hdf file is open
     */
    if (!fileOpen())
    {
	noFile();
	return HE_FAIL;
    }

    /* Get the annotation from hdf file
     */
    len = getAnn(ann, currTag(), he_desc[he_currDesc].ref, &buf);

    /* make sure some editor will be used
     * defaults to /usr/bin/ex
     * but should be made a compile time option
     */
    if (editor == NULL)
    {
	char *getenv();
	editor = getenv("EDITOR");
	if (editor == NULL) editor = "/usr/bin/ex";
    }

    (void) getTmpName(&file);

    /* if there is prior annotation, put it into the tmp file
     */
    if (len > 0 && buf != NULL)
    {
	/* doctor the buffer a little for the editors
	 */
	if (ann == HE_LABEL)
	    buf[len] = '\n';
	else
	    len--;
	writeToFile(file, buf, len+1);
	free(buf);
    }

    if (fork() == 0)
    {
	/* this is the child */
	if (execl(editor, editor, file, 0) == -1)
	    fprintf(stderr, "Error while editing label.\n");

	/* return control to the parent if exec fails
	 */
	exit();
    }

    /* the parent waits for the child to die */
    wait(0);

    /* read in edited annotation
     */
    len = readFromFile(file, &buf);
    if (len <= 0 || buf == NULL) return len;

    /* doctor the buffer for standard format
     */
    if (ann == HE_LABEL)
    {
	/* take out control characters from the end */
	for (i = len; i >= 0 && !isgraph(buf[i]); i--)
	    ;
	buf[i+1] = '\0';
    }

    /* forget the tmp file
     */
    removeFile(file);

    /* write annotation to the hdf file
     */
    ret = putAnn(ann, currTag(), he_desc[he_currDesc].ref, buf, len);
    updateDesc();

    /* clean up
     */
    free(buf);
    return ret;
}

/* end of annot.c */
