#!/bin/sh
rm *.gdmo *.tmp *.asn1

#
# RFC1213 RFC1354 (MIBII plus IPFORWARD)
#
smic -Y1 "RFC1213-MIB RFC1354-MIB" -Y2 "IIMCRFC12131354ASN1" mibii | sed -f vtt.mibii.sed > vtt.mibii.gdmo	
mv gdmo-asn1.tmp vtt.mibii.asn1

#
# FUBAR
#
smic -Y1 "RFC9999-MIB" -F vtt.fubar.gdmo vtt.mibfubar
mv gdmo-asn1.tmp vtt.fubar.asn1

#
# RFC1238 (CLNS)
#
smic -Y1 "CLNS-MIB" -Y2 "IIMCRFC1238ASN1" -F vtt.clns.gdmo vtt.mibclns
mv gdmo-asn1.tmp vtt.clns.asn1

#
# RFC1285 (FDDI)
#
smic -Y1 "RFC1285-MIB" -Y2 "IIMCRFC1285ASN1" -F vtt.fddi.gdmo vtt.mibfddi
mv gdmo-asn1.tmp vtt.fddi.asn1

#
# RFC1289 (DECnet Phase IV)
#
smic -Y1 "RFC1289-phivMIB" -Y2 "IIMCRFC1289ASN1" -F vtt.decnetiv.gdmo vtt.mibdecnetiv
mv gdmo-asn1.tmp vtt.decnetiv.asn1


#
# RFC1286 (Bridge MIB):
#
smic -Y1 "RFC1286-MIB" -Y2 "IIMCRFC1286ASN1" -F vtt.dot1dbridge.gdmo vtt.mibdot1dbridge
mv gdmo-asn1.tmp vtt.dot1dbridge.asn1


#
# RFC1353 (Party MIB):
#
smic -Y1 "RFC1353-MIB" -Y2 "IIMCRFC1353ASN1" -F vtt.party.gdmo vtt.party
mv gdmo-asn1.tmp vtt.party.asn1
