/* $Header: /home/vikas/netmgt/nocol/src/support/rpcping/RCS/rpcping.c,v 1.9 1994/12/19 03:04:30 vikas Exp $ */

/*
 * $ Original Id: rpcping.c,v 1.1 1994/02/14 18:22:32 viktor Exp $
 * Author: Viktor Dukhovni
 *
 * Copyright (c) 1993, 1994 Lehman Brothers Inc.,
 * Permission is hereby granted to redistribute in source form
 * as long as this copyright notice remains intact.
 *
 * 			 NO WARRANTY
 *  
 * BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
 * FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
 * OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
 * PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
 * OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
 * TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 * PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
 * REPAIR OR CORRECTION.
 *  
 * IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
 * WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
 * REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
 * INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
 * OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
 * TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
 * YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
 * PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 */

/*
 * This program checks to see the status of the RPC portmapper on the
 * specified system. It is useful for Unix hosts since they could be
 * down and still repond to ICMP 'ping's.
 *
 * Exit values:
 *    0 if all ok, non-zero if not.
 */


#include <stdio.h>
#include <signal.h>
#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>

#if defined(__svr4__) || defined(SVR4)
# define bzero(b,n)	memset(b,0,n)
# define bcmp(a,b,n)	memcmp(a,b,n)
# define bcopy(a,b,n)	memcpy(b,a,n)
#endif

static struct timeval tv;
static timed_out = 0;

#define DEFAULT_TIMEO 20

main(argc,argv)
     char **argv;
{
    int sock = RPC_ANYSOCK;
    char *host;
    char *clnt_sperror();
    CLIENT *clnt;
    static struct sockaddr_in addr;
    static char res;
    void alarmed();

    tv.tv_sec = DEFAULT_TIMEO;
    tv.tv_usec = 0;

    bzero ((char *)&addr, sizeof (addr));

    /*	if (!isatty(0)) {
     *		fclose(stdout);
     *		fclose(stderr);
     *	}
     */
    switch (argc) {
     case 3:
	tv.tv_sec = atoi(argv[2]);
	/* FALLTHROUGH */
     case 2:
	host = argv[1];
	if ( (addr.sin_addr.s_addr = inet_addr(host)) == (unsigned int)-1)
	{
	    struct hostent *hp;

	    if ( (hp = gethostbyname(host)) == NULL )
	    {
		fprintf(stderr,"%s: Bad hostname '%s'\n", argv[0], host);
		exit(1);
	    }
	    bcopy(hp->h_addr, (char *)&addr.sin_addr.s_addr, hp->h_length);
	}
	break;
     default:
	fprintf(stderr,"Usage: %s host [timeout]\n", argv[0]);
	exit(1);
    }	/* end switch() */

    addr.sin_port = htons(PMAPPORT);
    addr.sin_family = AF_INET;

    (void)signal(SIGALRM,alarmed);
    alarm(tv.tv_sec);

    if (!(clnt=(CLIENT *)clnttcp_create(&addr, PMAPPROG, PMAPVERS, &sock, 0, 0)))
    {
	if (timed_out) {
	    printf("%s: Call to portmapper timed out\n", host);
	    exit(2);
	}
	printf ("%s\n", (char *)clnt_spcreateerror(host));
	exit(1);
    }
    alarm(0);

    clnt_control(clnt, CLSET_TIMEOUT, (char *)&tv);

    bzero((char *)&res, sizeof(res));
    if (clnt_call(clnt, PMAPPROC_NULL, xdr_void, NULL, xdr_void, NULL, tv)
	!= RPC_SUCCESS) {
	printf ("%s\n", clnt_sperror(clnt, "Call to Portmapper failed: "));
	exit(1);
    }
    printf("%s: Portmapper is running\n", host);
    exit(0);
}

void
alarmed()
{
    timed_out = 1;
}
