/*
 * pingmisc.c -- auxiliary routines for multiping.c
 */

#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <limits.h>		/* for SHRT_MAX  */
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>

#undef GLOBALS
#include "multiping.h"
#include "vars.h"

/*
 * Initialize some stuff
 */
startup()
{
  int i;

  numsites = 0;
  for (i = 0; i < MAXREMOTE; i++)
    dest[i] = NULL;
  datalen = DEFDATALEN;
}

/*
 * allocates a destrec and initializes its fields
 */ 
destrec *dest_malloc()
{
  destrec *p;
  int i;

  p = (destrec *)malloc(sizeof(destrec));
  if ((p == NULL) || ((p->rcvd_tbl = (char *)malloc(MAX_DUP_CHK / 8)) == NULL))
  {
    fprintf(stderr, "ping: dest_malloc: out of memory\n");
    exit(1);
  }
  for (i = 0; i < MAX_DUP_CHK / 8; i++)
    p->rcvd_tbl[i] = 0;
  p->nreceived = p->nrepeats = p->ntransmitted = (char)0;
  p->hostname[0] = '\0';
  p->tmax = p->tsum = 0;
  p->tmin = SHRT_MAX;
  return p;
}  

/*
 * Takes a host name like 'phoenix.princeton.edu' or an IP address
 * like '128.112.120.1' and creates an entry for that host in the
 * dest[] array.
 */
setup_sockaddr(addr)
  char *addr;
{
  destrec *dst;
  struct sockaddr_in *to;
  struct hostent *hp;

  dst = dest_malloc();
  bzero((char*)&(dst->sockad), sizeof(struct sockaddr_in));
  to = &dst->sockad;
  to->sin_family = PF_INET;
  to->sin_addr.s_addr = inet_addr(addr);
  if (to->sin_addr.s_addr != (u_int)-1)
    strcpy(dst->hostname, addr);
  else {
    hp = gethostbyname(addr);
    if (hp == NULL) {
      fprintf(stderr, "ping: unknown host %s\n", addr);
      exit(1);
    }
    to->sin_family = hp->h_addrtype;
    bcopy(hp->h_addr, (caddr_t)&to->sin_addr, hp->h_length);
    strncpy(dst->hostname, hp->h_name, MAXHOSTNAMELEN-1);
  }
  dest[numsites++] = dst;
  if (to->sin_family == PF_INET)
    printf("PING %s (%s): %d data bytes\n", pr_addr(to->sin_addr.s_addr),
	   inet_ntoa(to->sin_addr), datalen);
  else
    printf("PING %s: %d data bytes", dst->hostname, datalen);

  if (numsites > MAXREMOTE)
  {
      fprintf(stderr, "multiping: Error- number of hosts exceeds MAX %d\n",
	      MAXREMOTE);
      exit (1);
  }
}
