/*
** $Header: /home/vikas/netmgt/nocol/src/include/RCS/pingmon.h,v 1.14 1994/06/20 15:24:27 vikas Exp $
*/

#ifndef __pingmon_h
# define __pingmon_h

#include "nocol.h"

/*
 * The program needs to know the location of the 'ping' progam that is
 * to be used.
 */

/*
 * If using IP, then you might like to use the 'multiping' program which
 * pings multiple sites synchronously. If defined, it defines the PING
 * value also.
 */
#ifndef IP
# undef MULTIPING		/* undef so poll_sites.c okay */
#endif  /* IP */

#ifdef RPC
# undef MULTIPING
#endif	/* RPC */

#ifdef MULTIPING
#  ifndef BATCHSIZE
#    define BATCHSIZE 32	/* number of sites to ping at a time */
#  endif			/* less than limit MAXBATCH in multiping.c */
#  ifndef PING
#    define PING 	"multiping"	/* the multi ping command to use */
#  endif	/* PING */
#else
#  define BATCHSIZE 1			/* for standard ping programs */
#endif /* MULTIPING */


/*
 * The progam automatically fills in its own name in the EVENT.sender
 * field. If you want to over-ride this name with your own, then define
 * SENDER
 */
/* #define SENDER	"pingmon"		/* */
/* #define CONFIGFILE	"../../etc/ipnodes"	/* in ETCDIR */



/*************** Rest is standard and need not be touched ***********/

#ifndef PING
#  ifdef sun
#    define PING	"/usr/etc/ping"
#  else
#    define PING	"ping"
#  endif	/* sun */
#endif	/* PING */

/*
 *		CONSTANTS
 */
#define	DATALEN		100	/* Size of ping packets	(bytes) */
#define	NPACKETS	10	/* Number of ping packets sent */
#define PING_THRES      3	/* If more than this pkts lost, then down */
#define POLLINTERVAL	180	/* secs between starting next poll */
#define RPCTIMEOUT	5	/* timeout for rpcping in secs */

#ifdef IP
# define VARNM		"ICMP-ping"	/* for EVENT.var.name field	*/
# define VARUNITS	"Pkts"		/* Units name */
#endif

#ifdef RPC
# define VARNM		"Portmapper"
# define VARUNITS	"Status"
#endif

#ifdef OSI
# define VARNM		"OSI-ping"
# define VARUNITS	"Pkts"
#endif


/*
 * Global variables
 */
int debug ;
char *prognm ;				/* Program name			*/
char *ping ;				/* which ping to use		*/

#endif	/* ! __pingmon_h */
