/*+ 
** $Header: /nocol/src/utility/RCS/display_nocol_datafile.c,v 1.2 1992/06/18 21:38:39 aggarwal Exp $
**/

/*+ 
** This module displays the NOCOL EVENT structure.
**/

#include "nocol.h"

#include 	<stdio.h>
#include 	<sys/file.h>

#ifdef TEST
main(ac, av)
     char **av ;
     int ac ;
{
    while (--ac)
      display_nocol_datafile(*++av) ;
}
#endif /* TEST */

/*+ 
** FUNCTION:
** 	Convert int val passed to it into a binary string.
**/
char *to_binary_str(val)
     int val  ;
{
#define BINSIZE  1 * 8		/* int = 1 byte * 8 bits/byte */

    static char buf[BINSIZE] ;
    register char *bp ;

    for (bp = buf ; bp < buf + BINSIZE ; ++bp)
      *bp = '0' ;

    while (val)
    {
	*--bp = '0' + (val % 2) ;
	val /= 2;
    }
    return ((char *)buf) ;
}	/* end */


display_nocol_datafile(file)
     char *file;
{
  EVENT v;
  int bufsize, fd;
  
  if ( (fd = open (file, O_RDONLY)) < 0)
  {
      fprintf (stderr, "Error in opening file %s\n", file);
      return (1);
  }
  fprintf (stdout, ":::::  %s  ::::\n\n", file);
  
  while ((bufsize=read (fd, (char *)&v, sizeof(v))) == sizeof(v))
  {
      printf("Sender: '%s'  Mon: '%d'  Day: '%d'  ",
	     v.sender, v.mon, v.day );
      printf("Hour: '%d'  Min: '%d'\n", v.hour, v.min );
      printf("Severity: '%d' Flags: '%s'\n",
	     v.severity, to_binary_str(v.nocop));
      printf("Site.name: '%s'  ", v.site.name );
      printf("Site.addr: '%s'\n", v.site.addr);
      printf("Var.name: '%s'  Var.value: '%ld' Var.thres: '%ld'  ",
	     v.var.name, v.var.value, v.var.threshold);
      printf("Var.units: '%s'\n", v.var.units);
      printf("\n" );
  }					/* end:   while read	*/
  
  if (bufsize != 0)			/* Error		*/
    fprintf (stderr, "Invalid data in %s\n", file);
  
}	/* end: display_nocol_datafile */
