/*
 * $Header: /nocol/src/nsmon/RCS/nsmon.c,v 1.1 1992/06/11 05:03:14 aggarwal Exp $
 */
/*+ 
** FUNCTION:
** 	Make a domain nameserver query and send it off to the server.
** Used as part of the 'nocol' nsmon nameserver monitoring program.
** Query options customized to test if the nameserver is up and running.
**
**
** AUTHOR
**	S. Spencer Sun, Princeton Univ. / JvNCnet, June 1992
**/

/* Copyright 1992 JvNCnet, Princeton */

/*
 * $Log: nsmon.c,v $
 * Revision 1.1  1992/06/11  05:03:14  aggarwal
 * Initial revision
 *
 */


#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <resolv.h>
#include <setjmp.h>
#include "nsmon.h"

static int n_debug ;		/* debugging within this module */

/*
 * setup_sockaddr -- given address (e.g. phoenix.princeton.edu) or an
 *	IP # (e.g. 128.112.120.1), fills in the struct sockaddr_in
 *	passed to it
 */
setup_sockaddr(addr, to, debug)
  char *addr;
  struct sockaddr_in *to;
  int debug;
{
  struct hostent *hp;

  n_debug = debug ;
  bzero((char*)to, sizeof(struct sockaddr_in));
  to->sin_family = PF_INET;
  to->sin_addr.s_addr = inet_addr(addr);
  if (to->sin_addr.s_addr == (u_int)-1) {
    if (n_debug) {
      fprintf(stderr, "ns: warning: address must be an IP #\n");
      fprintf(stderr,
        "\tsince this is debug mode, we'll try using gethostbyname\n");
      hp = gethostbyname(addr);
      if (hp == NULL) {
        fprintf(stderr, "ns: unknown host %s\n", addr);	/* fatal error */
        return 0;
      }
      to->sin_family = hp->h_addrtype;
      bcopy(hp->h_addr, (caddr_t)&to->sin_addr, hp->h_length);
    } else {
      fprintf(stderr,
        "ns: error in address format '%s' (needs to be an IP #\n", addr);
      return 0;
    }
  }
  return 1;
}

jmp_buf env;		/* for SIGALRM handling */

alarm_handler()
{
  signal(SIGALRM, SIG_IGN);
  if (n_debug)
    fprintf(stderr, "ns: timed out without response\n");
  longjmp(env, 1);
}

static char *rcode_bindings[] = {
  "NOERROR",		/* 0 */
  "FORMERR",		/* 1 */
  "SERVFAIL",		/* 2 */
  "NXDOMAIN",		/* 3 */
  "NOTIMP",		/* 4 */
  "REFUSED",		/* 5 */
  "<unknown rcode>",	/* 6 */
  "<unknown rcode>",	/* 7 */
  "<unknown rcode>",	/* 8 */
  "<unknown rcode>",	/* 9 */
  "<unknown rcode>",	/* A */
  "<unknown rcode>",	/* B */
  "<unknown rcode>",	/* C */
  "<unknown rcode>",	/* D */
  "<unknown rcode>",	/* E */
  "NOCHANGE"		/* F */
};

/*
 * nsmon -- builds the query using res_mkquery() and then sends it using
 * res_send().  Calling parameters and return values are detailed in nsmon.h.
 */
int
nsmon (server, request, class, type, timeout, aa_only, debug)
  char *server, *request;
  int class, type, timeout, aa_only, debug;
{
  int n, ch;
  HEADER *hp;
  char buf[BUFSIZ], answer[BUFSIZ], *p;
  struct sockaddr_in sa;
  extern struct state _res;

  /* insert server address into _res structure */
  if (!setup_sockaddr(server, &_res.nsaddr_list[0], debug))
    return ERROR;
  _res.nsaddr_list[0].sin_port = htons(NAMESERVER_PORT);
 
  if (debug) 
    printf("Nameserver is %s, port %d\n",
      inet_ntoa(&_res.nsaddr_list[0].sin_addr),
      ntohs(_res.nsaddr_list[0].sin_port));

  /* set various flags for _res options */
  _res.options = RES_INIT;		/* don't call res_init() */
  _res.options |= RES_USEVC ;		/* use TCP and not UDP */
  _res.options |= RES_PRIMARY;		/* only query primary server */
  _res.options &= ~RES_RECURSE ;	/* no recursion */
  _res.options &= ~RES_DNSRCH ;		/* don't search parent, etc. */
  if (aa_only)
    _res.options |= RES_AAONLY; /* only accept authoritative answers */
  if (debug > 1) {
    _res.options |= RES_DEBUG;
    fprintf(stderr, "     _res.options = %ld\n", _res.options);
    fprintf(stderr, "     _res.defdname = %s\n", _res.defdname);
    fprintf(stderr, "About to call res_mkquery()\n");
  }

  /* First ask res_mkquery() to build a query structure */
  /* Types defined in nameser.h  T_A, T_NS, T_SOA, T_PTR */
  n = res_mkquery(QUERY, request, class, type, 
        (char *)NULL, 0, NULL, (char *)buf, sizeof(buf));
  /* query in buf */
  
  if (n < 0) {
    if (debug) {
      fprintf(stderr, "nsmon: problem with site %s\n", server);
      perror("res_mkquery");
    }
    return ERROR;
  }

  if (debug > 1) {
    fprintf(stderr, "     _res.options = %ld\n", _res.options);
    fprintf(stderr, "     _res.defdname = %s\n", _res.defdname);
    fprintf(stderr, "About to call res_send()\n");
  }

  /* Now send the query using res_send(), after setting timeout */
  if (setjmp(env)) {
    return ERROR;
  } else {
    signal(SIGALRM, alarm_handler);
    alarm(timeout);
    n = res_send(buf, n, answer, sizeof(answer)) ;
    alarm(0);
    signal(SIGALRM, SIG_IGN);
  }
  
  if (n < 0) {
    if (debug) {
      printf("nsmon: problem with site %s\n",  server);
      perror("res_send");
    }
    return ERROR;
  }
  
  hp = (HEADER *)answer ;
 
  if (hp->rcode != NOERROR) {
    if (debug)
      fprintf(stderr, "got rcode of %s from nameserver\n",
	      rcode_bindings[hp->rcode]);
    return ERROR;
  }
  if (aa_only && !(hp->aa))
    return NOT_AUTHORITATIVE;

  return ALL_OK;
}			/* end nsmon() */
