/*+ 
** $Header: /nocol/src/netmon/RCS/poll_input.c,v 1.4 1992/06/18 21:07:22 aggarwal Exp $
**/

/* Copyright 1992 JvNCnet, Princeton */

/*+
** 
** FUNCTION:
**	It polls for the user input asynchronously and returns the
** user input (integer = character). If there is no user input for as
** long as PAUSE (defined in the netmon.h include file), it returns a
** '0' value.
**
** Uses the 'select' function.
**
** AUTHOR
**	Vikas Aggarwal
**
**/

/*+ 
 * $Log: poll_input.c,v $
 * Revision 1.4  1992/06/18  21:07:22  aggarwal
 * Cleaned up the include file stuff
 *
 * Revision 1.3  1992/04/22  22:59:58  aggarwal
 * Lot of cleaning up for releasing. Organized things right.
 *
 * Revision 1.2  1990/03/09  12:14:44  aggarwal
 * Added the 'frozen' option where the poll waits indefinitely for a user
 * input (instead of the default PAUSE seconds).
 *
 * Revision 1.1  89/11/08  12:22:19  aggarwal
 * Initial revision
 * 
 */

#include "netmon.h"

#ifndef PAUSE
#define PAUSE 15		/* wait for 15 seconds for user input	*/
#endif

poll_input ()
{
    extern bool frozen ;			/* Defined in netmon.h	*/
    struct timeval tim_v;
    char   reply;
    int	   read_mask = 1 ;			/* For 'select' routine */

    tim_v.tv_sec = PAUSE;			/* init poll delay	*/
    tim_v.tv_usec = 0;

    if (frozen)
      reply = select (2, &read_mask, (int *)0, (int *)0, NULL) ;
    else
      reply = select (2, &read_mask, (int *)0, (int *)0, &tim_v) ;

    if (!(reply && read_mask))			/* no input, timed out	*/
      return(0); 
    else
      return (getchar()) ;			/* return the input 	*/
}
