/*+ 
** $Header: /nocol/src/netmon/RCS/parse_input.c,v 1.5 1992/06/18 21:06:55 aggarwal Exp $
**/

/* Copyright 1992 JvNCnet, Princeton */

/*+ 
** Parse the user input and act accordingly (call appropriate
** function). Note that it might modify the values of 'options' and 'level'
** which are defined in 'netmon.h'
**/

/*
 * $Log: parse_input.c,v $
 * Revision 1.5  1992/06/18  21:06:55  aggarwal
 * Updated for search filter.
 *
 * Revision 1.4  1992/04/23  15:43:42  aggarwal
 * Added ^S and ^Q also.
 *
 * Revision 1.3  1992/04/22  22:59:58  aggarwal
 * Lot of cleaning up for releasing. Organized things right.
 *
 * Revision 1.2  1990/04/17  17:28:36  network
 * Added the 'N' option for "netlog" ( it had better be in your
 * path...).
 *
 * Revision 1.1  90/03/09  16:25:51  aggarwal
 * Initial revision
 * 
 * 
 */

#include	"netmon.h"
#include	<ctype.h>

parse_input(response)
     char response;
{
    extern int options, level;			/* defined in netmon.h	*/
    extern bool frozen;
    extern struct allwins aw;			/* defined in netmon.h	*/
    int poll_input(), newresponse;

    switch (response)
    {
     case 'b':					/* toggle beep/bell	*/
	options = options ^ quiet ;
	break ;

     case 'c': 					/* Contract event win	*/
	--eventsz;
	endwin();
	all_doer();
	break ;

     case 'd':					/* toggle debug mode	*/
	options = options ^ debug;		/* XOR the debug bit	*/
	wprintw(aw.wmsg, "\n Debug mode ");
	if ( options & debug)
	  wprintw(aw.wmsg, "on");
	else
	  wprintw(aw.wmsg, "off");
	display_screenful() ;
	break ;

     case 'w':
     case 'e':					/* toggle wide mode	*/
	options = options ^ emode ;		/* XOR the extended bit	*/
	endwin ();
	all_doer() ;
	break ;

     case CTRL('s'): case CTRL('q'):
     case 'f':					/* Freeze display	*/
	frozen = !frozen ;			/* Invert the bit	*/
	msgtitle_dpy(aw.wmsgtitle);		/* To indicate frozen	*/
	display_screenful() ;			/* Show on terminal	*/
	parse_input(poll_input());		/* To redisplay present	*/
	break ;

     case 'l':					/* new display level	*/
	wprintw(aw.wmsg, "\nEnter new level [%d-%d]", E_CRITICAL, E_INFO);
	display_screenful();
	newresponse = poll_input() - '0';	/* character to number	*/
	if (newresponse >= E_CRITICAL && newresponse <= E_INFO )
	  level = newresponse ;
	wprintw(aw.wmsg, " %d OK", level);
	display_screenful() ;
	break ;

      case 'q':					/* quit			*/
	done ();
	break ;

      case '?': case 'h':			/* Help page		*/
	help_page();
	display_screenful();			/* Main window again	*/
	break;
	
#ifdef NETLOG
      case 'n':		                       /* Run NETLOG           */
	endwin();
	system ("netlog");                      /* better be in path    */
	wrefresh(curscr);
	break;
#endif
     case CTRL('l'):
     case 'r':					/* redraw screen	*/
	wrefresh (curscr);
	parse_input (poll_input());
	break ;

     case 's':					/* search filter */
     case '/': case '|':
	read_filter();
	msgtitle_dpy(aw.wmsgtitle);		/* indicate filter in effect */
	display_screenful();
	break ;

     case 'x':					/* Expand window	*/
	++eventsz;
	endwin();
	all_doer();
	break;

     default:					/* return for next scr	*/
	break ;
    }					    	/* End switch()		*/

    return (1);	
}						/* End:  parse_input()	*/
