/*+ 
** $Header: /nocol/src/netmon/RCS/event_dpy.c,v 1.10 1992/06/18 21:03:22 aggarwal Exp $
**/

/*+ 
** Displays the network events in the event window. Calls upon the
** function fill_window() to display *all* files in the datadir.
**/

/*
 *
 *	$Log: event_dpy.c,v $
 * Revision 1.10  1992/06/18  21:03:22  aggarwal
 * Cleaned up for releasing.
 *
 * Revision 1.9  1992/05/14  11:02:45  aggarwal
 * Changed display of address from 'inet_ntoa' to 'char' after change
 * of the event structure in nocol.h
 *
 * Revision 1.4  90/05/13  16:13:47  aggarwal
 * Added option in display_one_evnt() so that nothing is
 * displayed (event ignored) if the read struct event
 * is all zero. This is done to avoid the occurrence
 * of displaying zeroes if the datafile is open by netmon and is
 * overwritten by a smaller datafile.
 * 
 * Revision 1.1  90/03/09  13:05:33  aggarwal
 * Initial revision
 * 
 */

#include	"netmon.h"
#include 	<sys/dir.h>

static int warnbeep ;				/* Set to beep once	*/
static int startcycle ;				/* if reopening datadir	*/

event_dpy ()
{
    extern int page;				/* In netmon.h 		*/
    extern struct allwins aw ;			/* In netmon.h		*/
    extern char *datadir ;			/* in netmon.h		*/
    static DIR *datadirp ;		     	/* Ptr to data dir	*/
    static int datafd ;				/* Open file desc	*/
    int display_one_event() ;

    if (datadirp == NULL)			/* Not opened yet	*/
    {
	page = 1;				/* reset the value	*/
	startcycle = 0;
	if ((datadirp = opendir(datadir)) == NULL)	/* Cannot open	*/
	{
	    wprintw (aw.wmsg, 
		     "\nevent_dpy (opendir) %s", sys_errlist[errno]) ;
	    wclrtoeol(aw.wmsg) ;
	    return(1) ;				/* minor error	*/
	}
    }

    if (fill_window(aw.wevent, datadirp, datadir, &datafd, display_one_event))
    {
	closedir(datadirp);			/* All files displayed	*/
	datadirp = NULL ;			/* reset to reopen dir	*/
	datafd = 0 ;
	if (warnbeep)
	{
	    Beep() ;				/* Beep once at end	*/
	    warnbeep = 0 ;			/* reset the value	*/
	}

    }
    return(0);

}						/* end:  event_dpy	*/

/*+ 		display_one_event
** FUNCTION:
** 	This function displays one line / event on the window passed
** to it. This funtion is repeatedly called *BY* the fill_window()
** function until the window is filled.
**
** Ignores and prints nothing if the read event struct is zero.
** This was done to prevent the program from displaying zeroes if 
** the current data file is over-written with new data while the 
** file pointer is left after the end of the end of the file - the
** program started displaying zeroes if this is not done.
**
** It first prints out the data as desired using EFMT & SFMT. The
** last field (status) is printed out depending on the value of the
** event.severity & event.nocop
**
** Can customize the status part to print whatever you want, but rather
** not mess with the EFMT and SFMT parts.
** Presently indicates a TEST site by adding "test" in the status.
** If IGNORE flag is set, then does not display event at all.
**
** If the 'startcycle' value is zero, that implies that the data directory
** has been reopened (a new cycle). Keep track of the previous critical
** sites and the new critical sites. IF the number of critical sites
** increases, then force the bell on.
**
** RETURN VALUES:
** 	0   if reached end of present file
** 	1   if not at end of data file.
**/

display_one_event(fd, wevent)
     int fd ;					/* opened file descr	*/
     WINDOW *wevent;				/* Output window	*/
{
    extern int page ;
    EVENT v;					/* from nocol.h		*/
    static int prevcritical, curcritical ;	/* Number of critical	*/

    if (startcycle == 0)			/* new cycle		*/
    {
	startcycle = 1 ;
	prevcritical = curcritical ;		/* save previous value	*/
	curcritical = 0 ;
    }


    if (read (fd, (char *)&v, sizeof(v)) != sizeof(v))
      return (0) ;				/* end of file ? */
    else
    {
	static EVENT null_event ;		/* All fields are null	*/

	if (bcmp(&v, &null_event, sizeof(v)) != 0)	/* not null 'v'	*/
	  if (v.severity <= level && !(v.nocop & n_NODISPLAY))
	    if (filter(&v))
	    {					/* if to be displayed	*/
		if (options & emode)		     	/* long mode	*/
		  wprintw ( wevent, EFMT, EFIELDS );
		else					/* Short mode	*/
		  wprintw (wevent, SFMT, SFIELDS  );
		
		switch (v.severity)
		{
		 case E_CRITICAL:
		    if (!(options & quiet))
		      warnbeep = 1 ;		/* Beep once in window	*/
		    ++curcritical ;		/* Increase number	*/
		    if (curcritical > prevcritical)
		      options = options & (~quiet);	/* Force bell on */
		    
		    wstandout (wevent);
		    if (v.nocop & n_TEST)
		      wprintw (wevent, "%-8.8s", "Test-Cri");
		    else
		      wprintw (wevent, "%-8.8s", "Critical");
		    wstandend (wevent);
		    break;
		 case E_ERROR:
		    /* Displaying the bold strings is a real pain */
/*		    wprintw (wevent, "%s", bolds);	/* bold string */
		    if (v.nocop & n_TEST)
		      wprintw (wevent, "%-8.8s", "Test-Err");
		    else
		      wprintw (wevent, "%-8.8s", "Error   ");
		    if (bolde)
		      tputs(bolde, 1, outchar) ;
/*		    wprintw (wevent, "%s", bolde);	/* turn off bolding */
		    break;
		 case E_WARNING:
		    if (v.nocop & n_TEST)
		      wprintw (wevent, "%-8.8s", "Test-War");
		    else
		      wprintw (wevent, "%-8.8s", "Warning ");
		    break;
		 case E_INFO:
		    wprintw (wevent, "%-8.8s", "Info");
		    break;
		    
		}				/* end of:   switch	*/

		/*
		 * This test is necessary since the bold strings were
		 * causing curses to think that the line had wrapped, and
		 * the '\n' would insert a blank line. This way, if the
		 * line wrapped, then the (internal) location of the cursor
		 * will be low (less than 10 or so).
		 */
/*		if (wevent->_curx > 10)		/* else wrapped line */
		  wprintw(wevent, "\n") ;	/* insert a newline	*/
	      
	    }					/* end: if(severity..)	*/
	return(1) ;
    }						/* end:  if read()	*/

}		/* end:  event_dpy	*/


/*+ 
 ** FUNCTION:
 ** 	To 'beep' on the terminal.
 **/

Beep()
{
    tputs( bellstr, /* 1 for no lines affected */ 1, 
	  /* routine to print char, cannot be a macro */ outchar) ;
}
