/*
** $Header: /nocol/src/include/RCS/pingmon.h,v 1.11 1992/06/12 04:43:20 aggarwal Exp $
*/

#include "nocol.h"

/*
 *		FILE DEFINITIONS
 *
 * DATADIR is the location of the datafile. The name is prepended to
 * PINGOUTPUT to create the output filename.
 *
 * NODESFILE is the full name of the file containing the list of hosts
 * and ip addresses.
 *
 * The program needs to know the location of the 'ping' progam that is
 * to be used.
 */

#ifndef DATADIR
#define DATADIR		"../../data"
#endif

#ifndef NODESFILE
#define NODESFILE	"../../etc/ipnodes"
#endif

/*
 * If using IP, then you might like to use the 'multiping' program which
 * pings multiple sites synchronously. If defined, it defines the PING
 * value also.
 */
#ifndef IP
# undef MULTIPING		/* undef so poll_sites.c okay */
#endif  /* IP */

#ifdef MULTIPING
#  ifndef BATCHSIZE
#    define BATCHSIZE 32	/* number of sites to ping at a time */
#  endif			/* less than limit MAXBATCH in multiping.c */
#  ifndef PING
#    define PING 	"multiping"	/* the multi ping command to use */
#  endif	/* PING */
#else
#  define BATCHSIZE 1			/* for standard ping programs */
#endif /* MULTIPING */


/*
 * The progam automatically fills in its own name in the EVENT.sender
 * field. If you want to over-ride this name with your own, then define
 * SENDER
 */
/* #define SENDER	"pingmon"	/* */


/*************** Rest is standard and need not be touched ***********/

#ifndef PING
#  ifdef sun
#    define PING	"/usr/etc/ping"
#  else
#    define PING	"/etc/ping"
#  endif	/* sun */
#endif	/* PING */

/*
 * Extension of the output datafile. DATADIR/prognm is tacked onto this name.
 */
#define	PINGOUTPUTEXT  "-output"

/*
 *		CONSTANTS
*/
#ifndef BUFSIZ		      		/* in stdio.h */
#define BUFSIZ 1024
#endif /* BUFSIZ */

#define MAXLINE		127	/* Randomly selected string lengths */
#define	DATALEN		100	/* Size of ping packets	(bytes) */
#define	NPACKETS	10	/* Number of ping packets sent */
#define PING_THRES      3	/* If more than this pkts lost, then down */
#define POLLINTERVAL	180	/* secs between starting next poll */

#define VARNM		"Reachability"	/* for EVENT.var.name field	*/
#define VARUNITS	"Pkts"		/* Units name */
#define DEBUG_FLG "NOCOL_DEBUG"		/* to run in debug mode	if set	*/

/*
 * Global variables
 */
int debug ;
char *prognm ;				/* Program name			*/
char *sender ;				/* Name used in the v.sender field */
char ipnodes[MAXLINE];			/* File with the list of nodes	*/
char datafile[MAXLINE] ;		/* Names of the data file	*/
char *ping ;				/* which ping to use		*/
char pingcmd[BUFSIZ] ;			/* The ping command used	*/

char sigtoprog[MAXLINE] ;		/* Prog recieving SIGUSR1 sig when
					   a site goes CRITICAL */



