
/*	$Header: perfmon.h,v 1.3 90/07/26 15:56:53 wuu Exp $	*/ 

/****************************************************************/
/* 	PERFMON.H						*/
/****************************************************************/

#define MAXVARNAM	128
#define MAXTYPNAM	16
#define MAXDIRNAM	64
#define MAXVARS		50
#define MAXFILNAM	128
#define MAXINPUTS	200
#define MAXKWLEN	50	
#define MAXSITENAM	50
#define ADDRLEN		4

/* filename */
typedef struct {
	char	name[MAXFILNAM];
} FILNAM;

/* variable statistics record */
typedef struct
{
	char		prev_time[9];	/* previous hh:mm:ss */
	int		prev_val;	/* previous accumulative value */
	unsigned int	cur_val;	/* current delta value */
	float		cur_ratio;	/* current delta ratio */
	unsigned int	dlyacc;		/* daily accumulative value */
	float		dlyacc_ratio;	/* daily accumulative ratio */
	unsigned int	max_val;	/* maximum delta value */
	float		max_ratio;	/* maximum delta ratio */
	unsigned int	min_val;	/* minimum delta value */
	float		min_ratio;	/* minimum delta ratio */
	unsigned int	ave_val;	/* average delta value */
	float		ave_ratio;	/* average delta ratio */
	unsigned int	cnt;		/* delta interval count */
	unsigned int	low_cnt;	/* count of low threshold excedes*/
	unsigned int	hi_cnt;		/* count of high threshold excedes */
} VARSTAT;

/* report variable */
typedef struct
{
	char	varname[MAXVARNAM];	/* SNMP var name */
	unsigned int	low_thd;	/* low threshold */ 
	unsigned int	hi_thd;		/* high threshold */
	char	valtype;		/* 'A' for absolute delta or 
					   'R' for delta relative to base */
	unsigned int	baseval;	/* base for relative value */
	VARSTAT	varstat;		/* variable statistics record */
} VARINFO;

typedef struct {
	char	site[MAXSITENAM];	/* site name */
	struct in_addr inaddr; 		/* ip address of the interface */
	FILNAM	infile;			/* input snmp raw data file */
	FILNAM	logfile;		/* snmp log file */
	long int offset;		/* offset of last byte read */
	int  	num_vars;		/* number of variables */
	VARINFO	vars[MAXVARS];		/* array of SNMP variables */
} DATA;

/* monitor structure */
typedef struct 
{
	FILNAM	display;		/* alarm file or device */
	FILNAM	errlog;			/* error history file */
	int	log_level;		/* error log level */
	int	interval;		/* length of monitoring time interval */
	int	disp_cycle;		/* number of mon cycles for display */
	char	snmpdir[MAXDIRNAM];	/* directory of data files */
	int	num_inputs;		/* number of input files */
	DATA	inputs[MAXINPUTS];	/* input data */
} MONINFO;

#define LNLEN		256
#define NULLBYTE	'\0'
#define MAXLEVEL	L_ALL

#define SLEEPTIME	600		/* 10 minutes */
#define DISPCYCLE	3		/* 30 minutes */
#define L_ALL		4		/* log all entries */
#define L_CRITICAL	1		/* log only critical entries */
#define L_ERROR		2		/* log critical and error entries */
#define L_WARNING	3		/* log critical,error & warning entries */
#define DEFLEVEL	L_WARNING	/* default level */

#define SNMPFMT "%s%s%d%s%s%s%s%d"
#define DEFCONFG  "perfmon.cf"
#define DEFDISP	"/u0/nocol/data/perfmon.display"
#define DEFERR  "/u0/nocol/data/perfmon.errlog"


