/*
 * $Header: /nocol/src/include/RCS/nsmon.h,v 1.2 1992/06/11 05:05:09 aggarwal Exp $
 */
#ifndef __NSMON_H__
#define __NSMON_H__


/*
 *		FILE DEFINITIONS
 *
 * DATADIR is the location of the datafile. The name is prepended to
 * PINGOUTPUT to create the output filename.
 *
 * NODESFILE is the full name of the file containing the list of hosts
 * and ip addresses.
 *
 * The program needs to know the location of the 'ping' progam that is
 * to be used.
 */

#ifndef DATADIR
#define DATADIR		"../../data"
#endif

#ifndef NODESFILE
#define NODESFILE	"../../etc/nsmon-confg"
#endif

/*
 * The progam automatically fills in its own name in the EVENT.sender
 * field. If you want to over-ride this name with your own, then define
 * SENDER
 */
/* #define SENDER	"nsmon"	/* */

/*
 * Extension of the output datafile. DATADIR/prognm is tacked onto this name.
 */
#define	NSMONOUTPUTEXT  "-output"

/*
 *		CONSTANTS
 */
#ifndef BUFSIZ		      		/* in stdio.h */
#define BUFSIZ 1024
#endif /* BUFSIZ */

#define MAXLINE		127		/* Randomly selected string lengths */

#define VARNM		"named status"  	/* for EVENT.var.name field */
#define VARUNITS	"SOA"			/* Units name (none)*/
#define DEBUG_FLG 	"NOCOL_DEBUG"		/* run in debug mode if set */
#define POLLINTERVAL	(time_t)60		/* interval between queries */

  /*
   * C_IN and T_SOA are #defined in /usr/include/arpa/nameser.h.
   *
   * QUERY is the actual data with which to query the server.  If the
   * data is not needed just #define it to "".  For example, if QUERY
   * is T_PTR, then nsmon will construct a query by taking the IP# of
   * the server and making an in-addr.arpa out of it, so no QUERY is
   * needed, but it needs to be #defined to avoid compiler errors.
   */

#define QUERYTIMEOUT	20	/* timeout connections in this many seconds */
#define QUERYCLASS	C_IN	/* query class */
#define QUERYTYPE	T_SOA	/* type of query to make */
#define QUERY_AA_ONLY	0	/* set to 1 to set RES_AAONLY flag of _res */
#ifndef QUERYDATA
#define QUERYDATA	"jvnc.net"
#endif

/*
 * Global variables
 */
#ifdef GLOBALS
#define EXTERN
#else
#define EXTERN extern
#endif

EXTERN int debug;
EXTERN char *prognm;			/* Program name			*/
EXTERN char *sender;			/* Name used in the v.sender field */
EXTERN char ipnodes[MAXLINE];		/* File with the list of nodes	*/
EXTERN char datafile[MAXLINE] ;		/* Names of the data file	*/
EXTERN char sigtoprog[MAXLINE] ;	/* Prog recieving SIGUSR1 sig when

/*
 * nsmon() -- does all the dirty work
 *
 * input parameters:
 *      server: address of the nameserver to be queried (MUST be an IP #)
 *      request: query to be passed to nameserver.  If type is T_SOA then
 *              this needs to be a domain name
 *      class: a class, probably C_IN, as defined in <arpa/nameser.h>
 *      type: query type, probably T_SOA, as defined in <arpa/nameser.h>
 *      timeout: if no response in this many seconds, give up
 *      flags: options as defined below
 *
 * return values: defined below
 */

int nsmon(/* char *server, char *request, int class, int type,
  int timeout, int aa_only, int debug */);

/* return codes from nsmon() */

#define ALL_OK			0	/* everything's groovy */
#define NOT_AUTHORITATIVE	1	/* got a response, but not auth. */
#define ERROR			2	/* no response, or connection */

#endif /* __NSMON__H__ */


