/*
** $Header: /nocol/src/include/RCS/netmon.h,v 1.14 1992/06/18 20:40:07 aggarwal Exp $
*/

/*
**		INCLUDE FILES
*/
#include "nocol.h"
#include <ctype.h>
#include <sys/stat.h>		/* needed in fill_window() */
#include <sys/file.h>		/* for raw i/o read/write */
#include <signal.h>
#include <curses.h>		/* since WINDOW definitions are here	*/

/*
 * For 4.2 curses.
 */
#ifndef cbreak
#define cbreak() crmode()
#endif
#ifndef nocbreak
#define nocbreak() nocrmode()
#endif

/*
 * Usually defined in ttychars.h.
 */
#ifndef ESC             /* ESCAPE character */
#define ESC 033
#endif

#ifndef RUBOUT
#define RUBOUT        	'\177'
#endif

#ifdef CTRL             /* Some implementations do a: c & 037 (assume int) */
#undef CTRL             /* and some do 'c' & 037, so use our version... */
#endif  /* CTRL */
#define CTRL(c)         (c & 037)	/* treat as an integer */

#ifndef beep				/* crude way of doing it.. */
#define beep() (fprintf (stderr, "%c", 007))
#endif    /* beep */

#ifndef max
#define max(a, b)	((a) > (b) ? (a) : (b))
#endif	/* endif max */

/*
 *		FILE DEFINITIONS
 *
 * All files in the DATADIR are opened and processed and their output is
 * displayed. The files have records in the format described in 'nocol.h'
 *
 * The 'msgsdir' is used for the message display. Any file in this directory
 * will be treated as a ascii text file and its contents will be displayed in
 * the 'Message' sub-window.
 */
#ifndef DATADIR					/* for default location	*/
#define DATADIR	 "../../data"			/* dont miss quotes	*/
#endif
#ifndef MSGSDIR					/* for default location	*/
#define MSGSDIR	 "../../msgs"			/* dont miss quotes	*/
#endif
#ifndef HELPFILE
#define HELPFILE 	"./netmon-help"
#endif

/*
 * Define NETLOG if you want to invoke 'netlog' from netmon when the user
 * hits the 'n' option. This is invoking another program so be careful in who
 * is allowed access to this program.
 */
/* #define NETLOG	/* */

/*
 * 'netmon' extracts the terminal capabilities from /etc/termcap. Some
 * terminals are very common and are present in every 'termcap', so you
 * can list those terminals here to prevent doing a lookup using 'tgetent'.
 *
 * On the other hand, there are some terminals in /etc/termcap that are
 * set by standard programs by default (like 'network' or 'ethernet', in
 * which case you might want to query the user for the terminal type
 * instead of accepting them as 'dumb' right away. List those terminals
 * here too.
 *
 */

#define GOODTERMINALS	"vt100", "vt200", "xterm", "sun"
#define BADTERMINALS	"ethernet", "network", "dialup"


/*******************  Rest is fairly standard ****************************/

/*
**		CONSTANTS
*/
#define MAXLINE 	127		       	/* LINE lengths		*/
#define MAXWORD		15
#define PAUSE		15			/* wait secs for poll()	*/

/*+ 
** The various display flags
**/

#define emode 0x1		/* expanded display (132 cols) */
#define debug 0x2		/* netmon debug mode */
#define quiet 0x4		/* toggle bell off or on */

/*
**	Global definitions
*/

char *prognm;					/* program name		*/
char *datadir ;					/* Dir of data files	*/
char *msgsdir ;					/* Dir with text msg files */
char *helpfile ;				/* help file 		*/
char bolds[MAXWORD];				/* Bold sequence	*/
char bolde[MAXWORD];				/* Bold end sequence	*/
char clscr[MAXWORD];			    	/* Clear screen sequence */
char bellstr[MAXWORD];				/* Bell sequence */
int  level,					/* display level	*/
  options,					/* user options		*/
  page,						/* Page number		*/
  msg_on ;					/* toggle for msg_dpy()	*/
int  entered_curses ;				/* so done can call endwin */
int titlesz, hdrsz, promptsz, 			/* various window sizes	*/
  msgtitlesz, msgsz, eventsz ;
bool  frozen ;					/* indefinite poll wait	*/

extern char *good_terminals[],
  *bad_terminals[] ;				/* defined in main()	*/
extern char *tgetstr() ;			/* 'termcap' routine	*/
int outchar() ;					/* func for tgetstr() */

/*
 * The netmon screen is made up of several subwindows. This struct is
 * essentially a list of all the windows on the main netmon screen.
 */
struct allwins
{
    WINDOW    	*wmain;
    WINDOW     	*wtitle;			/* the title window	*/
    WINDOW	*whdr;				/* the column headers	*/
    WINDOW	*wevent;			/* the event window	*/
    WINDOW	*wmsgtitle;			/* message window title	*/
    WINDOW	*wmsg;				/* the small msg win	*/
    WINDOW	*wprompt;			/* the prompt window	*/
} aw;				/* aw allocates storage for the struct	*/

/*  Window sizes:
** Initially 'wevent' size is computed as the remaining lines after all 
** else. After that it can be changed by the user.
*/

#define TITLESZ		2			/* one blank line	*/
#define HDRSZ		2			/* one blank line	*/
#define MSGTITLESZ	2			/* one blank line	*/
#define MSGSZ		3			/* Messages window	*/
#define PROMPTSZ	2			/* one blank line above	*/
#define EVENTSZ		LINES - (TITLESZ+HDRSZ+MSGTITLESZ+MSGSZ+PROMPTSZ)

#define MNCOLS		80		/* depends on extended display	*/

/*+ 
** Display strings and formats
*/

#define PROMPTA "Enter option, 'q' to quit, 'h' for help: "
#define PROMPTB "Enter option, or any other key for next screen: "

/*
 * The header names and the formats are coded here. They depend on the 'event'
 * structure and should be modified with care. Make sure that you match the
 * sizes with the size of the various fields in 'nocol.h'. Leave space for
 * the 'condition' string added at the end.
 */
/*                        1         2         3         4         5         6         7         8         9         0         1         2 */
/*               123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789. */
#define EHDR	"         Site      Address      Date  Time   +- Sender -+  +-- Variable --+ +- Value-+  + Thres -+    Units  Flags  Condition "
/*               +++++++++|++++  +++++++++|+++++ ++/++ ++:++  +++++++++|++  +++++++++|++++++ +++++++++|  +++++++++|  ++++++++  +++   END */
#define EFMT 	"%14.14s  %-15.15s %02d/%02d %02d:%02d  %-12.12s  %16.16s %10lu  %10lu  %8.8s  %03o   "	/* Condition added at end */
#define EFIELDS v.site.name, v.site.addr, v.mon,v.day,v.hour,v.min, v.sender, v.var.name, v.var.value, v.var.threshold, v.var.units, v.nocop

/*               123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789. */
#define SHDR	"         Site      Address      Time   +-Variable-+ +-Value-+  Condition  "
/*               +++++++++|++++  +++++++++|+++++ ++/++  +++++++++|++ ++++++++    END */
#define SFMT	"%14.14s  %-15.15s %02d:%02d  %12.12s %8lu    "  /* 62 chars */
#define SFIELDS	v.site.name, v.site.addr, v.hour, v.min, v.var.name, v.var.value


/*
 * Define types of user responses for get_reply()
 */
#define C_ANY		0x0	/* Any character (printable or non-) */
#define C_ALPHA		0x1	/* A-z */
#define C_DIGIT		0x2	/* 0-9 */
#define C_SPACE		0x4	/* SPACE, TAB */
#define C_PUNCT		0x8	/* All punctuation characters */
