.\" $Header: perfmon.8,v 1.1 89/12/15 16:08:02 network Exp $
.TH PERFMON 8 "November 20, 1989"
.SH NAME
perfmon \- generic performance monitoring application for multiple agents
using the snmppoll data.
.SH SYNOPSIS
.B perfmon [-f confg] [-l level]
.SH DESCRIPTION
.LP
.I perfmon
is a generic monitoring application designed to execute on the host on
which snmp data has been queried from multiple agents by \fIsnmppoll\fR
for information over an extended period of time.
All or a subset of information being polled can be monitored with
different performance criteria.
What information is monitored, for which gateway, how often the
information is monitored, and what performance criteria is used are 
all dictated by the
.I perfmon
configuration file (described below).
The name of the configuration file can be given as an
option in the command line or if none is given, the process
will assume the default name, 
.I perfmon.cf,
is used.
.LP
Regardless of when the \fIperfmon\fR process is started, it always
reads from the beginning of the snmppoll data files. 
It continues reading and processing until it reaches the end of file
for all data files to be monitored. It then hibernates until the next cycle.
.LP
.I perfmon
is an application process which is integrated into the JvNCnet NOCOL
system. It can also be run alone.  It generates an error log file and
a file of the most current logs for NOCOL display.
Both files contain fixed length event records. Events are logged up to
the level of severity specified in the
configuration file or given as input to the command line.
.LP
.I perfmon
also generates a summary of the day as a UNIX flat file when killed with
UNIX command 
.I kill 
with option 
.I -30
to generate a summary but not to terminate the application process, or 
with option
.I -15
to generate a summary and terminate the application process. 
The summary file will be namd as 
.I Monitor.Summary 
and will be located in the today's date subdirectory
of the SNMP data directory specified in the configuration file.
.SH OPTIONS
.LP
The 
.I perfmon
application may be invoked with the following options :
.IP
.I -c confg :
\fIconfg\fR specifies the configuration file that should be used. If this
option is not used, the default configuration file \fIperfmon.cf\fR
in the present directory is assumed.
.IP
.I -l level :
\fIlevel\fR specifies the maximum level of severity of events should be
logged. Valid levels range from 1 to 4 where 1 indicates the highest 
level of severity (critical) and 4 indicates the lowest (informational)
This option can also be given in the configuration file.
.SH PERFMON CONFIGURATION FILE
.LP
The 
.I perfmon
configuration file is consulted upon startup of a
.I perfmon
process.
Fields in the configuration file are used to determine the log level,
base interval for monitoring, the error log and the display log
file names, the number of monitoring cycles to be logged to the display file, 
the snmppoll data directory, the agent or interface to be monitored,
should the variable monitored by absolute value or a 
percentage of a base value, and
what are the low threshold and high threshold for the variable monitored. 
The general format of the configuration file is an WATCH line (see below)
followed by a list of VAR lines (each corresponding to a variable
to be monitored for the interface or agent specified by the WATCH line), with
this grouping of WATCH and VAR lines repeated for each agent or interface.
.LP
Options in the configuration file are :
.in +3
.IP -
INTERVAL \fIinterval cycle\fR : set the base monitoring interval for this 
invocation of the application to \fIinterval\fR seconds and the most
recent \fIcycle\fR monitoring cycles will be displayed. 
The interval must be specified in seconds. 
If this option is not given, the default interval is 600 seconds and
the default cycle is 3.
.IP -
LEVEL \fIlevel\fR : specifies the level of severity of events up to which
should be logged. The valid levels are 1 for critical, 2 for error, 
3 for warning, and 4 for informational. The default level is 3 (warning).
.IP -
SNMPDIR \fIdir\fR : specifies the top directory of \fIsnmppoll\fR output data.
.IP -
DISPLAY \fIdisplay-file\fR :
specifies the full path and file name of the display file.
This file will contain the events happen in the last 
\fIcycle\fR monitoring cycles. 
.IP -
ERRLOG \fIerror-log\fR :
specifies the full path and file name of the error event log file.
This file will contain the events of severity level less than (more
severe) or equal to the level chosen.
.IP -
WATCH \fIsite ipadd snmppoll-file\fR :
monitor the agent at ip address \fIipadd\fR using the snmppoll output
data file \fIsnmppoll-file\fR. The path relative to the snmppoll data directory
as described above should be included in the \fIsnmppoll-file\fR
filename.
.IP -
VAR \fIvariable low-threshold high-threshold A-or-R [ratio-base]\fR : 
monitor the value of variable \fIvariable\fR which may be the full SNMP
variable name or any substring of the SNMP variable name. 
When the value exceeds the
\fIlow-threshold\fR, a warning event is logged; when the value exceeds the
\fIhigh-threshold\fR, an error event is logged. The value may be 
absolute (A) or a ratio (R) of the \fIratio-base\fR. 
.br
.in -2
Note that a VAR line must be preceded by at
least one WATCH line; the VAR line will correspond to the last
WATCH line preceding this VAR line.
.br
.PP
An example configuration file for this application can be found in 
the /u0/nocol/bin directory on jvncb.csc.org.
.SH FILES
.in +5
/etc/snmp.variables		The variable initfile
.br
perfmon.cf			The perfmon configfile
.br
snmppoll.cf			The snmppoll configfile
.in -5
.SH SEE ALSO
snmppoll
.br
kill(1)
.br
"Simple Network Management Protocol", RFC 1098, by
J.D. Case,
M.S. Fedor,
M.L. Schoffstall and
J.R Davin;
"SNMP Implementation 3.3", by
H.M. Tam,
M.L. Schoffstall,
W. Yeong,
M.S. Fedor;
"Management Information Base for Network Management of TCP/IP Based Internets",
RFC 1066, by
M. Rose and
K. McCloghrie; and
"Structure and Identification of Management Information
for TCP/IP Based Internets", RFC 1065, by
M. Rose and
K. McCloghrie.
