/*+
 * $Header: /noc/network/netlog/src/RCS/cookie.c,v 2.0 1992/05/10 16:28:26 aggarwal Exp $
 */

/* Copyright 1992 JvNCnet, Princeton University */

/*+ 		cookie
** 	Print out fortune cookie.
**
** I read the fortune from the COOKIEJAR. If no such file, then simply
** return a value of 1. Otherwise, get stats of the file and get any
** random integer less than the file size. Seek to that random location
** and print the first cookie that exists after that. Print none if
** there is no last cookie.
**
** Each cookie must be separated by COOKIESEP or a COOKIEASEP at the 
** start of a line.
**
** 	Vikas Aggarwal, vikas@jvnc.net
**/

#include "netlog.h"			/* definition of COOKIEJAR	*/

#ifndef COOKIEJAR
#define COOKIEJAR "cookie-jar"
#endif

#define COOKIEASEP	" -----"	/* An alternate separator	*/

cookie()
{
    off_t  i ;					/* file offset		*/
    int fd ;					/* file desc + num read	*/
    struct stat sbuf ;
    char line[MAXLINE] ;			/* for read text	*/
    register char *pline = line ;		/* a fast pointer	*/
    time_t t = time((long *)NULL) ;		/* for random integer	*/

    if ((fd = open(tackon_dir(ETCDIR, COOKIEJAR), O_RDONLY)) < 0)
      return(1);				/* No cookie jar	*/

    fstat(fd, &sbuf) ;				/* get a random num... 	*/
    if (sbuf.st_size == 0)			/* empty file		*/
      return(0);
    (off_t)i = (long)t % (long)sbuf.st_size ;	/* within file size   	*/

    if (lseek(fd, (off_t)i, L_SET) == -1)
      goto messedup ;

    for (; ;)
    {
	if (fd_getline(fd, pline, MAXLINE) <= 0)
	  goto okdone ;				/* end of file reached	*/

	if (e_o_cookie(pline))			/* Found end of cookie	*/
	{
	    while (fd_getline(fd, pline, MAXLINE) > 0 && !e_o_cookie(pline))
	      printf("%s", pline);
	    goto okdone ;
	}
    }

 okdone:
    putchar ('\n') ;				/* newline at end	*/
    fflush(stdout);
    close(fd);
    return(0);

 messedup:
    close(fd);
    return(1);

}


/*+ 		e_o_cookie()
** FUNCTION:
** 	Returns a 1 if it the line passed to it matches one of the
** end_of_cookie characters.
**/
e_o_cookie(str)
  char *str ;
{
    static char *sepa = COOKIESEP ;
    static char *sepb = COOKIEASEP ;

    if (strncmp(str, sepa, sizeof(sepa)) == 0 || 
	strncmp(str, sepb, sizeof(sepb)) == 0)

      return(1);			/* end of cookie	*/

    else
      return(0);			/* Not end of cookie	*/
}



