#! /bin/csh -f

#
# This is a command file to build a host table format file for NEARnet
# gateways based on information from the domain system (via DNSQ)
#


## #  #   #    #     #      #       #      #     #    #   #  # ##
#
echo		"Getting data from DNS for all NEARnet hosts..."
#
## #  #   #    #     #      #       #      #     #    #   #  # ##


# Make sure we start out with a clean slate
/bin/rm -f Hosts.NEAR.DNS.new

# Go get the data for all hosts
../misc/dnsq -l -v -t any NEAR.Net NIC.NEAR.Net >/tmp/foo$$

# Check that we got two identical SOA records...
if ( `awk 'BEGIN{n=1;fn="/tmp/soa" n ".'$$'";}/SOA/,/;minimum/{ print > fn}/;minimum/{n++;fn="/tmp/soa" n ".'$$'";}END{print n}' </tmp/foo$$` != 3 ) then
	cat /tmp/soa*.$$|/usr/ucb/mail -s "Didn't get 2 SOA's in NEARnet zone dump." MAP=Status
	rm -f /tmp/foo$$ /tmp/soa*.$$
	exit 1
endif
if ( ! { /bin/cmp -s /tmp/soa[12].$$ } ) then
	cat /tmp/soa*.$$|/usr/ucb/mail -s "SOA RRs don't match in NEARnet zone dump." MAP=Status
	rm -f /tmp/foo$$ /tmp/soa*.$$
	exit 1
endif

# Extract useful parts...
echo ";;; NEARnet gateways, DNS file." >Hosts.NEAR.DNS.new
echo ";;;  Generated by `/usr/ucb/whoami` on `/bin/hostname` at `/bin/date`." >>Hosts.NEAR.DNS.new
echo "" >>Hosts.NEAR.DNS.new
/bin/awk '$1==")"{f++;next}f==1{if($4=="SOA")f++;else print}' </tmp/foo$$ | \
	grep -i near.net | \
	/usr/bin/sort -u >>Hosts.NEAR.DNS.new

# See if anything changed (other than the date and who ran the script :-)
/usr/ucb/tail +3 Hosts.NEAR.DNS >/tmp/foo$$
/usr/ucb/tail +3 Hosts.NEAR.DNS.new >/tmp/bar$$
if ( { /bin/cmp -s /tmp/foo$$ /tmp/bar$$ } ) then
	/bin/echo "New Hosts.NEAR.DNS same as before, just leave the old one."
	/bin/rm -f /tmp/foo$$ /tmp/bar$$ Hosts.NEAR.DNS.new
	exit 0
endif
/bin/rm -f /tmp/foo$$ /tmp/bar$$ /tmp/soa*.$$


/bin/rm -f Hosts.NEAR.DNS.old
/bin/ln Hosts.NEAR.DNS Hosts.NEAR.DNS.old
/bin/mv Hosts.NEAR.DNS.new Hosts.NEAR.DNS



## #  #   #    #     #      #       #      #     #    #   #  # ##
#
echo		"DNS data retreived, converting to host table..."
#
## #  #   #    #     #      #       #      #     #    #   #  # ##

/bin/rm -f Hosts.NEAR.new
echo ";;; NEARnet host table file." >Hosts.NEAR.new
echo ";;;  Generated by `/usr/ucb/whoami` on `/bin/hostname` at `/bin/date`." >>Hosts.NEAR.new
echo "" >>Hosts.NEAR.new
# Find all the ones that have A records to use as masters.
foreach h ( `awk '$4=="A"{print $1}' Hosts.NEAR.DNS | sort -u` )
	echo -n "Making record for $h..."
	grep -i "$h" Hosts.NEAR.DNS \
	    | awk 'BEGIN{OFS=":";typ="HOST"}$1~/-gw.near.net/{typ="GATEWAY";prot="IP/GW,"}$4=="CNAME"{cname=cname "," $1}$4=="A"{if (addr=="")addr=$5;else addr=addr "," $5;name=$1;}$4=="HINFO"{hw=$5;sw=$6}END{if (hw=="")hw="cisco";if (sw=="")sw="cisco";print typ, addr, name cname, hw, sw, prot "UDP/SNMP,TCP/TELNET:"}' \
			>> Hosts.NEAR.new
	echo "Done."
end



## #  #   #    #     #      #       #      #     #    #   #  # ##
#
echo		"Conversion complete, check results..."
#
## #  #   #    #     #      #       #      #     #    #   #  # ##


# See if anything changed (other than the date :-)
/usr/ucb/tail +3 Hosts.NEAR | tr a-z A-Z >/tmp/foo$$
/usr/ucb/tail +3 Hosts.NEAR.new | tr a-z A-Z >/tmp/bar$$
if ( { /bin/cmp -s /tmp/foo$$ /tmp/bar$$ } ) then
	/bin/echo "New Hosts.NEAR same as before, just leaving the old one."
	/bin/rm -f /tmp/foo$$ /tmp/bar$$ Hosts.NEAR.new
	exit 0
endif
/bin/rm -f /tmp/foo$$ /tmp/bar$$


# Make an overall check that we haven't lost too much data
if ( `/bin/ls -s Hosts.NEAR|/bin/awk '{print $1}'` > `/bin/ls -s Hosts.NEAR.new|/bin/awk '{printf "%d\n", $1*1.2}'` ) then
	/bin/echo "New Hosts.NEAR file too small" 
	/bin/ls -lag
	/bin/ls -lag|/usr/ucb/mail -s "Hosts.NEAR too small in MINTAKA:/projects/Network/release" MAP=Status
	exit 1
endif



## #  #   #    #     #      #       #      #     #    #   #  # ##
#
echo		"OK, so now install it."
#
## #  #   #    #     #      #       #      #     #    #   #  # ##


diff -wi Hosts.NEAR{,.new}|/usr/ucb/mail -s "Update to Hosts.NEAR on MINTAKA:/projects/Network/release" MAP=Status
/bin/rm -f Hosts.NEAR.old
/bin/ln Hosts.NEAR Hosts.NEAR.old
/bin/mv Hosts.NEAR.new Hosts.NEAR
