/*
      aclTarget	     	Party,
      aclSubject	Party,
      aclPriveleges	INTEGER,
      aclStatus		INTEGER
 */

#define ACLTARGET	1
#define ACLSUBJECT	2
#define ACLPRIVELEGES	3
#define ACLSTATUS	4

#define ACLNONEXISTENT 	0
#define ACLVALID		1
#define ACLINVALID		2

#define ACLPRIVELEGESGET		1
#define ACLPRIVELEGESGETNEXT		2
#define ACLPRIVELEGESGETRESPONSE	4
#define ACLPRIVELEGESSET		8
#define ACLPRIVELEGESTRAP		16
#define ACLPRIVELEGESBULK		32
#define ACLPRIVELEGESINFORM		64
#define ACLPRIVELEGESTRAP2		128

struct aclEntry {
    oid		aclTarget[32];
    int		aclTargetLen;
    oid		aclSubject[32];
    int		aclSubjectLen;
    int		aclPriveleges;
    int		aclStatus;
    
    u_long	aclBitMask;

    struct aclEntry *reserved;
    struct aclEntry *next;
};

u_char *var_acl();
int write_acl();

struct aclEntry *
acl_getEntry(/* oid *target, int targetLen, oid *subject, int subjectLen*/);
/*
 * Returns a pointer to the aclEntry with the
 * same target and subject.
 * Returns NULL if that entry does not exist.
 */

acl_scanInit();
/*
 * Initialized the scan routines so that they will begin at the
 * beginning of the list of aclEntries.
 *
 */


struct aclEntry *
acl_scanNext();
/*
 * Returns a pointer to the next aclEntry.
 * These entries are returned in no particular order,
 * but if N entries exist, N calls to acl_scanNext() will
 * return all N entries once.
 * Returns NULL if all entries have been returned.
 * acl_scanInit() starts the scan over.
 */

struct aclEntry *
acl_createEntry(/* oid *target, int targetLen, oid subject, int subjectLen */);
/*
 * Creates a aclEntry with the given index
 * and returns a pointer to it.
 * The status of this entry is created as invalid.
 */


