/* 1200, Fri 23 Oct 92

   NM.C:  First attempt at a manager for the AU Accounting Meter

   Copyright (C) 1992 by Nevil Brownlee,
   Computer Centre,  University of Auckland */

/***********************************************************
	Copyright 1988 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
#include <sys/param.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>

#include <stdio.h>
#include <ctype.h>
#include <sys/time.h>
#include <errno.h>

#include <string.h>
#include <malloc.h>

#include "snmp.h"
#include "snmpimpl.h"
#include "asn1.h"
#include "snmpclnt.h"
#include "snmpapi.h"
#include "mib.h"

#ifndef BSD4_3
#define BSD4_2
#endif

#define FLOWLIMIT  6000
#define RULEFILE "rules.txt"

extern int  errno;
int	snmp_dump_packet = 0;

#define  INT_ACCT  1, 3, 6, 1, 3, 99
#define  AUKUNI    1, 3, 6, 1, 4, 1, 411

oid o_sysDescr[]          = {MIB, 1, 1, 0};
oid o_sysUpTime[]	  = {MIB, 1, 3, 0};
oid o_ifNumber[]	  = {MIB, 2, 1, 0};

#define	FT_INDEX  (sizeof(o_ftFlowNbr)/sizeof(oid) - 1)

oid o_ftFlowNbr[]         = {INT_ACCT, 3, 1, 1, 0xFFFF};
oid o_ftFlowStatus[]      = {INT_ACCT, 3, 1, 2, 0xFFFF};
oid o_ftNextActiveFlow[]  = {INT_ACCT, 3, 1, 3, 0xFFFF};
oid o_ftAddrType[]        = {INT_ACCT, 3, 1, 4, 0xFFFF};
oid o_ftFromAddr[]        = {INT_ACCT, 3, 1, 5, 0xFFFF};
oid o_ftFromMask[]        = {INT_ACCT, 3, 1, 6, 0xFFFF};
oid o_ftFromTally[]       = {INT_ACCT, 3, 1, 7, 0xFFFF};
oid o_ftToAddr[]          = {INT_ACCT, 3, 1, 8, 0xFFFF};
oid o_ftToMask[]          = {INT_ACCT, 3, 1, 9, 0xFFFF};
oid o_ftToTally[]         = {INT_ACCT, 3, 1,10, 0xFFFF};
oid o_ftFwdPackets[]      = {INT_ACCT, 3, 1,11, 0xFFFF};
oid o_ftFwdBytes[]        = {INT_ACCT, 3, 1,12, 0xFFFF};
oid o_ftBackPackets[]     = {INT_ACCT, 3, 1,13, 0xFFFF};
oid o_ftBackBytes[]       = {INT_ACCT, 3, 1,14, 0xFFFF};
oid o_ftChkFwdPackets[]   = {INT_ACCT, 3, 1,15, 0xFFFF};
oid o_ftChkFwdBytes[]     = {INT_ACCT, 3, 1,16, 0xFFFF};
oid o_ftChkBackPackets[]  = {INT_ACCT, 3, 1,17, 0xFFFF};
oid o_ftChkBackBytes[]    = {INT_ACCT, 3, 1,18, 0xFFFF};
oid o_ftFlowBlob[]        = {INT_ACCT, 3, 1,19, 0xFFFF};
oid o_ftFlowCount[]       = {INT_ACCT, 3, 2, 0};
oid o_ftChkTime[]         = {INT_ACCT, 3, 3, 0};
oid o_ftChkFlowCount[]    = {INT_ACCT, 3, 4, 0};
oid o_ftPrevChkTime[]     = {INT_ACCT, 3, 5, 0};
oid o_ftChkActFlows[]     = {INT_ACCT, 3, 6, 0};
oid o_ftFirstActFlow[]    = {INT_ACCT, 3, 7, 0};
oid o_ftCheckPoint[]      = {INT_ACCT, 3, 8, 0};

#define	RT_INDEX  (sizeof(o_rtIndex)/sizeof(oid) - 1)

oid o_rtIndex[]           = {INT_ACCT, 4, 1, 1, 0xFFFF};
oid o_rtTreeNbr[]         = {INT_ACCT, 4, 1, 2, 0xFFFF};
oid o_rtAddrType[]        = {INT_ACCT, 4, 1, 3, 0xFFFF};
oid o_rtFromAddr[]        = {INT_ACCT, 4, 1, 4, 0xFFFF};
oid o_rtFromMask[]        = {INT_ACCT, 4, 1, 5, 0xFFFF};
oid o_rtFromTally[]       = {INT_ACCT, 4, 1, 6, 0xFFFF};
oid o_rtToAddr[]          = {INT_ACCT, 4, 1, 7, 0xFFFF};
oid o_rtToMask[]          = {INT_ACCT, 4, 1, 8, 0xFFFF};
oid o_rtToTally[]         = {INT_ACCT, 4, 1, 9, 0xFFFF};

oid o_crRuleCount[]       = {INT_ACCT, 4, 2, 0};
oid o_crTreeNbr[]         = {INT_ACCT, 4, 3, 0};
oid o_crAddrType[]        = {INT_ACCT, 4, 4, 0};
oid o_crFromAddr[]        = {INT_ACCT, 4, 5, 0};
oid o_crFromMask[]        = {INT_ACCT, 4, 6, 0};
oid o_crFromTally[]       = {INT_ACCT, 4, 7, 0};
oid o_crToAddr[]          = {INT_ACCT, 4, 8, 0};
oid o_crToMask[]          = {INT_ACCT, 4, 9, 0};
oid o_crToTally[]         = {INT_ACCT, 4,10, 0};

#define	PT_INDEX  (sizeof(o_ptPacketType) - 1)

oid o_ptpacket_types[]    = {AUKUNI, 1, 1, 0};
oid o_ptPacketType[]      = {AUKUNI, 1, 2, 1, 1, 0xFF};
oid o_ptPacketCount[]     = {AUKUNI, 1, 2, 1, 2, 0xFF};
oid o_ptByteCount[]       = {AUKUNI, 1, 2, 1, 3, 0xFF};

oid o_pcNearMem[]         = {AUKUNI, 2, 1, 0};
oid o_pcFarMem[]          = {AUKUNI, 2, 2, 0};
oid o_pcBadPackets[]      = {AUKUNI, 2, 3, 0};
oid o_pcNoBufPackets[]    = {AUKUNI, 2, 4, 0};
oid o_pcLostPackets[]     = {AUKUNI, 2, 5, 0};
oid o_pcPacketBacklog[]   = {AUKUNI, 2, 6, 0};
oid o_pcChkSearches[]     = {AUKUNI, 2, 7, 0};
oid o_pcChkCompares[]     = {AUKUNI, 2, 8, 0};


#define ADDR_LEN  4

struct flow_info {
   unsigned char AddrType,
      FromAddr[ADDR_LEN], FromMask[ADDR_LEN], FromTally[ADDR_LEN],
      ToAddr[ADDR_LEN], ToMask[ADDR_LEN], ToTally[ADDR_LEN];
   unsigned long
      FwdPackets,FwdBytes,  BackPackets,BackBytes;
   unsigned short NextActiveFlow;
   };

struct rule_info {
   int RuleNbr;
   unsigned char TreeNbr, AddrType,
      FromAddr[ADDR_LEN], FromMask[ADDR_LEN], FromTally[ADDR_LEN],
      ToAddr[ADDR_LEN], ToMask[ADDR_LEN], ToTally[ADDR_LEN];
   };

#define AT_IGNORE     0  /* Addr_type values */
#define AT_IP         1
#define AT_NOVELL     2
#define AT_DECNET     3
#define AT_ETHERTALK  4

#define NAME_LN  64

struct meter_status {
   struct meter_status *next;

   char name[NAME_LN];
   char community[NAME_LN];
   char rulefile[NAME_LN];

   struct snmp_session *ss;

   short status;

   char descr[NAME_LN];  /* From meter_info() */
   long uptime;
   short ifcount;

   unsigned short flowcount;  /* Current nbr of flows */
   unsigned short rulecount;  /*    and rules */

   unsigned short flowsknown;  /* Nbr of flows we have key data for */

   unsigned short CheckPoint;
   unsigned short ChkFlowCount;
   unsigned short ChkActFlows;
   unsigned short FirstActFlow;
   long ChkTime;
   long PrevChkTime;

   FILE *keys;
   FILE *flows;
   FILE *log;
   };

struct meter_status *first_meter;

/* Values for status */

#define	MT_MANAGE    0x0001  /* Manage this meter */
#define	MT_INFO	     0x0002  /* Have basic info */
#define	MT_UP	     0x0004  /* Meter is running */
#define	MT_REPORTED  0x0008  /* Current status reported */

#ifdef MTR_LIST
/* #define  CTLFILE  "/usr/local/src/snmp/manager.cfg" */
#define  CTLFILE  "manager.cfg"
#endif

unsigned short getshort(unsigned char *ucp);
unsigned long getlong(unsigned char *ucp);

void init_meter();
void monitor_meter();
void monitor(struct meter_status *ms);
void print_meters();
void meter_print(struct meter_status *ms);

void printaddress(FILE *f,unsigned char *a);
void getaddress(unsigned char *a);

void parse_rulefile(struct meter_status *ms, int list);
int add_rule(struct meter_status *ms, struct rule_info *ri);

int chk_info(struct meter_status *ms, int control);

int blob_info(struct meter_status *ms, unsigned char *fb, int fn);
int flow_info(struct meter_status *ms, struct flow_info *fi,
   int fn, int getkey, int getflow);

char *uptime_string(unsigned long timeticks, char *buf);

int verbose;

void main(argc,argv)
int argc;
char *argv[];
{
   struct meter_status *ms;
   struct snmp_session session, *ssp;

   int arg;
   char meter[NAME_LN], community[NAME_LN], rfname[NAME_LN],
      filename[NAME_LN*2];
   int interval = 0;

   meter[0] = community[0] = rfname[0] = NULL;

#ifdef MTR_LIST
   parse_ctlfile();
#endif

   init_mib();

   /*  usage: nm meter-name community */

   for (arg = 1; arg < argc; arg++) {
      if (argv[arg][0] == '-') {
	 switch (argv[arg][1]) {
	 case 'd':
	    snmp_dump_packet++;
	    break;
	 case 'c':
	    if ((interval = atoi(argv[arg]+2)) == 0) interval = 120;
	    break;
	 case 'r':
	    strcpy(rfname, argv[++arg]);
	    break;
	 case 'v':
	    verbose++;
	    break;
	 default:
	    printf("Invalid option: -%c\n", argv[arg][1]);
	    break;
	    }
	 continue;
	 }
      if (meter[0] == NULL) strcpy(meter,argv[arg]);
      else if (community[0] == NULL) strcpy(community,argv[arg]);
      }

   if (meter[0] == NULL) {
      printf("nm meter-name community\n\n");
      exit(0);
      }

   ms = (struct meter_status *)calloc(sizeof(struct meter_status), 1);
   strcpy(ms->name,meter);
   strcpy(ms->community,community);
   if (*rfname) strcpy(ms->rulefile, rfname);
   else strcpy(ms->rulefile, RULEFILE);

   strcpy(filename,meter);
   strcat(filename,".log");
   if ((ms->log = fopen(filename,"wa")) == NULL) {
      printf("Failed to open %s\n",filename);
      exit(0);
      }
   strcpy(filename,meter);
   strcat(filename,".keys");
   if ((ms->keys = fopen(filename,"wa")) == NULL) {
      printf("Failed to open %s\n",filename);
      exit(0);
      }
   strcpy(filename,meter);
   strcat(filename,".flows");
   if ((ms->flows = fopen(filename,"wa")) == NULL) {
      printf("Failed to open %s\n",filename);
      exit(0);
      }

   bzero((char *)&session, sizeof(struct snmp_session));
   session.peername = ms->name;
   session.community = ms->community;
   session.community_len = strlen(ms->community);
   session.retries = SNMP_DEFAULT_RETRIES;
   session.timeout = SNMP_DEFAULT_TIMEOUT;
   session.authenticator = NULL;
   snmp_synch_setup(&session);
   ssp = snmp_open(&session);
   if (ssp == NULL) {
      printf("Couldn't open snmp to %s\n", session.peername);
      exit(-1);
      }
   ms->ss = ssp;

   ms->status = MT_MANAGE;
   first_meter = ms;  /* $$$$$$$ */

#ifdef MTR_LIST
   if (!explicit) add_all_meters();
#endif

   init_meter();

   if (!interval) {
      print_meters();
      exit (0);
      }

   parse_rulefile(ms,TRUE);  /* Download the rules we want to use */

   for (;;) {
      sleep(interval);

      monitor_meter();
      if (verbose) print_meters();
      }
   }

#ifdef MTR_LIST
void parse_ctlfile()
{
   struct meter_status *ms, *mp;
   FILE *fp;
   char linebuffer[256];
   char label[128];
   char community[128];
   int n;

   if ((fp = fopen(CTLFILE, "r")) == NULL) {
      perror(CTLFILE);
      exit(1);
      }

   while (fgets(linebuffer, sizeof(linebuffer), fp) != NULL) {
      if (linebuffer[0] < '0' || linebuffer[0] > 'z') continue;
      n = sscanf(linebuffer, "%s %s", label, community);
      if (n < 1) continue;
      ms = (struct meter_status *)calloc(sizeof(struct meter_status), 1);
      ms->name = savestr(label);
      ms->community = n > 1 ? savestr(community) : savestr("public");
      ms->next = NULL;

      if ((mp = first_meter) == NULL) first_meter = ms;
      else {
	 while (mp->next) mp = mp->next;
	 mp->next = ms;
	 }
      }
   }

void add_all_meters()
{
   struct meter_status *ms;
   for (ms = first_meter; ms != NULL; ms = ms->next)
      ms->status = MT_MANAGE;
   }

void add_meter(name)
char *name;
{
   struct meter_status *ms;

   for (ms = first_meter; ms != NULL; ms = ms->next) {
      if (strcasecmp(name,ms->name) == 0) break;
      }

   if (ms == NULL) {
      struct hostent *hp;
      u_long addr;

      if ((addr = (u_long)inet_addr(name)) == (u_long)-1) {
	 hp = gethostbyname(name);
	 if (hp != NULL) {
	    for (ms = first_meter; ms != NULL; ms = ms->next) {
#ifdef h_addr
	       char **ap;
#endif
	       if (strcasecmp(hp->h_name, ms->name) == 0) break;
#ifdef h_addr
	       if (hp->h_addr_list == NULL) continue;

	       for (ap = hp->h_addr_list; *ap; ap++) {
		  if (addr == *(u_long *)(*ap)) break;
		  }
	       if (*ap) break;
#else
	       if (addr == *(u_long *)(hp->h_addr)) break;
#endif
					
	       }
	    if (ms == NULL) {
	       printf("No config info for %s\n", name);
	       return;
	       }
	    }
         else {
	    printf("No config info for %s\n", name);
	    return;
	    }
	 }
      }

   ms->status = MT_MANAGE;
   }
#endif

void init_meter()
{
   struct meter_status *ms;
   int haveone = 0;

   for (ms = first_meter; ms; ms = ms->next) {
      if (!(ms->status & MT_MANAGE)) continue;
      haveone++;
      if (meter_info(ms)) {
         ms->status |= (MT_UP | MT_INFO);
         meter_print(ms);
         }
      }

   if (!haveone) {
      printf("No meters to monitor\n");
      exit(5);
      }
   }


void monitor_meter()
{
   struct meter_status *ms;
   for (ms = first_meter; ms; ms = ms->next)
      if (ms->status & MT_MANAGE) monitor(ms);
   }

/* CAUTION:  Following struct doesn't work because of alignment on 32-bit words
 *
 * struct active_flow_data {  
 *    unsigned short flow_nbr;
 *    unsigned long fwd_bytes, back_bytes;
 *    }; 
 */

#define flow_nbr_x    0
#define fwd_bytes_x   (flow_nbr_x + sizeof(unsigned short))
#define back_bytes_x  (fwd_bytes_x + sizeof(unsigned long))
#define flow_data_sz  (back_bytes_x + sizeof(unsigned long))

#define FLOWBLOBSZ  25

unsigned short getshort(ucp)
unsigned char *ucp;
{
   return ucp[0]<<8 | ucp[1];
   }

unsigned long getlong(ucp)
unsigned char *ucp;
{
   return ucp[0]<<24 | ucp[1]<<16 | ucp[2]<<8 | ucp[3];
   }

void monitor(ms)  /* Called every interval for each meter */
struct meter_status *ms;
{
   time_t t;
   char *ts;
   unsigned short fn, nactive, n;
   struct flow_info fi;
   unsigned char flowblob[FLOWBLOBSZ*flow_data_sz], *afdp;
   unsigned long fwd_bytes, back_bytes;

   time(&t);  ts = ctime(&t);
   if (!(ms->status & MT_INFO)) {  /* No info */
      if (meter_info(ms))  /* Got some */
	 ms->status |= (MT_UP | MT_INFO);
      return;
      }
   if (meter_info(ms) == 0) {  /* Lost contact */
      if (ms->status & MT_UP) {  /* Was up */
	 fprintf(ms->log,"%19.19s -- %s: No response\n", ts,ms->name);
	 if (verbose) printf("%19.19s -- %s: No response\n", ts,ms->name);
	 }
      ms->status &= ~MT_UP;  /* Mark as 'down' */
      return;
      }
   if (!(ms->status & MT_UP)) {  /* Have contact now, was down */
      fprintf(ms->log,"%19.19s -- %s: Regained contact\n", ts,ms->name);
      if (verbose) printf("%19.19s -- %s: Regained contact\n", ts,ms->name);
      }
   ms->status |= MT_UP;

   /* Meter processing .. */

   if (!chk_info(ms,1)) {
      printf("%19.19s -- %s: Failed to get chk info\n", ts,ms->name);
      return;
       }
   else {
      if (verbose) printf(
	 "%19.19s -- %s: %u flows, %u active, %u first.  From %ld to %ld\n",
	    ts,ms->name,
	    ms->ChkFlowCount,ms->ChkActFlows,ms->FirstActFlow,
	    ms->PrevChkTime,ms->ChkTime);

      /* Get the keys and flows here .. */

      fprintf(ms->keys, 
         "## %19.19s %s: %u flows, %u active. Checkpoint %u, from %ld to %ld##\n",
         ts,ms->name, ms->ChkFlowCount,ms->ChkActFlows, 
         ms->CheckPoint, ms->PrevChkTime,ms->ChkTime);
      for (fn = ms->flowsknown+1; fn <= ms->ChkFlowCount; ++fn) {
         if (!flow_info(ms, &fi, fn, 1, 0)) {
            printf(ms->log,"   Failed to get key for flow %d\n", fn);
            printf("Failed to get key for flow %d\n", fn);
            }
         else {
            fprintf(ms->keys, "%u %u", fn, fi.AddrType);
            printaddress(ms->keys, fi.FromAddr);
            printaddress(ms->keys, fi.ToAddr);
            fprintf(ms->keys,"\n");
	    }
         }
      ms->flowsknown = ms->ChkFlowCount;
      fflush(ms->keys);

      fprintf(ms->flows, 
         "## %19.19s %s: %u flows, %u active. Checkpoint %u, from %ld to %ld##\n",
         ts,ms->name, ms->ChkFlowCount,ms->ChkActFlows, 
         ms->CheckPoint, ms->PrevChkTime,ms->ChkTime);
      fn = ms->FirstActFlow;  nactive = ms->ChkActFlows;  
      while (nactive != 0) {
         if (!blob_info(ms,flowblob, fn)) {
            printf(ms->log,"   Failed to get flow for flow %d\n", fn);
            printf("Failed to get flow for flow %d\n", fn);
            }
         else {
            for (n = 0, afdp = flowblob;  nactive != 0 && n != FLOWBLOBSZ; 
                  --nactive, ++n, afdp += flow_data_sz) {
               fprintf(ms->flows,"%u %lu %lu\n",
                  fn = ntohs(getshort(afdp + flow_nbr_x)),
                  ntohl(getlong(afdp + fwd_bytes_x)),
                  ntohl(getlong(afdp + back_bytes_x)) );
	       }
            }
         ++fn;
	 }
      fflush(ms->flows);

      if (ms->flowsknown > FLOWLIMIT) chk_info(ms,-1);  /* Restart meter */
      }

   fflush(ms->log);  
   }

#define ADD_VAR(v)        snmp_add_null_var(pdu, v, sizeof(v)/sizeof(oid))
#define ADD_X_VAR(v,x,n)  { v[x] = n;  ADD_VAR(v); }

#define STRING_VAL(v)     bcopy(vars->val.string, v, vars->val_len)
#define INT_VAL(v)        v = *(vars->val.integer)

#define SET_INT(v)        { vars->type = INTEGER;\
	 vars->val.integer = (long *)malloc(vars->val_len = sizeof(long));\
	 *(vars->val.integer) = (long)v; }
#define SET_STRING(v)     { vars->type = STRING;\
	 vars->val.string = (u_char *)malloc(ADDR_LEN);\
	 bcopy(v, (char *)vars->val.string, vars->val_len = ADDR_LEN); }

int add_rule(ms,ri)
struct meter_status *ms;
struct rule_info *ri;
{
   int i, count, status;
   struct snmp_pdu *pdu, *response;
   struct variable_list *vars;

   pdu = snmp_pdu_create(SET_REQ_MSG);
   if (ri->RuleNbr == 0) {
      ADD_VAR(o_crRuleCount);  /* Clear rule table */
         vars = pdu->variables;
         SET_INT(ri->RuleNbr);
      }
   else {
      ADD_VAR(o_crTreeNbr);
         vars = pdu->variables;
         SET_INT(ri->TreeNbr);
      ADD_VAR(o_crAddrType);
         vars = vars->next_variable;
         SET_INT(ri->AddrType);
      ADD_VAR(o_crFromAddr);
         vars = vars->next_variable;
         SET_STRING(ri->FromAddr);
      ADD_VAR(o_crFromMask);
         vars = vars->next_variable;
         SET_STRING(ri->FromMask);
      ADD_VAR(o_crFromTally);
         vars = vars->next_variable;
         SET_STRING(ri->FromTally);
      ADD_VAR(o_crToAddr);
         vars = vars->next_variable;
         SET_STRING(ri->ToAddr);
      ADD_VAR(o_crToMask);
         vars = vars->next_variable;
         SET_STRING(ri->ToMask);
      ADD_VAR(o_crToTally);
         vars = vars->next_variable;
         SET_STRING(ri->ToTally);
      ADD_VAR(o_crRuleCount);  /* Add current rule to rule table */
         vars = vars->next_variable;
         SET_INT(ri->RuleNbr);
      }

   status = snmp_synch_response(ms->ss, pdu, &response);
   if (status == STAT_SUCCESS) {
      if (response->errstat == SNMP_ERR_NOERROR) {
         if (ri->RuleNbr == 0) printf("Rule table cleared\n");
         else printf("Rule %d added to table\n", ri->RuleNbr);
         ms->rulecount = ri->RuleNbr;
	 }
      else {
	 printf("Error in packet\nReason: %sn",
	    snmp_errstring(response->errstat));
	 if (response->errstat == SNMP_ERR_NOSUCHNAME) {
	    printf("This name does not exist: ");
	    for (count=1, vars = response->variables;
	       vars && count != response->errindex;
		  vars = vars->next_variable, count++) ;
	    if (vars) print_objid(vars->name, vars->name_length);
	    printf("\n");
	    }
	 }
      }
   else return 0;
   snmp_free_pdu(response);
   return 1;
   }

int chk_info(ms,control)
struct meter_status *ms;
int control;  /* 0 = read, -1 = restart, 1 = checkpoint */
{
   int i, count, status;
   struct snmp_pdu *pdu, *response;
   struct variable_list *vars;

   if (control == -1) {
      ms->CheckPoint = ms->flowsknown = 0;
      }
   else if (control == 1) ++ms->CheckPoint;

   if (control != 0) {  /* Make new checkpoint */
      pdu = snmp_pdu_create(SET_REQ_MSG);
      ADD_VAR(o_ftCheckPoint);
      vars = pdu->variables;
      SET_INT(ms->CheckPoint);  /* New checkpoint number */
      status = snmp_synch_response(ms->ss, pdu, &response);
      if (status == STAT_SUCCESS) {
	 if (response->errstat == SNMP_ERR_NOERROR) {
	    vars = response->variables;
	    INT_VAL(ms->CheckPoint);
	    }
	 else {
	    printf("Error in packet\nReason: %sn",
	       snmp_errstring(response->errstat));
	    if (response->errstat == SNMP_ERR_NOSUCHNAME) {
	       printf("This name does not exist: ");
	       for (count=1, vars = response->variables;
		  vars && count != response->errindex;
		     vars = vars->next_variable, count++) ;
	       if (vars) print_objid(vars->name, vars->name_length);
	       printf("\n");
	       }
	    }
	 }
      else return 0;
      snmp_free_pdu(response);
      }

   pdu = snmp_pdu_create(GET_REQ_MSG);
   ADD_VAR(o_ftChkFlowCount);
   ADD_VAR(o_ftChkActFlows);
   ADD_VAR(o_ftFirstActFlow);
   ADD_VAR(o_ftChkTime);
   ADD_VAR(o_ftPrevChkTime);
   status = snmp_synch_response(ms->ss, pdu, &response);
   if (status == STAT_SUCCESS) {
      if (response->errstat == SNMP_ERR_NOERROR) {
	 vars = response->variables;
	 INT_VAL(ms->ChkFlowCount);
	 vars = vars->next_variable;
	 INT_VAL(ms->ChkActFlows);
	 vars = vars->next_variable;
	 INT_VAL(ms->FirstActFlow);
	 vars = vars->next_variable;
	 INT_VAL(ms->ChkTime);
	 vars = vars->next_variable;
	 INT_VAL(ms->PrevChkTime);
	 }
      else {
	 printf("Error in packet\nReason: %sn",
	    snmp_errstring(response->errstat));
	 if (response->errstat == SNMP_ERR_NOSUCHNAME) {
	    printf("This name does not exist: ");
	    for (count=1, vars = response->variables;
	       vars && count != response->errindex;
		  vars = vars->next_variable, count++) ;
	    if (vars) print_objid(vars->name, vars->name_length);
	    printf("\n");
	    }
	 }
      }
   else return 0;
   snmp_free_pdu(response);
   return 1;
   }

int blob_info(ms,fb, fn)
struct meter_status *ms;
unsigned char *fb;
int fn;
{
   int i, count, status;
   struct snmp_pdu *pdu, *response;
   struct variable_list *vars;

   pdu = snmp_pdu_create(GET_REQ_MSG);
   ADD_X_VAR(o_ftFlowBlob,FT_INDEX,fn);
   status = snmp_synch_response(ms->ss, pdu, &response);
   if (status == STAT_SUCCESS) {
      if (response->errstat == SNMP_ERR_NOERROR) {
	 vars = response->variables;
	 STRING_VAL(fb);
	 }
      else {
	 printf("Error in packet\nReason: %sn",
	    snmp_errstring(response->errstat));
	 if (response->errstat == SNMP_ERR_NOSUCHNAME) {
	    printf("This name does not exist: ");
	    for (count=1, vars = response->variables;
	       vars && count != response->errindex;
		  vars = vars->next_variable, count++) ;
	    if (vars) print_objid(vars->name, vars->name_length);
	    printf("\n");
	    }
	 }
      }
   else return 0;
   snmp_free_pdu(response);
   return 1;
   }

int flow_info(ms,fi, fn, getkey,getflow)
struct meter_status *ms;
struct flow_info *fi;
int fn, getkey,getflow;
{
   int i, count, status;
   struct snmp_pdu *pdu, *response;
   struct variable_list *vars;

   pdu = snmp_pdu_create(GET_REQ_MSG);
   if (getkey) {
      ADD_X_VAR(o_ftAddrType,FT_INDEX,fn);
      ADD_X_VAR(o_ftFromAddr,FT_INDEX,fn);
      ADD_X_VAR(o_ftToAddr,FT_INDEX,fn);
      }
   if (getflow) {
      ADD_X_VAR(o_ftChkFwdBytes,FT_INDEX,fn);
      ADD_X_VAR(o_ftChkBackBytes,FT_INDEX,fn);
      ADD_X_VAR(o_ftNextActiveFlow,FT_INDEX,fn);
      }
   status = snmp_synch_response(ms->ss, pdu, &response);
   if (status == STAT_SUCCESS) {
      if (response->errstat == SNMP_ERR_NOERROR) {
	 vars = response->variables;
	 if (getkey) {
	    INT_VAL(fi->AddrType);
	    vars = vars->next_variable;
	    STRING_VAL(fi->FromAddr);
	    vars = vars->next_variable;
	    STRING_VAL(fi->ToAddr);
	    vars = vars->next_variable;
	    }
	 if (getflow) {
	    INT_VAL(fi->FwdBytes);
	    vars = vars->next_variable;
	    INT_VAL(fi->BackBytes);
	    vars = vars->next_variable;
	    INT_VAL(fi->NextActiveFlow);
	    }
	 }
      else {
	 printf("Error in packet\nReason: %sn",
	    snmp_errstring(response->errstat));
	 if (response->errstat == SNMP_ERR_NOSUCHNAME) {
	    printf("This name does not exist: ");
	    for (count=1, vars = response->variables;
	       vars && count != response->errindex;
		  vars = vars->next_variable, count++) ;
	    if (vars) print_objid(vars->name, vars->name_length);
	    printf("\n");
	    }
	 }
      }
   else return 0;
   snmp_free_pdu(response);
   return 1;
   }

int meter_info(ms)
struct meter_status *ms;
{
   int i, count, status;
   struct snmp_pdu *pdu, *response;
   struct variable_list *vars;

   pdu = snmp_pdu_create(GET_REQ_MSG);
   ADD_VAR(o_sysDescr);
   ADD_VAR(o_sysUpTime);
   ADD_VAR(o_ifNumber);
   ADD_VAR(o_ftFlowCount);
   status = snmp_synch_response(ms->ss, pdu, &response);
   if (status == STAT_SUCCESS) {
      if (response->errstat == SNMP_ERR_NOERROR) {
	 vars = response->variables;
	 STRING_VAL(ms->descr);
         vars = vars->next_variable;
	 INT_VAL(ms->uptime);
         vars = vars->next_variable;
	 INT_VAL(ms->ifcount);
         vars = vars->next_variable;
	 INT_VAL(ms->flowcount);
	 }
      else {
	 printf("Error in packet\nReason: %sn",
	    snmp_errstring(response->errstat));
	 if (response->errstat == SNMP_ERR_NOSUCHNAME) {
	    printf("This name does not exist: ");
	    for (count=1, vars = response->variables;
	       vars && count != response->errindex;
		  vars = vars->next_variable, count++) ;
	    if (vars) print_objid(vars->name, vars->name_length);
	    printf("\n");
	    }
	 }
      }
   else return 0;
   snmp_free_pdu(response);
   return 1;
   }

void print_meters()
{
   struct meter_status *ms;
   for (ms = first_meter; ms; ms = ms->next)
      if (ms->status & MT_MANAGE) meter_print(ms);
   }

void meter_print(ms)
struct meter_status *ms;
{
   struct timeval tv;
   char buf[32];
   time_t t;   char *ts;

   time(&t);  ts = ctime(&t);

   gettimeofday(&tv, (struct timezone *)0);
   tv.tv_sec -= ms->uptime / 100;
   if ((ms->uptime % 100)*10000 > tv.tv_usec) {
      tv.tv_sec--;
      tv.tv_usec += 1000000;
      }
   tv.tv_usec -= (ms->uptime % 100)*10000;

   fprintf(ms->log,
      "%19.19s -- %s: %s\n\tUp %s (since %.24s)\n\t\t%d interfaces, %u flows\n\n",
	 ts,ms->name, ms->descr, uptime_string(ms->uptime, buf),
	 ctime(&tv.tv_sec), ms->ifcount, ms->flowcount);
   if (verbose) printf(
      "%19.19s -- %s: %s\n\tUp %s (since %.24s)\n\t\t%d interfaces, %u flows\n\n",
	 ts,ms->name, ms->descr, uptime_string(ms->uptime, buf),
	 ctime(&tv.tv_sec), ms->ifcount, ms->flowcount);
   }


char *uptime_string(timeticks, buf)
unsigned long timeticks;
char *buf;
{
   int	seconds, minutes, hours, days;

   timeticks /= 100;
   days = timeticks / (60 * 60 * 24);
   timeticks %= (60 * 60 * 24);

   hours = timeticks / (60 * 60);
   timeticks %= (60 * 60);

   minutes = timeticks / 60;
   seconds = timeticks % 60;

   if (days == 0){
      sprintf(buf, "%d:%02d:%02d", hours, minutes, seconds);
      }
   else if (days == 1) {
      sprintf(buf, "%d day, %d:%02d:%02d",
	 days, hours, minutes, seconds);
      }
   else {
      sprintf(buf, "%d days, %d:%02d:%02d",
	 days, hours, minutes, seconds);
      }
   return buf;
   }

void printaddress(f,a)
FILE *f;
unsigned char *a;
{
   int j;
   fprintf(f," %u", a[0]);
   for (j = 1; j != ADDR_LEN; ++j) fprintf(f,".%u", a[j]);
   }


FILE *rfp;  /* For rules file */
char inbuf[256], *ibp;
int lic, ic, iblisted, rule_line;

int nextchar()
{
   lic = ic;
   for (;;) {
      if (lic == '\n') {
	 if (fgets(inbuf, sizeof(inbuf), rfp) == NULL) return ic = EOF;
	 iblisted = 0;  ++rule_line;
	 ibp = inbuf;
	 }
      ic = *ibp++;
      if (ic == '#') lic = '\n';  /* Ignore comments */
      else return ic;
      }
   }

int getnbr()
{
   int v = 0;
   for (;;) {
      if (ic == EOF) return EOF;
      if (isdigit(ic)) break;
      else nextchar(rfp);
      }
   for (;;) {
      v = v*10 + ic-'0';
      if (nextchar(ic) == EOF) return EOF;
      if (!isdigit(ic)) break;
      }
   if (v > 255) {
      if (!iblisted) {
	 printf("RULEFILE line %d: %s\n", rule_line,inbuf);
	 iblisted = 1;
	 }
      printf("Number > 255 !!!\n");
      }
   return v;
   }

void getaddress(a)
unsigned char *a;
{
   int j;
   for (j = 0; j != ADDR_LEN; ++j) a[j] = getnbr();
   }

void parse_rulefile(ms,list)
struct meter_status *ms;
int list;
{
   struct rule_info ri;
   int c, rule_nbr = 0;

   if ((rfp = fopen(ms->rulefile, "r")) == NULL) {
      perror(ms->rulefile);
      exit(1);
      }

   ri.RuleNbr = 0;  add_rule(ms, &ri);  /* Clear rule table */
   
   ic = '\n';  rule_line = 0;
   for (;;) {
      do {  /* First char of a line */
	 nextchar(rfp);
	 if (ic == EOF) break;
	 } while (lic != '\n');
      if (ic == EOF) break;
      ri.TreeNbr = getnbr();
      if (ic == EOF) break;
      for (;;) {
	 if (ic == EOF) break;
	 if (isalpha(ic)) break;
	 else nextchar(rfp);
	 }
      c = toupper(ic);
      if (c == 'I') ri.AddrType = AT_IP;
      else if (c == 'N') ri.AddrType = AT_NOVELL;
      else if (c == 'D') ri.AddrType = AT_DECNET;
      else if (c == 'A') ri.AddrType = AT_ETHERTALK;
      else ri.AddrType = AT_IGNORE;

      getaddress(ri.FromAddr);
      if (ic == EOF) break;
      getaddress(ri.FromMask);
      if (ic == EOF) break;
      getaddress(ri.FromTally);
      if (ic == EOF) break;
      getaddress(ri.ToAddr);
      if (ic == EOF) break;
      getaddress(ri.ToMask);
      if (ic == EOF) break;
      getaddress(ri.ToTally);
      if (ic == EOF) break;

      ri.RuleNbr = ++rule_nbr;

      if (list) {
	 printf("Rule %d:  %d,  %d,", ri.RuleNbr, ri.TreeNbr, ri.AddrType);
	 printaddress(stdout, ri.FromAddr);
	 printaddress(stdout, ri.FromMask);
	 printaddress(stdout, ri.FromTally);
	 printf("\n               ");
	 printaddress(stdout, ri.ToAddr);
	 printaddress(stdout, ri.ToMask);
	 printaddress(stdout, ri.ToTally);
	 printf("\n");
	 }

      add_rule(ms,&ri);  /* Add rule to meter's rule table */
      }
   chk_info(ms,-1);  /* Restart with new rule table */
   fclose(rfp);
   }
