/* 1240, Tue 6 Sep 94

   FD_FILTER.C:  Performs tidy-up operations on NeTraMet Flow-data files
      * Compute flow rates [To/From ByteRate, To/From PduRate]
      * Change (NeTraMet) format for file
      * Filter out flows from file, tag those remaining [FlowTag]
      * FIlter out #Stats records

   Copyright (C) 1994 Nevil Brownlee & Russell Fulton,
   Computer Centre, The University of Auckland */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

/*
   filter fmt_file [ in_file [ > out_file ]]
*/

#define EXTERN
#include "fd_data.h"

struct tag_info {
   unsigned char  /* Attributes to test, null terminated */
      att_nbr[1+NATTRIBS];
   val att_p[1+NATTRIBS];  /* Pointers to attribute values */
   struct flow_info flow;  /* Attribute values */
   };

EXTERN struct tag_info *tags[MXTAGS];
EXTERN int ntags INIT(0);


struct tag_info *scan_tag(void)
{
   struct tag_info *t;
   unsigned int tn;
   int a, n;

   if ((t = (struct tag_info *)calloc(1, sizeof(struct tag_info))) == NULL) {
      fprintf(stderr,"Failed to allocate memory for tag info, exiting\n");
      exit(10);
      }

   tn = getnbr();  /* Get tag nbr */
   t->flow.TagNbr = tn;
   for (a = 0; ; ++a) {
      n = getnbr();  /* Get attribute */
      if (n < 0 || n > NATTRIBS) {
         sprintf(ebuf, "Attribute %d not allowed in tag %d",n,tn);
         p_error(ebuf);
         }
      else {
         t->att_nbr[a] = n;
         t->att_p[a] = attrib_ptr(&t->flow,n); 
         }

/* Note:  String attribue values (i.e. addresses) are held and compared
          as strings, so they have to appear in filter format files
          exactly as they do in flow data files */

      if (string_value(n))  /* Get attribute value */
         getfdstring(t->att_p[a].charval);
      else *t->att_p[a].intval = getnbr();
      for (;;) {  /* Find next attribute */
         if (ic == ';')  /* End of attrib list */
            return t;
         if (isalpha(ic)) break;
         else nextchar();
         }
      }
   }
 
struct flow_data {
   unsigned short ruleset;
   unsigned int flownum, starttime,
      upbc, dnbc, uppc, dnpc;  /* Counts from last sample */
   };
struct flow_data *flow;

int next_flow = 1, max_flows;
int stats_reqd = 0;

main(int argc, char **argv)
{
   char *pb, *p;
   int l = 0, n, a, b, i, fail;
   FILE *input, *output;
   int fi, ruleset=0, skip_first=1, first_sample=1, recno=0;
   struct flow_stats in_set, out_set;
   struct tag_info *tip;

   if (argc > 1) {
      if (!parse_open(argv[1])) {
         printf("   Couldn't open format file %s !!!\n", argv[1]);
         exit(1);
         }
      } 
   else { 
      fprintf(stderr, 
         "fd_filter format_file [ input_file [ > output_file ]]\n");
      exit(10);
      }

   listrules = 1;
   for (;;) {  /* Read the format file */
      do {  /* First char of a line */
	 nextchar();
	 if (ic == EOF) break;
	 } while (lic != '\n');
      if (ic == EOF) break;
      n = getnbr();  /* What kind of line is it? */
      if (n == RF_SET) {
         ruleset = getnbr();
         continue;
         }
      if (n == RF_FORMAT) {
         scan_format(&out_set,0,listrules);  /* Not single_record */
         continue;
	 }
      if (n == RF_TAG) {
         tags[ntags++] = scan_tag();
         continue;
	 }
      if (n == RF_STATS) {
         stats_reqd = 1;
         }
      else p_error("Unexpected line in format file");
      }
   fclose(rfp);
   if (rferrors != 0) {
      fprintf(stderr,"%d errors in format file!\n", rferrors);
      exit(10);
      }

   if (listrules) {
      for (n = 0; n != ntags; ++n) {  /* List the tags */
         if ((tip = tags[n]) == NULL) continue;
         fprintf(stderr,"tag %d: ",tip->flow.TagNbr);
         for (i = 0; ; ++i) {
            if ((a = tip->att_nbr[i]) == 0) break;
            fprintf(stderr, " %s=", attribs[a].name);
            put_value(stderr, a, tip->att_p[i]);
            }
         fprintf(stderr,"\n");
         }
      }

   if (argc > 2) {
      if ((input=fopen(argv[2], "r")) == NULL) {
         fprintf(stderr, "cant open %s:",argv[2]); perror("");
         exit(1);
         }
      }
   else input = stdin;

/* Read the header line and check it */

   if (fgets(inbuf, sizeof(inbuf), input) == NULL) {
      fprintf(stderr, "initial read failed on input file\n");
      exit(10);
      }

   recno++;
   if (strncmp(inbuf, "##NeTraMet ", 10) != 0) {
      fprintf(stderr,
	      "Hmm ... this does not appear to be a NeTraMet file, exiting\n");
      exit(10);
      }
   if (strncmp(inbuf+11, "v2.3:", 5) != 0) {
      fprintf(stderr, 
         "Warning: this program was written for version 2.3 files,"
	 "continuing\n");
      }
   if ((p = strstr(inbuf+12, "flows")) == NULL) {
      fprintf(stderr, "Can't find maximum flow number! exiting\n");
      exit(10);
      }
   for (--p; isspace(*p); ) --p;
   for ( ; isdigit(*p); ) --p;
   sscanf(p,"%d",&max_flows);

   /* Allocate two extra flows since they start from 2 not 0 */

   if ((flow=(struct flow_data *)calloc(
         max_flows+2, sizeof(struct flow_data))) == NULL) {
      fprintf(stderr, "Failed to allocate memory for flow table, exiting\n");
      exit(10);
      }

   output = stdout;
   fputs(inbuf, output);  /* Copy header record to new file */

   if (fgets(inbuf, 500, input) == NULL) {
      fprintf(stderr,"2nd read failed on flows file\n");
      exit(10);
      }
   recno++;

   if (inbuf[1] != 'F') {  /* Format record */
      fprintf(stderr,"failed to find format record in flows file\n");
      exit(10);
      }
   else {
      ic = ' ';  ibp = inbuf+8;  /* Scan format line */
      scan_format(&in_set,1,listrules);  /* single_record */
      if (!check_formats(&in_set, &out_set)) exit(1);

      fputs("#Format: ", output);
      for (i = 0; i < NATTRIBS && out_set.format[i]; i++) {
         fputs(attribs[out_set.format[i]].name, output);
         if (out_set.separator[i]) fputs(out_set.separator[i], output);
         }
      fputs("\n", output);
      }

   if (!in_set.required[FTFLOWINDEX] || !in_set.required[FTRULESET] ||
         !in_set.required[FTFIRSTTIME])
      p_error("Input file must have FlowIndex, FlowRuleSet and\n"
         "   FirstTime to uniquely identify flows");
   if (rferrors != 0) exit(1);

   for (a = 1; a != NATTRIBS+1; ++a)  /* Make pointers to curr_flow attribs */
      attribs[a].value = attrib_ptr(&curr_flow, a);

   while (fgets(inbuf, 500, input)) {
      recno++;
      if (inbuf[0] == '#') {
         if( skip_first && first_sample && recno > 4 && inbuf[1] == 'T')
	    first_sample = 0;
         if (inbuf[1] != 'S' || stats_reqd)
            fputs(inbuf, output);
         }
      else {  /* It's a flow */
         pb = inbuf; 
         memset(&curr_flow, 0, sizeof(curr_flow)); /* Zero current values */

         /* Loop to get the values ... */
      
         for (i = 0; *pb && i != NATTRIBS && in_set.format[i]; i++) {
            a = in_set.format[i];
            pb = get_value(attribs[a].value, a, pb);
	    if(in_set.separator[i]) pb += strlen(in_set.separator[i]);
            }
         if ((fi=curr_flow.FlowIndex) > max_flows+1) {
	    fprintf(stderr,
	       "flow index (%d) greater than number of flows from "
	       "header (%d) at record number %d\n",
	       fi, max_flows, recno);
            exit(10);
            }

         if (ruleset == flow[fi].ruleset || ruleset == 0) {

            for (fail = 1, n = 0;  n != ntags;  ++n) {  /* Search tag list */
               tip = tags[n];
               for (fail = i = 0; ; ++i) {
                  if ((a = tip->att_nbr[i]) == 0) break;
                  if (string_value(a)) {
                     if (strcmp(attribs[a].value.charval,
                           tip->att_p[i].charval) != 0) {
                        fail = 1;  break;
                        }
		     }
                  else {  /* Unisgned int */
                     if (*attribs[a].value.intval != *tip->att_p[i].intval) {
                        fail = 1;  break;
                        }
		     }
                  }
               if (!fail) break;
               }
            if (fail) continue;  /* Flow not selected by tags - ignore it */

            if (flow[fi].ruleset == 0 || 
                  flow[fi].ruleset != curr_flow.FlowRuleSet ||
                  flow[fi].starttime != curr_flow.FirstTime) {
               /* It's a new flow */
	       memset(&flow[fi], 0, sizeof(flow[fi]));
	       flow[fi].ruleset =  curr_flow.FlowRuleSet;
	       flow[fi].starttime = curr_flow.FirstTime;
	       flow[fi].flownum = next_flow++;
	       }
            if (curr_flow.FwdBytes) {
	       curr_flow.upbci = curr_flow.FwdBytes - flow[fi].upbc;
	       flow[fi].upbc = curr_flow.FwdBytes;
	       }
            if (curr_flow.BackBytes) {
	       curr_flow.dnbci = curr_flow.BackBytes - flow[fi].dnbc;
	       flow[fi].dnbc = curr_flow.BackBytes;
	       }
            if (curr_flow.FwdPackets) {
	       curr_flow.uppci = curr_flow.FwdPackets - flow[fi].uppc;
	       flow[fi].uppc = curr_flow.FwdPackets;
	       }
            if (curr_flow.BackPackets) {
	       curr_flow.dnpci = curr_flow.BackPackets - flow[fi].dnpc;
	       flow[fi].dnpc = curr_flow.BackPackets;
	       }
            if (ntags != 0) curr_flow.TagNbr = tip->flow.TagNbr;
            if (!(skip_first && first_sample)) {  /* Write the values */
	       for (i = 0; i != NATTRIBS && out_set.format[i]; ++i) {
	          a = out_set.format[i];
	          put_value(output, a, attribs[a].value);
	          if (out_set.format[i+1])
                     fprintf(output,"%s",out_set.separator[i]);
	          }
	       fprintf(output, "\n");
	       }
            }
         }
      }
   }

int check_formats(struct flow_stats *in, struct flow_stats *out)
{
   return 1;
   }
