/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The Benchmark Control Protocol - the queue for local delivery
 */
#include <general.h>
#include <ipc.h>
#include <ipc_sig.h>

#define MAX_LOCAL_MSGS	30

static int local_nmsg = 0;
static msg_t *local_msgs[MAX_LOCAL_MSGS];


/*  */

int local_clear()
{
    local_nmsg = 0;
};

int local_nummsg()
{
    return local_nmsg;
}

/*  */
	
int enqueue_local(msg)
    msg_t *msg;
{
    msg_t *m;
    int s = LOCAL_MSG_LOCK;

    tprintf("enqueue_local(0x%x) - queue %d\n", msg, local_nmsg);
    
    if (local_nmsg >= MAX_LOCAL_MSGS) {
    	LOCAL_MSG_UNLOCK(s);
	return NOTOK;
    }
    m = (msg_t *)malloc(sizeof(msg_t));
    if (!m) {
    	LOCAL_MSG_UNLOCK(s);
	return NOTOK;
    }
    *m = *msg;
    if (msg->msg_datalen) {
	m->msg_data = (char *)malloc(m->msg_datalen);
	if (!m->msg_data) {
	    free((char *)m);
	    LOCAL_MSG_UNLOCK(s);
	    return NOTOK;
	}
	bcopy(msg->msg_data, m->msg_data, m->msg_datalen);
    }
    local_msgs[local_nmsg++] = m;
    LOCAL_MSG_UNLOCK(s);
    return OK;
} /* enqueue_local */

/*  */

int dequeue_local(msg)
    msg_t *msg;
{
    int s = LOCAL_MSG_LOCK;
    int ret;
	register int i;
    
    tprintf("dequeue_local(0x%x) - queue %d\n", msg, local_nmsg);
    
    if (local_nmsg == 0) {
	dprintf(EF_IN3, INTERNAL, "no messages", "local queue");
	ret = NOTOK;
	goto done;
    } 
    
    if (local_msgs[0] == NULL) {
	eprintf(EF_IN3, INTERNAL, "inconsistent queue", "dequeue_local");
	dprintf("\tlocal_msg = %d\n", local_nmsg);
	ret = NOTOK;
	goto done;
    }
    
    *msg = *local_msgs[0];
    free((char *)local_msgs[0]);
    for (i = 1; i < local_nmsg; i++)
	local_msgs[i-1] = local_msgs[i];
    local_msgs[local_nmsg--] = NULL;	/* for safety */
    ret = OK;
    
 done:
    LOCAL_MSG_UNLOCK(s);
    return ret;
} /* dequeue_local */

