/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The Benchmark Control Protocol - sending and receiving messages using stdio
 * on top of sockets.
 */

#include <general.h>
#include <ipc.h>

/*
 * Exports:
 *	fd_send_msg(a_fd: int *, msg: *msg_t) -> OK/NOTOK
 *	fd_receive_msg(a_fd: int *, msg: *msg_t) -> OK/NOTOK
 */

/*  */

#define HEADER_STRING 	"from 0x%x,%d to 0x%x,%d code %d datalen %d:"



int fd_send_msg(a_fd, msg)
    int *a_fd;
    msg_t *msg;
{
    int fd = *a_fd, oldfd;
    FILE *f;
    
    tprintf("fd_send_msg(%d, 0x%x)\n", fd, msg);

    if (msg->msg_code == MSG_CLOSE) {
	dprintf("fd_send_msg closing fd %d\n", fd);
	(void)close(fd);
	*a_fd = NOTOK;
	return OK;
    }

    if (fd == NOTOK) {
	eprintf(EF_IN4, INTERNAL, PROTOCOL, "Bad fid", "fd_send_msg");
	return NOTOK;
    }

    oldfd = fd;

    fd = dup(fd);
    if (fd == NOTOK) {
	printf("fd_send_msg: failed dup, fd = %d\n", oldfd);
	eprintf(EF_SYSCALL, INTERNAL, "dup", "fd_send_msg",
		getsyserr());
	return NOTOK;
    }
    
    f = fdopen(fd, "w");
    if (f == NULL) {
	eprintf(EF_SYSCALL, INTERNAL, "fdopen", "fd_send_msg",
		getsyserr());
	dprintf("\tFile descriptor %d\n", fd);
	(void)close(fd);
	return NOTOK;
    }

    fprintf(f, HEADER_STRING, 
	    msg->msg_from.ba_addr, msg->msg_from.ba_index,
	    msg->msg_to.ba_addr, msg->msg_to.ba_index,
	    msg->msg_code, msg->msg_datalen);


    if (msg->msg_datalen > 0) {
	register i = msg->msg_datalen;
	register char *str = msg->msg_data;


	while (i--)
	    putc(*str++, f);
    }


    if (fflush(f) == EOF) {
	eprintf(EF_IN4, INTERNAL, PROTOCOL, "fflush", "fd_send_msg");
	fclose(f);
	return NOTOK;
    }
    fclose(f);

    tprintf("fd_send_msg - done\n");
    return OK;
} /* fd_send_msg */

/*  */

int fd_recv_msg(a_fd, msg)
    int *a_fd;
    msg_t *msg;
{
    FILE *f;
    int nread;
    int fd = *a_fd;

    tprintf("fd_recv_msg(%d, 0x%x)\n", fd, msg);

    if (fd == NOTOK) {
	eprintf(EF_IN4, INTERNAL, PROTOCOL, "Bad fid", "fd_recv_msg");
	return NOTOK;
    }
    
    fd = dup(fd);
    if (fd == NOTOK) {
	eprintf(EF_SYSCALL, INTERNAL, "dup", "fd_recv_msg",
		getsyserr());
	return NOTOK;
    }
	
    f = fdopen(fd, "r");
    if (f == NULL) {
	eprintf(EF_SYSCALL, INTERNAL, "fdopen", "fd_recv_msg",
		getsyserr());
	dprintf("\tFile descriptor %d\n", fd);
	(void)close(fd);
	return NOTOK;
    }

    setbuf(f, NULL);
    
    nread = fscanf(f, HEADER_STRING,
	    &msg->msg_from.ba_addr, &msg->msg_from.ba_index,
	    &msg->msg_to.ba_addr, &msg->msg_to.ba_index,
		  &msg->msg_code, &msg->msg_datalen);

    if (nread == EOF) {
	dprintf(EF_IN4, INTERNAL, PROTOCOL, "fscanf", "fd_recv_msg");
	dprintf("\tReturns EOF - fd is closed!\n");
	(void)close(*a_fd);
	*a_fd = NOTOK;
	/* The mapping from fd to msg_from is done in check_closed() */
	msg->msg_code = MSG_INTERNAL_CLOSED;
	msg->msg_data = NULL;
	msg->msg_datalen = 0;
        (void)fclose(f);
	return OK;
    }
    if (nread != 6) {
	eprintf(EF_IN4, INTERNAL, PROTOCOL, "fscanf", "fd_recv_msg");
	dprintf("\tFields read %d, expected 6\n", nread);
        fclose(f);
	return NOTOK;
    }

    if (msg->msg_datalen > 0) {
	register i;
	register char *str;
	register int c;

	msg->msg_data = (char *)malloc(msg->msg_datalen);
	if (msg->msg_data == NULL) {
	    eprintf(EF_IN4, INTERNAL, RESOURCE, "malloc failed",
		    "fd_recv_msg");
	    fclose(f);
	    return NOTOK;
	}
	i = msg->msg_datalen;
	str = msg->msg_data;

	while (i--) {
	    c = getc(f);
	    if (c == EOF) {
		eprintf(EF_IN4, INTERNAL, PROTOCOL, "getc", "fd_recv_msg");
		dprintf("\tReturns EOF when expecting %d more characters\n",
			i+1);
		fclose(f);
		return NOTOK;
	    } else {
		*str++ = c;
	    }
	}
    }
    fclose(f);

    return OK;
} /* fd_recv_msg */

