/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Printing the results of the benchmarks according to the output specification
 * in doc/outformat.
 */

/* Exports:
 *	stats_print(sum, min, max, sqsum: struct statistics *)
 */

#include <general.h>

#define DEMO

#define PRINTFIELD(str1,str2,field)	\
    if (avg->field != ST_UNDEF && avg->field != 0.0) { \
	if (std->field != 0.0) \
	   printf("%s%s    \t%10.4f  %10.4f  %10.4f  %10.4f\n", 	\
		  str1,str2, avg->field, min->field,	\
		  max->field, std->field); \
        else \
	   printf("%s%s    \t%10.4f\n", 	\
		  str1,str2, avg->field); \
	}

#define PRINTFIELD_FORCE(str1, str2, field)	\
    if (avg->field != ST_UNDEF) { \
	if (std->field != 0.0) \
	   printf("%s%s    \t%10.4f  %10.4f  %10.4f  %10.4f\n", 	\
		  str1, str2, avg->field, min->field,	\
		  max->field, std->field); \
        else \
	   printf("%s%s    \t%10.4f\n", 	\
		  str1, str2, avg->field); \
	}

    
stats_print(prestr, sum, min, max, sqsum, nrun_ok)
    char *prestr;
    statistics_t *sum, *min, *max, *sqsum;
    int nrun_ok;
{
    statistics_t avgs, stds, *avg = &avgs, *std = &stds;

    tprintf("stats_print(0x%x, 0x%x, 0x%x, 0x%x, %d)\n",
	    sum, min, max, sqsum, nrun_ok);

    StatsSum2Avg(nrun_ok, sum, avg);
    StatsSqsum2Std(nrun_ok, avg, sqsum, std);
    
    if (nrun_ok == 0)
	return;
    
    printf("Field    \t%10s  %10s  %10s  %10s\n",
 	   "Average", "Min   ", "Max   ", "Std Dev");
    
    PRINTFIELD(prestr, "exitstatus", st_exitstatus);
    PRINTFIELD_FORCE(prestr, "elapsed", st_elapsed);
    PRINTFIELD_FORCE(prestr, "cputime", st_cputime);
    PRINTFIELD(prestr, "stime", st_stime);
    PRINTFIELD(prestr, "utime", st_utime);
    PRINTFIELD(prestr, "delay", st_delay);
    PRINTFIELD(prestr, "datasent", st_datasent);
    PRINTFIELD(prestr, "datarcvd", st_datarcvd);
    PRINTFIELD(prestr, "msgsent", st_msgsent);
    PRINTFIELD(prestr, "msgrcvd", st_msgrcvd);
    PRINTFIELD(prestr, "packsent", st_packsent);
    PRINTFIELD(prestr, "packrcvd", st_packrcvd);
    PRINTFIELD(prestr, "signals", st_signals);
    PRINTFIELD(prestr, "blockout", st_blockout);
    PRINTFIELD(prestr, "blockin", st_blockin);
    PRINTFIELD(prestr, "pageio", st_pageio);
    PRINTFIELD(prestr, "pagerecl", st_pagerecl);
    PRINTFIELD(prestr, "swaps", st_swaps);
    PRINTFIELD(prestr, "ivcsw", st_ivcsw);
    PRINTFIELD(prestr, "vcsw", st_vcsw);
    PRINTFIELD(prestr, "maxrss", st_maxrss);
#ifndef DEMO

    PRINTFIELD(prestr, "starttime", st_starttime);
    PRINTFIELD(prestr, "stoptime", st_stoptime);

{
    long start, stop;

    start = avg->st_starttime;
    stop = avg->st_stoptime;
    
    printf("Start time %sStop time %s",
	   ctime(&start), ctime(&stop));
}
    printf("stop-start    \t%10.4f  %10.4f  %10.4f \n", 	
	   1000*(avg->st_stoptime - avg->st_starttime),
	   1000*(min->st_stoptime - min->st_starttime),	
	   1000*(max->st_stoptime - max->st_starttime));
#endif
}
