/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * A benchmark for measuring connection setup and taredown DEMON
 *
 * Parameters:
 *
 */

#include <general.h>
#include <protospec.h>
#include <measproc.h>

#define allocchannels(num)	(channel_t *)malloc(sizeof(channel_t)*num)


int idle_connd(be, server, srchdl, dsthdl, mt)
    struct bench 	*be;
    struct server_t 	*server;
    iohdl_t 		*srchdl, *dsthdl;
    metrics_t 		*mt;		/* out parameter */
{
    RESPONDER_VARIABLES;
    TIMING_VARIABLES(2);
    TIMING_VARIABLES(3);
    channel_t *chs;
    

    mprintf("idle_connd(be 0x%x, src 0x%x, dst 0x%x, mt 0x%x)\n",
		 be, srchdl, dsthdl, mt);


    TIMING_INITIATE(2);
    TIMING_INITIATE(3);

    chs = allocchannels(iterations);
    if (chs == NULL) {
	report_error(NULL, "Resource shortage (allocchannels)");
    }

    RESPONDER_BEFORE_START;

    StartMeasurements(mt);

    for (i = 0; i < iterations; i++) {
	if (interupted)
	    break;
	AwaitConnInd(server, &chs[i], &error);
	if (failed(&error) && !interupted) {
	    report_error(&error, "AwaitConnInd");
	    return NOTOK;
	}
	if (interupted)
	    continue;	/* increase i one more step */

	TIMING_DELAY(2);
    }
    
    iterations = i;	/* if interupted */
    interupted = 0;
    
    for (i = 0; i < iterations; i++) {
	AwaitDiscInd(chs[i], &error);
	if (failed(&error) && !interupted) {
	    report_error(&error, "AwaitDiscInd");
	    return NOTOK;
	}
	if (interupted)
	    break;
	TIMING_DELAY(3);
    }

    StopMeasurements(mt);
    if (interupted)
	mt->mt_exit = MT_EXIT_INT;

    return OK;
} /* idle_connd */



