/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * A benchmark for measuring one-way bulk data transfer DEMON
 *
 * Parameters:
 *
 */

#include <general.h>
#include <protospec.h>
#include <measproc.h>



int bulk_getd(be, server, srchdl, dsthdl, mt)
    struct bench	*be;
    struct server_t 	*server;
    iohdl_t 		*srchdl, *dsthdl;
    metrics_t 		*mt;		/* out parameter */
{
    RESPONDER_VARIABLES;
    TIMING_VARIABLES(1);
    channel_t ch;
    

    mprintf("bulk_getd(src 0x%x, dst 0x%x, mt 0x%x)\n",
		srchdl, dsthdl, mt);

    TIMING_INITIATE(1);

    RESPONDER_BEFORE_START;

    StartMeasurements(mt);
    
    AwaitConnInd(server, &ch, &error);
    if (failed(&error)) {
	report_error(&error, "AwaitConnInd");
	return NOTOK;
    }

    if (interupted) {
	goto done;
    }

    AwaitBulkGetStart(ch, &error);
    if (failed(&error)) {
	report_error(&error, "AwaitBulkGetStart");
	goto abort;
    }
    
    for (i = 0; i < iterations; i++) {
	RESPONDER_SENDSIZE(msgsize,i);
	if ((*srchdl->io_get)(srchdl, msgsize) == NOTOK) {
	    report_error(NULL, "io_get");
	    goto abort;;
	}
	BulkGetDataReq(ch, srchdl->io_buffer, msgsize, &error);
	if (failed(&error)) {
	    report_error(&error, "BulkGetDataReq");
	    if (interupted)
		goto done;
	    else
		goto abort;
	}
	MetricsAddDatasent(mt, msgsize);
	TIMING_DELAY(1);
    }

    AwaitBulkGetStop(ch, &error);
    if (failed(&error)) {
	report_error(&error, "AwaitBulkGetStop");
	if (!interupted)
	    goto abort;
    }

done:
    StopMeasurements(mt);
    if (interupted) {
	mt->mt_exit = MT_EXIT_INT;
    }

    AwaitDiscInd(ch, &error);
    if (failed(&error)) {
	report_error(&error, "AwaitDiscInd");
	if (!interupted) 
	    return NOTOK;
    }
    return OK;

abort:
    AwaitDiscInd(ch, &error);
    if (failed(&error)) {
	report_error(&error, "AwaitDiscInd on abort");
    }
    return NOTOK;
    
} /* bulk_getd */
