/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Common routines for all protocols: they only map macros in
 * protocol specific header file to subroutines.
 * Using this makes all of the SPIMS object files protocol independent.
 */

#include <general.h>
#include <protospec.h>

init_client()
{
    InitClient();
}



int destroy_server(server)
    struct server_t *server;
{
    error_t err;
    
    DestroyServer(server, &err);
    if (failed(&err)) {
	report_error(&err,"DestroyServer");
	return NOTOK;
    }
    return OK;
}


int create_server(a_server, a_addr)
    struct server_t **a_server;
    struct address_t **a_addr;
{
    error_t err;
    
    CreateServer(a_server, a_addr, &err);
    if (failed(&err)) {
	report_error(&err, "CreateServer");
	return NOTOK;
    }
    return OK;
}

/*  */

/* Internet specific */
#ifdef INADDR_ANY	/* I.e. an internet protocol */

#ifndef __NETDB__
#define __NETDB__
#include <netdb.h>
#endif __NETDB__

#define HOSTNAMLEN 40


int get_myipaddr(a_ipaddr)
    struct in_addr *a_ipaddr;
{
    char LocalHost[HOSTNAMLEN];
    struct hostent *local;

    tprintf("get_myipaddr()\n");

    if (gethostname(LocalHost, HOSTNAMLEN) == NOTOK) {
	eprintf(EF_IN3, INTERNAL, "gethostname", "get_myipaddr");
	return NOTOK;
    }

    local = gethostbyname(LocalHost);

    if (local == NULL) {
	eprintf(EF_3, INTERNAL,
		"Name lookup on local host failed", LocalHost);
  	return NOTOK;
    }
    if (local->h_addrtype != AF_INET) {
	eprintf(EF_3, INTERNAL,
		"Name lookup on local host failed - no internet address",
		LocalHost);
	return NOTOK;
    }

    a_ipaddr->s_addr = (*(long *)local->h_addr);
    
    dprintf("get_myipaddr: 0x%x\n", a_ipaddr->s_addr);
    return OK;
} /* get_myipaddr */

#endif INADDR_ANY
