/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Header file for benchmarks on the NULL protocol
 * The NULL protocol does no communication at all - it is useful
 * for measuring file system performance, and testing distribution
 * functions.
 */

#ifndef __NULLPROTO__
#define __NULLPROTO__

#include "../protoaddrs/nulladdr.h"

typedef long channel_t;
struct server_t {
    long dummy;
};


/*
 * Error handling
 */
typedef long error_t;

#define failed(err)	0	/* never failes */

#define report_error(err,str)	null_report_error(err,str)


#define InitClient()		{};

#define ConnRequest(addr,a_ch,errind) \
				{ *a_ch = 0; *errind = OK; }
#define DiscRequest(ch, errind) \
    				{*errind = OK; }
#define AwaitConnInd(server, a_ch, errind) \
				{ *a_ch = 0; *errind = OK; }

#define AwaitDiscInd(ch, errind) \
	    			{*errind = OK; }

#define BulkGetStart(ch, errind)	\
	    			{*errind = OK; }
#define BulkGetStop(ch, errind) 	\
	    			{*errind = OK; }
#define AwaitBulkGetStart(ch, errind)	\
	    			{*errind = OK; }
#define AwaitBulkGetStop(ch, errind)	\
	    			{*errind = OK; }
#define BulkPutStart(ch, errind)	\
	    			{*errind = OK; }
#define BulkPutStop(ch, errind)	\
	    			{*errind = OK; }
#define AwaitBulkPutStart(ch, errind)	\
	    			{*errind = OK; }
#define AwaitBulkPutStop(ch, errind)	\
	    			{*errind = OK; }




#define CreateServer(a_server, a_addr, errind) \
				{ *errind = OK; }

#define DestroyServer(server, errind) \
				{ *errind = OK; }



#define DataRequest(channel,buffer,amount,errind) \
				{ *errind = OK; }
#define AwaitDataIndication(channel,buffer,amount,errind) \
				{ *errind = OK; }


#define BulkGetDataReq		DataRequest
#define BulkPutDataReq  	DataRequest
#define BulkGetAwaitDataInd	AwaitDataIndication
#define BulkPutAwaitDataInd	AwaitDataIndication

#define RRSendRequest 		BulkPutDataReq
#define RRAwaitResponseInd	BulkGetAwaitDataInd
#define RRAwaitRequestInd	BulkPutAwaitDataInd
#define RRSendResponse		BulkGetDataReq

#define QueryCall(addrp, srcbuf, srclen, dstbuf, dstlen, errind) \
				{ *errind = OK; }

#define QueryAwaitCallInd(serverp, dstbuf, dstlen, chp, errind) \
				{ *errind = OK; }

#define QueryReturn(ch, srcbuf, srclen, errind) \
				{ *errind = OK; }

#define RPCCall(addrp, srcbuf, srclen, dstbuf, dstlen, errind) \
				{ *errind = OK; }

#define RPCAwaitCallInd(ch, dstbuf, dstlen, errind) \
				{ *errind = OK; }

#define RPCReturn(ch, srcbuf, srclen, errind) \
				{ *errind = OK; }
    
#endif __NULLPROTO__
