/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */

/* Some parts of this code has been derived from the ISODE 4.0
 * Distribution Package, from Northrop. The software development
 * was initially supervised by  Rose and Cass. It has the following
 * notice:
 */

/*
 *                                NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */

/*
 * FTAM protocol specific code
 */

/*
 * TODO
 *
 */


#include <general.h>
#include <protospec.h>

#ifndef IPPORT_RESERVED
#include <netinet/in.h>
#endif

extern struct vfsmap vfs[];

#define	AMASK	"\020\01STORAGE\02SECURITY\03PRIVATE"

#define	UMASK	"\020\01READ\02WRITE\03ACCESS\04LIMITED\05ENHANCED\06GROUPING\
\07RECOVERY\08RESTART"


#define INF_WAIT NOTOK

void ftam_diag(), ftam_chrg();

/*  */

ftam_init_client()
{
    register struct isodocument *id;
    register struct vfsmap *vf;

    pprintf("ftam_init_client()\n");
    
    for (vf = vfs + 1; vf->vf_entry; vf++) {	/* skip "default" entry */
    pprintf("ftam_init_client: calling getisodocument\n");
	if (id = getisodocumentbyentry (vf->vf_entry)) {
	    pprintf("ftam_init_client: getisodocument done \n");
	    if ((vf->vf_oid = oid_cpy (id->id_type)) == NULLOID) {
		eprintf(EF_IN4, RESOURCE, "out of memory", "ftam_init_client",
		       "oid_cpy failed");
		exit(2);
	    }
	}
	else {
	    pprintf("ftam_init_client: getisodocument failed\n");
	    if (vf->vf_flags & VF_WARN) {
		eprintf(EF_IN4X, "FTAM problem",
		       "local realstore has no support for type",
		       "ftam_init_client",  vf->vf_text);
	    }
	}
    }
} /* ftam_init_client */

/*  */

ftam_conn_request(addr, a_ch, errind)
    struct address_t *addr;
    channel_t *a_ch;
    error_t   *errind;
{
    struct FTAMcontentlist fcs;
    struct FTAMcontentlist *fc;
    struct FTAMconnect ftcs, *ftc = &ftcs;
    register struct vfsmap *vf;
    

    pprintf("ftam_conn_request(0x%x, 0x%x, 0x%x)\n", addr, a_ch, errind);


    fc = &fcs;
    fc->fc_ncontent = 0;
    for (vf = vfs; vf->vf_entry; vf++)
	if (vf->vf_oid) {
	    fc->fc_contents[fc->fc_ncontent++].fc_dtn = vf->vf_oid;
	    pprintf("Sending vf_id = %d\n", vf->vf_id);
	}
    
    pprintf("Calling FInitializeRequest\n");
    pprintf("fc->fc_ncontents = %d\n",    fc->fc_ncontent);


    if (FInitializeRequest(NULLAEI, NULLAEI, NULLPA, addr, FTAM_MANAGE,
			   FTAM_LEVEL, FTAM_CLASS, FTAM_UNITS, FTAM_ATTRS,
			   FTAM_ROLLBACK, fc, 
			   "benchmark", NULLCP, NULLCP, 0, NULL, NULLIFP,
			   ftc, &errind->er_fti) == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "FInitializeRequest",
	       "ftam_conn_request");
	errind->er_ret = NOTOK;
	errind->er_tag = ERT_FTI;
	return;
    }

    pprintf("ftam_conn_request: channel %d, state %d, action %d\n",
		ftc->ftc_sd, ftc->ftc_state, ftc->ftc_action);

    ftam_diag(ftc->ftc_diags, ftc->ftc_ndiag,
	      ftc->ftc_sd != NOTOK || errind->er_fti.fti_abort.fta_peer,
	      ftc->ftc_action);

    FTCFREE(ftc);

    if (ftc->ftc_state == FSTATE_FAILURE) {
	switch (ftc->ftc_action) {
	case FACTION_SUCCESS:
	    break;
	case FACTION_TRANS:
	    eprintf(EF_IN4X, COMMUNICATION, "FInitializeRequest",
		   "ftam_conn_request", "Transient error");
	    errind->er_tag = ERT_NONE;
	    errind->er_ret = NOTOK;
	    return;
	case FACTION_PERM:
	    eprintf(EF_IN4X, COMMUNICATION, "FInitializeRequest",
		   "ftam_conn_request", "Transient error");
	    errind->er_tag = ERT_NONE;
	    errind->er_ret = NOTOK;
	    return;
	}
    }
    {
	struct FTAMcontent *fx;
	int i;

	pprintf("ftam_conn_req: ncontent = %d\n",
		ftc->ftc_contents.fc_ncontent);
	
	for (fx = ftc -> ftc_contents.fc_contents,
	     i = ftc -> ftc_contents.fc_ncontent - 1;
	     i >= 0;
	     fx++, i--) {
	    if (fx -> fc_result != PC_ACCEPT)
		continue;
	    
	    for (vf = vfs; vf -> vf_entry; vf++)
		if (oid_cmp (vf -> vf_oid, fx -> fc_dtn) == 0) {
		    vf -> vf_flags |= VF_OK;
		    vf -> vf_id = fx -> fc_id;
		    pprintf("ftam_conn_req: vf_id set to %d\n", vf->vf_id);
		    break;
		}
	}
    }
    *a_ch = ftc->ftc_sd;

    errind->er_ret = OK;
} /* ftam_conn_request */

/*  */

#define	seterr(id,ob) \
{ \
    dp->ftd_identifier = (id); \
    dp->ftd_observer = (ob); \
    goto bad2; \
}

ftam_await_conn_ind(server, a_ch, errind)
    struct server_t *server;	
    channel_t *a_ch;
    error_t *errind;
{
    struct PSAPaddr *pa = server; 
    int	    n,
	    secs,
	    vecp;
    char   *vec[4];
    struct FTAMstart ftsrec, *fts = &ftsrec;
    register struct isodocument *id;
    register struct vfsmap *vf;
    register struct FTAMcontent *fx;
    struct FTAMdiagnostic   diags[NFDIAG];
    register struct FTAMdiagnostic *dp = diags;
    int level, class, fadusize;
    int i;
    

    pprintf("ftam_await_conn_ind(??, 0x%x, 0x%x)\n", a_ch, errind);

    /* Wait for incoming connections */
    for (;;) {
	errind->er_ret = TNetAccept (&vecp, vec, 0, NULLIP, NULLIP, NULLIP,
				     INF_WAIT, &errind->er_td);
	if (errind->er_ret == NOTOK) {
	    eprintf(EF_IN3, COMMUNICATION, "TNetAccept",
		   "ftam_await_conn_ind");
	    errind->er_tag = ERT_TD;
	    return;
	}

	if (vecp > 0)
	    break;
    }

    errind->er_ret = FInit (vecp, vec, fts, NULLIFP, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "FInit", "ftam_await_conn_ind");
	errind->er_tag = ERT_FTI;
	return;
    }

    
    if (ProtoDebug) {
	register int    i;
	register struct FTAMcontent *fx;
	struct PSAPaddr *pai = &fts->fts_callingaddr;
	struct PSAPaddr *par = &fts->fts_calledaddr;
	struct SSAPaddr *sai = &pai->pa_addr;
	struct SSAPaddr *sar = &par->pa_addr;
	struct TSAPaddr *tai = &sai->sa_addr;
	struct TSAPaddr *tar = &sar->sa_addr;
	struct NSAPaddr *nai = tai->ta_addrs;
	struct NSAPaddr *nar = tar->ta_addrs;

	pprintf("ftam_await_conn_ind: channel %d\n", fts->fts_sd);

	pprintf(" calling PSAP address: <<<%s, %d>, %d>, %d>\n",
		na2str (nai), ntohs (tai->ta_port), ntohs (sai->sa_port),
		ntohs (pai->pa_port));
	pprintf(" called PSAP address: <<<%s, %d>, %d>, %d>\n",
		na2str (nar), ntohs (tar->ta_port), htons (sar->sa_port),
		ntohs (par->pa_port));

	pprintf(" manage: %d, rollback: %d\n",
		fts->fts_manage, fts->fts_rollback);
	pprintf(" units: %s\n",
		sprintb (fts->fts_units, UMASK));
	pprintf(" attrs: %s\n",
		sprintb (fts->fts_attrs, AMASK));

	for (fx = fts->fts_contents.fc_contents, i = 0;
		i < fts->fts_contents.fc_ncontent;
		fx++, i++)
	    pprintf(" cnt %d: %s %d %d\n",
		i, sprintoid (fx->fc_dtn), fx->fc_id, fx->fc_result);
    }
    
    *a_ch = fts->fts_sd;

    if ((level = fts->fts_level) != FLEVEL_RELIABLE)
	seterr (FS_ACS_LEVEL, EREF_RFSU);
    switch (class = fts->fts_class) {
	case FCLASS_TRANSFER: 
	case FCLASS_MANAGE: 
	case FCLASS_TM: 
	    break;

	default: 
	    seterr (FS_ACS_CLASS, EREF_RFSU);
    }
    if ((fadusize = fts->fts_ssdusize - 19) < 0)/* MAGIC! */
	fadusize = 0;

    	pprintf("ftam_await_conn_ind: ncontent = %d\n",
		fts->fts_contents.fc_ncontent);

    for (fx = fts->fts_contents.fc_contents,
		i = fts->fts_contents.fc_ncontent - 1;
	    i >= 0;
	    fx++, i--) {
	if (fx->fc_result != PC_ACCEPT)
	    continue;

	for (vf = vfs; vf->vf_entry; vf++)
	    if (vf->vf_oid
		    && oid_cmp (vf->vf_oid, fx->fc_dtn) == 0) {
		vf->vf_flags |= VF_OK;
		vf->vf_id = fx->fc_id;
		pprintf("ftam_await_conn_ind: vf_id set to %d\n", vf->vf_id);
		break;
	    }
	if (!vf->vf_entry)
	    fx->fc_result = PC_REJECTED;
    }

    pprintf("Calling FInitializeResponse\n");
    pprintf("fc->fc_ncontents = %d\n", fts->fts_contents.fc_ncontent);
    pprintf("initiator: %s\n", fts->fts_initiator);
    
    errind->er_ret = FInitializeResponse (fts->fts_sd, FSTATE_SUCCESS,
			     FACTION_SUCCESS, NULLAEI, pa,
			     fts->fts_manage, fts->fts_units, fts->fts_attrs,
			     fts->fts_rollback, &fts->fts_contents, diags,
			     dp-diags, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "FInitializeResponse",
	       "ftam_await_conn_ind");
	errind->er_tag = ERT_FTI;
	return;
    }

    ftam_diag (diags, dp - diags);
    return;

bad2: ;
    dp->ftd_type = DIAG_PERM;
    dp->ftd_observer = EREF_RFSU;
    dp->ftd_source = EREF_NONE;
    dp->ftd_delay = DIAG_NODELAY;
    dp->ftd_cc = 0;

bad1: ;
    eprintf(EF_IN3, COMMUNICATION, "rejecting association",
	   "ftam_await_conn_ind", "");
    ftam_diag (diags, 1);

    (void) FInitializeResponse (fts->fts_sd, FSTATE_FAILURE, FACTION_PERM,
	    NULLAEI, NULLPA, 0, 0, 0, 0, (struct FTAMcontentlist   *) 0,
	    diags, 1, &errind->er_fti);
    errind->er_tag = ERT_NONE;
    errind->er_ret = NOTOK;
} /* ftam_await_conn_ind */


/*  */

ftam_disc_request(ch, errind)
    channel_t ch;
    error_t   *errind;
{
    struct FTAMrelease ftr;
    

    pprintf("ftam_disc_request(%d, 0x%x)\n", ch, errind);
    
    errind->er_ret = FTerminateRequest(ch, &ftr, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "FTerminateRequest",
	       "ftam_disc_request");
	errind->er_tag = ERT_FTI;
	return;
    }

    pprintf("ftam_disc_request: ncharge %d\n", ftr.ftr_charges.fc_ncharge);

    FTRFREE(&ftr);    
} /* ftam_disc_request */

/*  */

ftam_await_disc_ind(ch, errind)
    channel_t ch;
    error_t *errind;
{
    pprintf("ftam_await_disc_ind(ch %d, 0x%x)\n", ch, errind);

    errind->er_ret = ftam_wait_request(ch, FTI_FINISH, INF_WAIT,
				       &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	errind->er_tag = ERT_FTI;
	eprintf(EF_IN3, COMMUNICATION, "ftam_wait_request",
	       "ftam_await_disc_ind");
	return;
    }

    errind->er_ret = FTerminateResponse(ch, NULL, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "FTerminateResponse",
	       "ftam_await_disc_ind");
	errind->er_tag = ERT_FTI;
    }

} /* ftam_await_disc_ind */

/*  */

ftam_data_request(ch,buffer,amount,errind)
    channel_t ch;
    char * buffer;		
    int amount;
    error_t *errind;
{
    PElement *pe;

    pprintf("ftam_data_request()\n");

    if ((pe = pe_alloc (PE_CLASS_UNIV, PE_FORM_PRIM, PE_PRIM_OCTS))
	    == NULLPE) {
	eprintf(EF_IN4X, RESOURCE, "pe_alloc", "ftam_data_request",
		"out of memory");
	errind->er_tag = ERT_NONE;
	errind->er_ret = NOTOK;
	return;
    }
    pe->pe_context =  vfs[VF_INDEX].vf_id; /* This is 3 in binary (index 1) */
    pe->pe_len = amount;

#ifdef ASCII
    copyascii(buffer, buffer, amount, 1);
#endif

    pe->pe_prim = (PElementData)buffer; /* char* to u_char* */

    pprintf("FDataReq with pe_context = %d\n", pe->pe_context);
    
    errind->er_ret = FDataRequest(ch, &pe, 1, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "FDataRequest", "ftam_data_request");
	errind->er_tag = ERT_FTI;
        pe_free (pe); pe = NULLPE;
	return;
    }

    pe_free (pe); pe = NULLPE;

    errind->er_ret = FWaitRequest (ch, OK, &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	struct FTAMabort *fta = &errind->er_fti.fti_abort;
	
	if (fta -> fta_peer
	    || fta -> fta_action != FACTION_TRANS
	    || fta -> fta_ndiag < 1
	    || fta -> fta_diags[0].ftd_type != DIAG_TRANS
	    || fta -> fta_diags[0].ftd_identifier != FS_PRO_TIMEOUT) {
	    register struct FTAMcancel *ftcn = &errind->er_fti.fti_cancel;
	    
	    eprintf(EF_IN3, COMMUNICATION, "FWaitRequest",
		    "ftam_data_request");
	    ftam_diag (ftcn -> ftcn_diags, ftcn -> ftcn_ndiag, 1,
		       ftcn -> ftcn_action);
	    errind->er_tag = ERT_FTI;
	    return;
	}
	errind->er_ret = OK;
	return;
    }

    if (errind->er_fti.fti_type == FTI_CANCEL) {
	register struct FTAMcancel *ftcn = &errind->er_fti.fti_cancel;

	eprintf(EF_IN4X, COMMUNICATION, "FWaitRequest", "ftam_data_request",
		"data transfer canceled!");
	ftam_diag (ftcn -> ftcn_diags, ftcn -> ftcn_ndiag, 1,
		ftcn -> ftcn_action);

	errind->er_ret = FCancelResponse (ch, FACTION_SUCCESS,
		    (struct FTAMdiagnostic *) 0, 0, &errind->er_fti);
	if (errind->er_ret == NOTOK) {
	    struct FTAMabort *fta = &errind->er_fti.fti_abort;
	    
	    eprintf(EF_IN3, COMMUNICATION, "FTerminateResponse",
		    "ftam_finishindication");
	    ftam_diag(fta->fta_diags, fta->fta_ndiag, fta->fta_peer,
		      fta->fta_action);
	    errind->er_tag = ERT_NONE;
	    return;
	}
    }

    errind->er_ret = OK;
    
} /* ftam_data_request */

/*  */

ftam_await_data_ind(ch,buffer,amount,errind)
    channel_t ch;
    char * buffer;
    int amount;
    error_t *errind;
{
    PElement *pe;
    struct PSAPdata *px;
    
    pprintf("ftam_await_data_ind()\n");

    errind->er_ret = ftam_wait_request(ch, FTI_DATA, INF_WAIT,
				       &errind->er_fti);
    if (errind->er_ret == NOTOK) {
	errind->er_tag = ERT_FTI;
	eprintf(EF_IN3, COMMUNICATION, "ftam_wait_request",
	       "ftam_await_data_ind");
	return;
    }
    /* grab data from fti_data */
    px = &errind->er_fti.fti_data;
    pprintf("Received: px_ninfo = %d\n", px->px_ninfo);

    if (px->px_ninfo != 1) {
	eprintf(EF_IN4X, COMMUNICATION,
		"Number of presentation elements",
		"ftam_await_data_ind");
	eprintf("\tReceived = %d, expected = 1\n", px->px_ninfo);
	PXFREE(px);
	errind->er_ret = NOTOK;
	errind->er_tag = ERT_NONE;
	return;
    }

    pe = px->px_info[0];
    if (pe->pe_form != PE_FORM_PRIM) {
	eprintf(EF_IN4X, COMMUNICATION,
		"Presentation element form",
		"ftam_await_data_ind");
	eprintf("\tReceived = PE_FORM_CONS, expected = PE_FORM_PRIM\n");
	PXFREE(px);
	errind->er_ret = NOTOK;
	errind->er_tag = ERT_NONE;
	return;
    }
    if (pe->pe_len != amount) {
	eprintf(EF_IN4X, COMMUNICATION,
		"Amount of data received",
		"ftam_await_data_ind");
	eprintf("\tReceived = %d, expected = %d\n",
		pe->pe_len, amount);
	PXFREE(px);
	errind->er_ret = NOTOK;
	errind->er_tag = ERT_NONE;
	return;
    }

    pprintf("FDataIndication with pe_context = %d\n", pe->pe_context);
    
    /* copy buffer or exchange? */
#ifdef ASCII
    copyascii((char *)pe->pe_prim, buffer, amount, 0);
#else
    bcopy((char *)pe->pe_prim, buffer, amount);
#endif
    PXFREE(px);

    errind->er_ret = OK;
    
} /* ftam_await_data_ind */

/*  */

ftam_create_server(aa_server, aa_addr, errind)
    struct server_t **aa_server;
    struct address_t **aa_addr;
    error_t   *errind;
{
    struct address_t myaddr;
    struct PSAPaddr *pa = &myaddr;
    int n;
#define HOSTNAMELEN 64
    char LocalHost[HOSTNAMELEN];
    register struct isodocument *id;
    register struct vfsmap *vf;

    pprintf("ftam_create_server(0x%x, 0x%x, 0x%x)\n",
		aa_server, aa_addr, errind);

    if (gethostname(LocalHost, HOSTNAMELEN) == NOTOK) {
	eprintf(EF_SYSCALL, COMMUNICATION, "gethostname",
		"ftam_create_server",
	       getsyserr());
	errind->er_ret = NOTOK;
	errind->er_tag = ERT_NONE;
	return ;
    }

    pprintf("ftam_create_server: LocalHost %s\n", LocalHost);

    myaddr.pa_selectlen = 0;
    myaddr.pa_addr.sa_selectlen = 0;

#ifdef ADDR_SELECT
    myaddr.pa_addr.sa_addr.ta_selectlen =
	sizeof myaddr.pa_addr.sa_addr.ta_port;
    myaddr.pa_addr.sa_addr.ta_port =
	htons((u_short)(0x8000 | (getpid() & 0x7fff)));
#else
    myaddr.pa_addr.sa_addr.ta_selectlen = 0;
#endif

    myaddr.pa_addr.sa_addr.ta_naddr = 1;
    
    /* first NSAP address */
    myaddr.pa_addr.sa_addr.ta_addrs[0].na_type = NA_TCP;
    strcpy(myaddr.pa_addr.sa_addr.ta_addrs[0].na_domain,
	       LocalHost);
    
    myaddr.pa_addr.sa_addr.ta_addrs[0].na_port =
	htons((u_short)(0x8000 | (getpid() & 0x7fff)));
{
    struct TSAPaddr *ta = &pa->pa_addr.sa_addr;

    pprintf("ta_naddr %d, na_type %d, na_domain %s, na_port %d\n",
	    ta->ta_naddr,
	    ta->ta_addrs[0].na_type, ta->ta_addrs[0].na_domain,
	    ta->ta_addrs[0].na_port);
}
    errind->er_ret = TNetListen (&pa->pa_addr.sa_addr, &errind->er_td);
    if (errind->er_ret == NOTOK) {
	eprintf(EF_SYSCALL, COMMUNICATION, "TNetListen", "ftam_create_server",
		getsyserr());
	errind->er_tag = ERT_TD;
	return;
    }

    
    for (vf = vfs + 1; vf->vf_entry; vf++) {	/* skip "default" entry */
    pprintf("ftam_create_server: calling getisodocument\n");
	if (id = getisodocumentbyentry (vf->vf_entry)) {
	    pprintf("ftam_create_server: getisodocument done \n");
	    if ((vf->vf_oid = oid_cpy (id->id_type)) == NULLOID) {
		eprintf(EF_IN4, RESOURCE, "out of memory", "ftam_init_client",
		       "oid_cpy failed");
		exit(2);
	    }
	}
	else {
	    pprintf("ftam_create_server: getisodocument failed\n");
	    if (vf->vf_flags & VF_WARN) {
		eprintf(EF_IN4X, "FTAM problem",
		       "local realstore has no support for type",
		       "ftam_create_server",  vf->vf_text);
	    }
	}
    }

    *aa_server = (struct server_t *)malloc(sizeof(struct server_t));
    if (*aa_server == NULL) {
	eprintf(EF_IN3, INTERNAL, RESOURCE, "CreateServer");
	errind->er_ret = NOTOK;
	return;
    }
    *aa_addr = (struct address_t *)malloc(sizeof(struct address_t));
    if (*aa_addr == NULL) {
	eprintf(EF_IN3, INTERNAL, RESOURCE, "CreateServer");
	errind->er_ret = NOTOK;
	free((char *)*aa_server);
	return;
    }
    **aa_server = myaddr;
    **aa_addr = myaddr;
    errind->er_ret = OK;
} /* ftam_create_server */

/*  */

ftam_destroy_server(a_server, errind)
    struct server_t *a_server;
    error_t   *errind;
{

    pprintf("ftam_destroy_server(0x%x, 0x%x)\n", a_server, errind);

    /* stop listening */

    free((char *)a_server);
    errind->er_ret = TNetClose (NULLTA, &errind->er_td);
    if (errind->er_ret == NOTOK) {
	eprintf(EF_IN3, COMMUNICATION, "TNetClose", "ftam_destoy_server");
	errind->er_tag = ERT_TD;
	return;
    }
	
    errind->er_ret = OK;
} /* ftam_destroy_server */

/*  */

ftam_report_error(err, str)
    error_t *err;
    char *str;
{
    struct FTAMabort *fta;
    int i;


    pprintf("ftam_report_error(0x%x)\n", err);
    
    if (err == NULL) {
	eprintf(EF_SYSCALL, COMMUNICATION, "Error", str,
	       getsyserr());
	return;
    } 
    
    switch (err->er_tag) {
    case ERT_NONE:
	/* error already reported */
	break;
    case ERT_FTI:
	fta = &err->er_fti.fti_abort;	    
	if (err->er_fti.fti_type != FTI_ABORT) {
	    eprintf(EF_IN4X, INTERNAL, "tag", "FTAMindication",
		   "Doesn't contain FTI_ABORT on failure");
	    eprintf("\tIndication type: %d from %s\n",
		    err->er_fti.fti_type, str);
  	    return;
	}
	eprintf(EF_IN4X, COMMUNICATION, "FTAM protocol", str,
	       (fta->fta_peer) ? "User-initiated abort" :
	       "Provider-initiated abort");
	for (i = 0; i < fta->fta_ndiag; i++) {
	    eprintf("\t%s\n",
		    FErrString(fta->fta_diags[i].ftd_identifier));
	    if (fta->fta_diags[i].ftd_cc > 0)
		eprintf("\tData: %*.*s\n",
			fta->fta_diags[i].ftd_cc,
			fta->fta_diags[i].ftd_cc,
			fta->fta_diags[i].ftd_data);
	}
	break;
    case ERT_TD:
	eprintf(EF_IN4X, COMMUNICATION, "FTAM", str,
	       TErrString(err->er_td.td_reason));
	if (err->er_td.td_cc > 0)
	    eprintf("\tData: %*.*s\n", err->er_td.td_cc,
		    err->er_td.td_cc, err->er_td.td_data);
	break;
    default:
	eprintf(EF_IN4, INTERNAL, PARAMETER, "ftam_report_error",
	       "Unknow tag in error_t structure");
	return;
    }

} /* ftam_report_error */

/*  */

#ifdef ASCII

int	copyascii (src, dst, amount, direction)
char *src, *dst;
int amount, direction;
{
    register int    i, src_char, dst_char;
    register char  *bp, *cp;

    if (direction) {
      src_char = '\n';
      dst_char = '\r';
    }
    else {
      src_char = '\r';
      dst_char = '\n';
    }

    bp = src;
    cp = dst;
    for (i = amount; --amount >= 0; ++bp) {
      if (*bp == src_char)
	*cp++ = dst_char;
      else
	*cp++ = *bp;
    }
}

#endif
