/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Template for initiator measurement procedure
 *
 */

#include <general.h>
#include <protospec.h>
#include <measproc.h>

int template(be, addr, srchdl, dsthdl, mt)
    struct bench 	*be;
    struct address_t 	*addr;
    iohdl_t 		*srchdl, *dsthdl;
    metrics_t 		*mt;		/* out parameter */
{
    INITIATOR_VARIABLES;
    TIMING_VARIABLES(0);	/* One or more timing varaibles. The number is
				   the number in the timing list in
				   the measurement specification */
    channel_t 		ch;

    TIMING_INITIATE(0);		/* For each timing variable */

    mprintf("template(src 0x%x, dst 0x%x, mt 0x%x)\n",
		srchdl, dsthdl, mt);

    /* E.g. connection setup here */
    
    INITIATOR_BEFORE_START;
    
    StartMeasurements(mt);

    INITIATOR_AFTER_START;

    for (i = 0; i < iterations; i++) {
	if (interupted)
	    break;

	/* USe these for getting the data unit size */
	INITIATOR_SENDSIZE(msgsize, i);
	INITIATOR_RECVSIZE(msgsize, i);

	/* Use these for "producing" and "consuming" data */
	if ((*srchdl->io_get)(srchdl, msgsize) == NOTOK) {
	    report_error(NULL, "io_get");
	    goto abort;
	}
	if ((*dsthdl->io_put)(dsthdl, msgsize) == NOTOK) {
	    report_error(NULL, "io_put");
	    goto abort;
	}

	/* Use these for updating the number of bytes received/sent */
	MetricsAddDatarcvd(mt, msgsize);
	MetricsAddDatasent(mt, msgsize);

	/* Insert these where you want delays */
        TIMING_DELAY(0);
    }
	
    StopMeasurements(mt);
    if (interupted)
	mt->mt_exit = MT_EXIT_INT;

    /* E.g. disconnect here */
    
    return OK;

 abort:
    return NOTOK;
    
} /* template */
