/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Structure used for statistical computations
 */

typedef struct {
    double	st_exitstatus;	
    double	st_starttime;
    double	st_stoptime;
    double 	st_elapsed;	/* elapsed time */
    double	st_cputime;
    double	st_stime;	/* system portion of cpu time */
    double	st_utime;	/* user portion */
    double	st_delay;	/* total delay time in millsecs*/
    double	st_datasent;
    double	st_datarcvd;
    double	st_msgsent;
    double	st_msgrcvd;
    double	st_packsent;
    double	st_packrcvd;
    double	st_signals;
    double	st_blockout;
    double	st_blockin;
    double	st_pageio;	/* page faults causing i/o */
    double	st_pagerecl;	/* page faults satisfied by page reclaims */
    double	st_swaps;
    double	st_ivcsw;	/* number of involontary context switches */
    double	st_vcsw;	/* number of volontary context switches */
    double	st_maxrss;
} statistics_t;

/*
 * The constants below shoul be the same as those in metrics.h
 */
#define ST_UNDEF	(double)-1

/* Exit flags */
#define ST_EXIT_OK	(double)0
#define ST_EXIT_INT	(double)1	/* max time for benchmark expired */
#define ST_EXIT_KILLED	(double)2


/* Routines */
extern AverageStats();
		/* (stalen: int; sta: *statistics_t[]; st: *statistics_t) */
extern MiddleStats();
		/* (stalen: int; sta: *statistics_t[]; st: *statistics_t) */
extern MinStats();
		/* (stalen: int; sta: *statistics_t[]; st: *statistics_t) */
extern MaxStats();
		/* (stalen: int; sta: *statistics_t[]; st: *statistics_t) */
extern StdDevStats();
	/* (stalen: int; sta: *statistics_t[]; avg, st: *statistics_t) */
	/* requires the average to be computed and placed in avg! */


	
    
