/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * State for the state machines
 */

#ifndef _STATEH_
#define _STATEH_

typedef enum {
    UNKNOWN,	/* children before being intialized */
    IDLE,	/* ready to run benchmarks */
    CREATING,	/* between CREATE and corresponding OK */
    SETUP,	/* between SPEC and corresponding ADDR/SERVERS */
    WAIT_INIT,	/* between ADDR and corresponding OK (BENCH only) */

    INIT,		/* ready to start */
    WAIT_STARTED,	/* between START and STARTED */
    EXECUTING,		/* actually running the benchmark procedure */
    WAIT_STOPPED,	/* between STOP and STOPPED */
    
    WAIT_TERM,		/* waiting for TERMINATED after MSG_TERMINATE */

    TAREDOWN,	/* between DESTROY and DESTROYED */
    RESETTING,	/* between RESET and the corresponding OK */
    FAILING,	/* between TERMINATE and TERMINATED when FAILURE */
    ABORTING,	/* betwenn ABORT and ABORTED */
    DEAD,	/* procedure has been killed */
    } state_t;

/*  */

/*
 * Exports from state.c:
 */
int	checktransition();
int	parentstate2timeout();
int	childstate2timeout();

int 	alloc_childstate();
int 	set_state();
int 	check_state();
int 	set_fg_client_state();
int 	check_bg_client_state();
int 	set_result();
int 	set_addr();
int 	get_results();
struct address_t *get_addr();

state_t	get_state();
int	set_statebackground();
int	get_statebackground();
char 	*state2str();

#endif _STATEH_
