/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * Macros used in the measurement procedures
 */

#define INITIATOR_VARIABLES \
    int 		priority = basic_priority(be); \
    struct datasp 	*dt = basic_data(be); \
    register int 	iterations = datasp_iterations(dt); \
    register int 	i; \
    double 		delaytime; \
    register int	msgsize; \
    error_t 		error

#define RESPONDER_VARIABLES	INITIATOR_VARIABLES

#define INITIATOR_BEFORE_START \
{ \
    if (priority) \
	reduce_priority(priority); \
}

#define INITIATOR_AFTER_START \
{ \
    /* If we're background send a STARTED message!  */ \
    if (basic_background(be)) { \
	(void)send_started(); \
    } \
}	

#define RESPONDER_BEFORE_START	INITIATOR_BEFORE_START


#define INITIATOR_RECVSIZE(msgsize, i) \
	msgsize = msize_value(sizespec_recvmsg(datasp_size(dt)), i);
#define INITIATOR_SENDSIZE(msgsize, i) \
	msgsize = msize_value(sizespec_sendmsg(datasp_size(dt)), i);
#define RESPONDER_RECVSIZE	INITIATOR_SENDSIZE
#define RESPONDER_SENDSIZE	INITIATOR_RECVSIZE


/*
 * Timing macros: index the 0 for the first element in the timing list,
 * 2 for the second, et.c.
 */

#define TIMING_VARIABLES(index) \
  struct timing 	*ti/**/index
    

#define TIMING_INITIATE(index) \
{ \
    struct timing *ti = basic_timing(be); \
    int i; \
 \
    for (i = 0; i < index; i++) \
	if (ti != NULLTI) \
	    ti = timing_next(ti); \
    ti/**/index = ti; \
}

#define TIMING_DELAY(index) \
	if (ti/**/index != NULLTI) { \
	     delaytime = timing_value(ti/**/index, i); \
	     mprintf("Delaying %f s\n", delaytime); \
	     MetricsAddDelay(mt, delaytime); \
	     bench_delay(delaytime); \
	 }






