/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The Benchmark Control Protocol - presentation level
 */

/*
 * Data structure used for MSG_SPEC:
 *	See struct spec in spec.h
 *
 * Data structure used for MSG_ADDR:
 *	See addess_t in protospec.h (protocol specific)
 *
 * Data structure used for MSG_TERMINATED and MSG_STOPPED
 *	See statistics_t in statistics.h
 *
 * Data structure used for MSG_FAILURE:
 *	char * - a printable user diagnostics string
 */

/*  */

/*
 * Exports:
 * All the expoerted routines return dynamically allocated data - use:
 *	free(char *)
 *	spec_free(struct spec *)
 *	statistics_free(statistics_t *)
 *	address_free(struct address_t *)
 */
extern char *spec2str();
extern struct spec *str2spec();

extern char *statistics2str();
extern statistics_t *str2statistics();

extern char *basic2str();
extern struct bench *str2basic();

extern char *comp2str();
extern struct bench *str2comp();

extern double str2time();

/* From elsewhere */
extern char *address2str();
extern struct address_t *str2address();
extern struct address_t *address_copy();

