/* The SPIMS software is covered by a license. The use of the software */
/* represents acceptance of the terms and conditions in the license. */
/* ****************************************************************** */
/* Copyright (c) 1989, Swedish Institute of Computer Science */
/*
 * The bivalue(n1, n2, n1portion) distribution
 * n1portion must be between 0 and 1!!
 *
 * Additional parameters are ignored!
 */

#include <general.h>


double bivalue(pm)
    struct param *pm;
{
    double n1portion, value1, value2;
    int nparam;

    tprintf("bivalue() called!\n");

    nparam = param_nvalues(pm);
    if (nparam < 3) {
	eprintf(EF_IN4X, SPECIFICATION, "to few parameters",
	       "bivalue distribution",
	       "Requires three parameters");
	return 0.0;
    }
    if (nparam > 3) {
	eprintf(EF_IN4X, SPECIFICATION, "to many parameters",
	       "bivalue distribution",
	       "Requires three parameters");
    }

    value1 = param_getvalue(pm, 0);
    value2 = param_getvalue(pm, 1);
    n1portion = param_getvalue(pm, 2);

    if (n1portion <= 0 || n1portion >= 1) {
	eprintf(EF_IN4X, SPECIFICATION, PARAMETER,
	       "bivalue distribution\n",
	       "The third parameter must be between 0 and 1");
    }
    return (bench_rand() < n1portion) ? value1 : value2;
} /* bivalue */



	
	
