/***************************************
  $Revision: 1.1 $

  Radix tree (rx).  er_RX_errors.h - definition of errors for the radix module

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* step 1 */

typedef enum {
	 LOW_RP_OK=0,
	 LOW_RP_NOTREE,
	 LOW_RP_TRALEX,
	 LOW_RP_NOYETI,
	 LOW_RP_BADKEY
} RP_err_code_t;

/* step 2 */

#define RP_OK		ER_SEV_I + (FAC_RP<<16) + LOW_RP_OK
#define RP_NOTREE       ER_SEV_E + (FAC_RP<<16) + LOW_RP_NOTREE
#define RP_TRALEX       ER_SEV_E + (FAC_RP<<16) + LOW_RP_TRALEX
#define RP_NOYETI       ER_SEV_E + (FAC_RP<<16) + LOW_RP_NOYETI
#define RP_BADKEY       ER_SEV_E + (FAC_RP<<16) + LOW_RP_BADKEY 

/* step 3 */

#ifdef ER_IMPL

er_list_t RP_mod_err[]={
  { ERDUP(RP_OK),  	"OK" },
  { ERDUP(RP_NOTREE),  	"No such tree" },
  { ERDUP(RP_TRALEX),  	"Tree already exists" }, 
  { ERDUP(RP_NOYETI),  	"Not yet implemented" },
  { ERDUP(RP_BADKEY),   "Bad key" },
  ER_LASTTXT
};

#endif /* ER_IMPL */
